/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.model.recon;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import com.google.refine.model.Cell;
import com.google.refine.model.Project;
import com.google.refine.model.Recon;
import com.google.refine.model.Row;
import com.google.refine.model.recon.ReconConfigResolver;
import com.google.refine.model.recon.ReconJob;
import com.google.refine.util.ParsingUtilities;
import edu.mit.simile.butterfly.ButterflyModule;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeInfo(use=JsonTypeInfo.Id.CUSTOM, include=JsonTypeInfo.As.PROPERTY, property="mode")
@JsonTypeIdResolver(value=ReconConfigResolver.class)
public abstract class ReconConfig {
    protected static final Logger LOGGER = LoggerFactory.getLogger((String)"recon-config");
    public static final Map<String, List<Class<? extends ReconConfig>>> s_opNameToClass = new HashMap<String, List<Class<? extends ReconConfig>>>();
    public static final Map<Class<? extends ReconConfig>, String> s_opClassToName = new HashMap<Class<? extends ReconConfig>, String>();

    public static void registerReconConfig(ButterflyModule module, String name, Class<? extends ReconConfig> klass) {
        String key = module.getName() + "/" + name;
        s_opClassToName.put(klass, key);
        List<Class<? extends ReconConfig>> classes = s_opNameToClass.get(key);
        if (classes == null) {
            classes = new LinkedList<Class<? extends ReconConfig>>();
            s_opNameToClass.put(key, classes);
        }
        classes.add(klass);
    }

    public static Class<? extends ReconConfig> getClassFromMode(String mode) {
        if ("extend".equals(mode) || "strict".equals(mode)) {
            mode = "freebase/" + (String)mode;
        } else if ("heuristic".equals(mode)) {
            mode = "core/standard-service";
        } else if (!((String)mode).contains("/")) {
            mode = "core/" + (String)mode;
        }
        List<Class<? extends ReconConfig>> classes = s_opNameToClass.get(mode);
        if (classes != null && classes.size() > 0) {
            return classes.get(classes.size() - 1);
        }
        return null;
    }

    public static ReconConfig reconstruct(String json) throws Exception {
        return (ReconConfig)ParsingUtilities.mapper.readValue(json, ReconConfig.class);
    }

    @Deprecated
    @JsonIgnore
    public abstract int getBatchSize();

    @JsonIgnore
    public abstract int getBatchSize(int var1);

    public abstract String getBriefDescription(Project var1, String var2);

    public abstract ReconJob createJob(Project var1, int var2, Row var3, String var4, Cell var5);

    public abstract List<Recon> batchRecon(List<ReconJob> var1, long var2);

    public abstract Recon createNewRecon(long var1);

    public void save(Writer writer) {
        try {
            ParsingUtilities.defaultWriter.writeValue(writer, (Object)this);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @JsonIgnore
    public abstract String getMode();
}

