/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.model.changes;

import com.google.refine.ProjectManager;
import com.google.refine.history.Change;
import com.google.refine.model.Project;
import com.google.refine.model.Row;
import com.google.refine.util.Pool;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;

public class RowAdditionChange
implements Change {
    private final List<Row> _additionalRows;
    private final int _insertionIndex;
    private static String COUNT_FIELD = "count";
    private static String INDEX_FIELD = "index";
    private static String EOC = "/ec/";

    public RowAdditionChange(List<Row> additionalRows, int insertionIndex) {
        this._additionalRows = additionalRows;
        this._insertionIndex = insertionIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void apply(Project project) {
        Project project2 = project;
        synchronized (project2) {
            project.rows.addAll(this._insertionIndex, this._additionalRows.stream().map(row -> row.deepCopy()).collect(Collectors.toList()));
            project.update();
            project.columnModel.clearPrecomputes();
            ProjectManager.singleton.getLookupCacheManager().flushLookupsInvolvingProject(project.id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void revert(Project project) {
        Project project2 = project;
        synchronized (project2) {
            int startIndex = this._insertionIndex;
            int endIndex = this._insertionIndex + this._additionalRows.size();
            project.rows.subList(startIndex, endIndex).clear();
            project.columnModel.clearPrecomputes();
            ProjectManager.singleton.getLookupCacheManager().flushLookupsInvolvingProject(project.id);
            project.update();
        }
    }

    @Override
    public void save(Writer writer, Properties options) throws IOException {
        writer.write(INDEX_FIELD + "=");
        writer.write(Integer.toString(this._insertionIndex));
        writer.write(10);
        writer.write(COUNT_FIELD + "=");
        writer.write(Integer.toString(this._additionalRows.size()));
        writer.write(10);
        for (Row row : this._additionalRows) {
            row.save(writer, options);
            writer.write(10);
        }
        writer.write(EOC + "\n");
    }

    public static Change load(LineNumberReader reader, Pool pool) throws Exception {
        String line;
        ArrayList<Row> rows = new ArrayList<Row>();
        int index = 0;
        while ((line = reader.readLine()) != null && !EOC.equals(line)) {
            int equal = line.indexOf(61);
            CharSequence field = line.subSequence(0, equal);
            if (INDEX_FIELD.contentEquals(field)) {
                index = Integer.parseInt(line.substring(equal + 1));
                continue;
            }
            if (!COUNT_FIELD.contentEquals(field)) continue;
            int count = Integer.parseInt(line.substring(equal + 1));
            for (int i = 0; i < count; ++i) {
                line = reader.readLine();
                if (line == null) continue;
                rows.add(Row.load(line, pool));
            }
        }
        return new RowAdditionChange(rows, index);
    }
}

