/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.model.changes;

import com.google.refine.ProjectManager;
import com.google.refine.history.Change;
import com.google.refine.model.Column;
import com.google.refine.model.ColumnGroup;
import com.google.refine.model.Project;
import com.google.refine.model.Row;
import com.google.refine.model.changes.ColumnChange;
import com.google.refine.util.Pool;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;

public class MassRowColumnChange
implements Change {
    protected final List<Column> _newColumns;
    protected final List<Row> _newRows;
    protected List<Column> _oldColumns;
    protected List<Row> _oldRows;
    protected List<ColumnGroup> _oldColumnGroups;

    public MassRowColumnChange(List<Column> newColumns, List<Row> newRows) {
        this._newColumns = newColumns;
        this._newRows = newRows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void apply(Project project) {
        Project project2 = project;
        synchronized (project2) {
            if (this._oldColumnGroups == null) {
                this._oldColumnGroups = new ArrayList<ColumnGroup>(project.columnModel.columnGroups);
            }
            if (this._oldColumns == null) {
                this._oldColumns = new ArrayList<Column>(project.columnModel.columns);
            }
            if (this._oldRows == null) {
                this._oldRows = new ArrayList<Row>(project.rows);
            }
            project.columnModel.columns.clear();
            project.columnModel.columns.addAll(this._newColumns);
            project.columnModel.columnGroups.clear();
            project.rows.clear();
            project.rows.addAll(this._newRows);
            ProjectManager.singleton.getLookupCacheManager().flushLookupsInvolvingProject(project.id);
            project.update();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void revert(Project project) {
        Project project2 = project;
        synchronized (project2) {
            project.columnModel.columns.clear();
            project.columnModel.columns.addAll(this._oldColumns);
            project.columnModel.columnGroups.clear();
            project.columnModel.columnGroups.addAll(this._oldColumnGroups);
            project.rows.clear();
            project.rows.addAll(this._oldRows);
            ProjectManager.singleton.getLookupCacheManager().flushLookupsInvolvingProject(project.id);
            project.update();
        }
    }

    @Override
    public void save(Writer writer, Properties options) throws IOException {
        writer.write("newColumnCount=");
        writer.write(Integer.toString(this._newColumns.size()));
        writer.write(10);
        for (Column column : this._newColumns) {
            column.save(writer);
            writer.write(10);
        }
        writer.write("oldColumnCount=");
        writer.write(Integer.toString(this._oldColumns.size()));
        writer.write(10);
        for (Column column : this._oldColumns) {
            column.save(writer);
            writer.write(10);
        }
        writer.write("newRowCount=");
        writer.write(Integer.toString(this._newRows.size()));
        writer.write(10);
        for (Row row : this._newRows) {
            row.save(writer, options);
            writer.write(10);
        }
        writer.write("oldRowCount=");
        writer.write(Integer.toString(this._oldRows.size()));
        writer.write(10);
        for (Row row : this._oldRows) {
            row.save(writer, options);
            writer.write(10);
        }
        ColumnChange.writeOldColumnGroups(writer, options, this._oldColumnGroups);
        writer.write("/ec/\n");
    }

    public static Change load(LineNumberReader reader, Pool pool) throws Exception {
        String line;
        ArrayList<Column> oldColumns = null;
        ArrayList<Column> newColumns = null;
        List<Object> oldColumnGroups = null;
        ArrayList<Row> oldRows = null;
        ArrayList<Row> newRows = null;
        while ((line = reader.readLine()) != null && !"/ec/".equals(line)) {
            int i;
            int count;
            int equal = line.indexOf(61);
            CharSequence field = line.subSequence(0, equal);
            if ("oldRowCount".equals(field)) {
                count = Integer.parseInt(line.substring(equal + 1));
                oldRows = new ArrayList<Row>(count);
                for (i = 0; i < count; ++i) {
                    line = reader.readLine();
                    if (line == null) continue;
                    oldRows.add(Row.load(line, pool));
                }
                continue;
            }
            if ("newRowCount".equals(field)) {
                count = Integer.parseInt(line.substring(equal + 1));
                newRows = new ArrayList<Row>(count);
                for (i = 0; i < count; ++i) {
                    line = reader.readLine();
                    if (line == null) continue;
                    newRows.add(Row.load(line, pool));
                }
                continue;
            }
            if ("oldColumnCount".equals(field)) {
                count = Integer.parseInt(line.substring(equal + 1));
                oldColumns = new ArrayList<Column>(count);
                for (i = 0; i < count; ++i) {
                    line = reader.readLine();
                    if (line == null) continue;
                    oldColumns.add(Column.load(line));
                }
                continue;
            }
            if ("newColumnCount".equals(field)) {
                count = Integer.parseInt(line.substring(equal + 1));
                newColumns = new ArrayList<Column>(count);
                for (i = 0; i < count; ++i) {
                    line = reader.readLine();
                    if (line == null) continue;
                    newColumns.add(Column.load(line));
                }
                continue;
            }
            if (!"oldColumnGroupCount".equals(field)) continue;
            int oldColumnGroupCount = Integer.parseInt(line.substring(equal + 1));
            oldColumnGroups = ColumnChange.readOldColumnGroups(reader, oldColumnGroupCount);
        }
        MassRowColumnChange change = new MassRowColumnChange(newColumns, newRows);
        change._oldColumns = oldColumns;
        change._oldRows = oldRows;
        change._oldColumnGroups = oldColumnGroups != null ? oldColumnGroups : new LinkedList();
        return change;
    }
}

