/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.model.changes;

import com.google.refine.ProjectManager;
import com.google.refine.history.Change;
import com.google.refine.model.Project;
import com.google.refine.model.Row;
import com.google.refine.util.Pool;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class MassRowChange
implements Change {
    protected final List<Row> _newRows;
    protected List<Row> _oldRows;

    public MassRowChange(List<Row> newRows) {
        this._newRows = newRows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void apply(Project project) {
        Project project2 = project;
        synchronized (project2) {
            this._oldRows = new ArrayList<Row>(project.rows);
            project.rows.clear();
            project.rows.addAll(this._newRows);
            project.columnModel.clearPrecomputes();
            ProjectManager.singleton.getLookupCacheManager().flushLookupsInvolvingProject(project.id);
            project.update();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void revert(Project project) {
        Project project2 = project;
        synchronized (project2) {
            project.rows.clear();
            project.rows.addAll(this._oldRows);
            project.columnModel.clearPrecomputes();
            ProjectManager.singleton.getLookupCacheManager().flushLookupsInvolvingProject(project.id);
            project.update();
        }
    }

    @Override
    public void save(Writer writer, Properties options) throws IOException {
        writer.write("newRowCount=");
        writer.write(Integer.toString(this._newRows.size()));
        writer.write(10);
        for (Row row : this._newRows) {
            row.save(writer, options);
            writer.write(10);
        }
        writer.write("oldRowCount=");
        writer.write(Integer.toString(this._oldRows.size()));
        writer.write(10);
        for (Row row : this._oldRows) {
            row.save(writer, options);
            writer.write(10);
        }
        writer.write("/ec/\n");
    }

    public static Change load(LineNumberReader reader, Pool pool) throws Exception {
        String line;
        ArrayList<Row> oldRows = null;
        ArrayList<Row> newRows = null;
        while ((line = reader.readLine()) != null && !"/ec/".equals(line)) {
            int i;
            int count;
            int equal = line.indexOf(61);
            CharSequence field = line.subSequence(0, equal);
            if ("oldRowCount".equals(field)) {
                count = Integer.parseInt(line.substring(equal + 1));
                oldRows = new ArrayList<Row>(count);
                for (i = 0; i < count; ++i) {
                    line = reader.readLine();
                    if (line == null) continue;
                    oldRows.add(Row.load(line, pool));
                }
                continue;
            }
            if (!"newRowCount".equals(field)) continue;
            count = Integer.parseInt(line.substring(equal + 1));
            newRows = new ArrayList<Row>(count);
            for (i = 0; i < count; ++i) {
                line = reader.readLine();
                if (line == null) continue;
                newRows.add(Row.load(line, pool));
            }
        }
        MassRowChange change = new MassRowChange(newRows);
        change._oldRows = oldRows;
        return change;
    }
}

