/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.model.changes;

import com.google.refine.ProjectManager;
import com.google.refine.history.Change;
import com.google.refine.model.Cell;
import com.google.refine.model.Project;
import com.google.refine.model.Recon;
import com.google.refine.model.Row;
import com.google.refine.util.ParsingUtilities;
import com.google.refine.util.Pool;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;

public class MassReconChange
implements Change {
    protected final Map<Long, Recon> _newRecons;
    protected final Map<Long, Recon> _oldRecons;

    public MassReconChange(Map<Long, Recon> newRecons, Map<Long, Recon> oldRecons) {
        this._newRecons = newRecons;
        this._oldRecons = oldRecons;
    }

    @Override
    public void apply(Project project) {
        this.switchRecons(project, this._newRecons);
    }

    @Override
    public void revert(Project project) {
        this.switchRecons(project, this._oldRecons);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void switchRecons(Project project, Map<Long, Recon> reconMap) {
        Project project2 = project;
        synchronized (project2) {
            HashSet<String> flushedColumn = new HashSet<String>();
            for (Row row : project.rows) {
                for (int c = 0; c < row.cells.size(); ++c) {
                    Cell cell = row.cells.get(c);
                    if (cell == null || cell.recon == null) continue;
                    Recon recon = cell.recon;
                    if (!reconMap.containsKey(recon.id)) continue;
                    String columnName = project.columnModel.getColumnByCellIndex(c).getName();
                    if (!flushedColumn.contains(columnName)) {
                        ProjectManager.singleton.getLookupCacheManager().flushLookupsInvolvingProjectColumn(project.id, columnName);
                        flushedColumn.add(columnName);
                    }
                    row.setCell(c, new Cell(cell.value, reconMap.get(recon.id)));
                }
            }
        }
    }

    @Override
    public void save(Writer writer, Properties options) throws IOException {
        this.writeRecons(writer, options, this._oldRecons, "oldReconCount");
        this.writeRecons(writer, options, this._newRecons, "newReconCount");
        writer.write("/ec/\n");
    }

    protected void writeRecons(Writer writer, Properties options, Map<Long, Recon> recons, String key) throws IOException {
        writer.write(key + "=");
        writer.write(Integer.toString(recons.size()));
        writer.write(10);
        for (Recon recon : recons.values()) {
            Pool pool = (Pool)options.get("pool");
            pool.poolReconCandidates(recon);
            ParsingUtilities.saveWriter.writeValue(writer, (Object)recon);
            writer.write("\n");
        }
    }

    public static Change load(LineNumberReader reader, Pool pool) throws Exception {
        String line;
        HashMap<Long, Recon> oldRecons = new HashMap<Long, Recon>();
        HashMap<Long, Recon> newRecons = new HashMap<Long, Recon>();
        while ((line = reader.readLine()) != null && !"/ec/".equals(line)) {
            int equal = line.indexOf(61);
            CharSequence field = line.subSequence(0, equal);
            String value = line.substring(equal + 1);
            if ("oldReconCount".equals(field)) {
                MassReconChange.loadRecons(reader, pool, oldRecons, value);
                continue;
            }
            if (!"newReconCount".equals(field)) continue;
            MassReconChange.loadRecons(reader, pool, newRecons, value);
        }
        MassReconChange change = new MassReconChange(newRecons, oldRecons);
        return change;
    }

    protected static void loadRecons(LineNumberReader reader, Pool pool, Map<Long, Recon> recons, String countString) throws Exception {
        int count = Integer.parseInt(countString);
        for (int i = 0; i < count; ++i) {
            String line = reader.readLine();
            Recon recon = Recon.loadStreaming(line);
            recons.put(recon.id, recon);
        }
    }
}

