/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.model.changes;

import com.google.common.collect.Lists;
import com.google.refine.history.Change;
import com.google.refine.history.History;
import com.google.refine.model.Project;
import com.google.refine.util.Pool;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class MassChange
implements Change {
    protected final List<? extends Change> _changes;
    protected final boolean _updateRowContextDependencies;

    public MassChange(List<? extends Change> changes, boolean updateRowContextDependencies) {
        this._changes = changes;
        this._updateRowContextDependencies = updateRowContextDependencies;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void apply(Project project) {
        Project project2 = project;
        synchronized (project2) {
            for (Change change : this._changes) {
                change.apply(project);
            }
            if (this._updateRowContextDependencies) {
                project.update();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void revert(Project project) {
        Project project2 = project;
        synchronized (project2) {
            for (Change change : Lists.reverse(this._changes)) {
                change.revert(project);
            }
            if (this._updateRowContextDependencies) {
                project.update();
            }
        }
    }

    @Override
    public void save(Writer writer, Properties options) throws IOException {
        writer.write("updateRowContextDependencies=");
        writer.write(Boolean.toString(this._updateRowContextDependencies));
        writer.write(10);
        writer.write("changeCount=");
        writer.write(Integer.toString(this._changes.size()));
        writer.write(10);
        for (Change change : this._changes) {
            History.writeOneChange(writer, change, options);
        }
        writer.write("/ec/\n");
    }

    public static Change load(LineNumberReader reader, Pool pool) throws Exception {
        String line;
        boolean updateRowContextDependencies = false;
        ArrayList<Change> changes = null;
        while ((line = reader.readLine()) != null && !"/ec/".equals(line)) {
            int equal = line.indexOf(61);
            CharSequence field = line.subSequence(0, equal);
            if ("updateRowContextDependencies".equals(field)) {
                updateRowContextDependencies = Boolean.parseBoolean(line.substring(equal + 1));
                continue;
            }
            if (!"changeCount".equals(field)) continue;
            int changeCount = Integer.parseInt(line.substring(equal + 1));
            changes = new ArrayList<Change>(changeCount);
            for (int i = 0; i < changeCount; ++i) {
                changes.add(History.readOneChange(reader, pool));
            }
        }
        MassChange change = new MassChange(changes, updateRowContextDependencies);
        return change;
    }
}

