/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.model.changes;

import com.google.refine.history.Change;
import com.google.refine.model.Cell;
import com.google.refine.model.Column;
import com.google.refine.model.ModelException;
import com.google.refine.model.Project;
import com.google.refine.model.Recon;
import com.google.refine.model.ReconCandidate;
import com.google.refine.model.ReconStats;
import com.google.refine.model.ReconType;
import com.google.refine.model.Row;
import com.google.refine.model.recon.DataExtensionReconConfig;
import com.google.refine.model.recon.ReconciledDataExtensionJob;
import com.google.refine.util.ParsingUtilities;
import com.google.refine.util.Pool;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class DataExtensionChange
implements Change {
    protected final String _baseColumnName;
    protected final String _service;
    protected final String _identifierSpace;
    protected final String _schemaSpace;
    protected final int _columnInsertIndex;
    protected final List<String> _columnNames;
    protected final List<ReconType> _columnTypes;
    protected final List<Integer> _rowIndices;
    protected final List<ReconciledDataExtensionJob.DataExtension> _dataExtensions;
    protected long _historyEntryID;
    protected int _firstNewCellIndex = -1;
    protected List<Row> _oldRows;
    protected List<Row> _newRows;

    public DataExtensionChange(String baseColumnName, String service, String identifierSpace, String schemaSpace, int columnInsertIndex, List<String> columnNames, List<ReconType> columnTypes, List<Integer> rowIndices, List<ReconciledDataExtensionJob.DataExtension> dataExtensions, long historyEntryID) {
        this._baseColumnName = baseColumnName;
        this._service = service;
        this._identifierSpace = identifierSpace;
        this._schemaSpace = schemaSpace;
        this._columnInsertIndex = columnInsertIndex;
        this._columnNames = columnNames;
        this._columnTypes = columnTypes;
        this._rowIndices = rowIndices;
        this._dataExtensions = dataExtensions;
        this._historyEntryID = historyEntryID;
    }

    protected DataExtensionChange(String baseColumnName, String service, String identifierSpace, String schemaSpace, int columnInsertIndex, List<String> columnNames, List<ReconType> columnTypes, List<Integer> rowIndices, List<ReconciledDataExtensionJob.DataExtension> dataExtensions, int firstNewCellIndex, List<Row> oldRows, List<Row> newRows) {
        this._baseColumnName = baseColumnName;
        this._service = service;
        this._identifierSpace = identifierSpace;
        this._schemaSpace = schemaSpace;
        this._columnInsertIndex = columnInsertIndex;
        this._columnNames = columnNames;
        this._columnTypes = columnTypes;
        this._rowIndices = rowIndices;
        this._dataExtensions = dataExtensions;
        this._firstNewCellIndex = firstNewCellIndex;
        this._oldRows = oldRows;
        this._newRows = newRows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void apply(Project project) {
        Project project2 = project;
        synchronized (project2) {
            int i;
            if (this._firstNewCellIndex < 0) {
                this._firstNewCellIndex = project.columnModel.allocateNewCellIndex();
                for (i = 1; i < this._columnNames.size(); ++i) {
                    project.columnModel.allocateNewCellIndex();
                }
                this._oldRows = new ArrayList<Row>(project.rows);
                this._newRows = new ArrayList<Row>(project.rows.size());
                int cellIndex = project.columnModel.getColumnByName(this._baseColumnName).getCellIndex();
                int keyCellIndex = project.columnModel.columns.get(project.columnModel.getKeyColumnIndex()).getCellIndex();
                int index = 0;
                int rowIndex = index < this._rowIndices.size() ? this._rowIndices.get(index).intValue() : this._oldRows.size();
                ReconciledDataExtensionJob.DataExtension dataExtension = index < this._rowIndices.size() ? this._dataExtensions.get(index) : null;
                ++index;
                HashMap<String, Recon> reconMap = new HashMap<String, Recon>();
                for (int r = 0; r < this._oldRows.size(); ++r) {
                    Row oldRow = this._oldRows.get(r);
                    if (r < rowIndex) {
                        this._newRows.add(oldRow.dup());
                        continue;
                    }
                    if (dataExtension == null || dataExtension.data.length == 0) {
                        this._newRows.add(oldRow);
                    } else {
                        Row firstNewRow = oldRow.dup();
                        this.extendRow(firstNewRow, dataExtension, 0, reconMap);
                        this._newRows.add(firstNewRow);
                        int r2 = r + 1;
                        for (int subR = 1; subR < dataExtension.data.length; ++subR) {
                            Row oldRow2;
                            if (r2 < project.rows.size() && (oldRow2 = project.rows.get(r2)).isCellBlank(cellIndex) && oldRow2.isCellBlank(keyCellIndex)) {
                                Row newRow = oldRow2.dup();
                                this.extendRow(newRow, dataExtension, subR, reconMap);
                                this._newRows.add(newRow);
                                ++r2;
                                continue;
                            }
                            Row newRow = new Row(cellIndex + this._columnNames.size());
                            this.extendRow(newRow, dataExtension, subR, reconMap);
                            this._newRows.add(newRow);
                        }
                        r = r2 - 1;
                    }
                    rowIndex = index < this._rowIndices.size() ? this._rowIndices.get(index).intValue() : this._oldRows.size();
                    dataExtension = index < this._rowIndices.size() ? this._dataExtensions.get(index) : null;
                    ++index;
                }
            }
            project.rows.clear();
            project.rows.addAll(this._newRows);
            for (i = 0; i < this._columnNames.size(); ++i) {
                String name = this._columnNames.get(i);
                int cellIndex = this._firstNewCellIndex + i;
                Column column = new Column(cellIndex, name);
                ReconType columnType = this._columnTypes.get(i);
                column.setReconConfig(new DataExtensionReconConfig(this._service, this._identifierSpace, this._schemaSpace, columnType));
                if (project.columnModel.getColumnByName(this._baseColumnName) != null) {
                    column.setSourceReconConfig(project.columnModel.getColumnByName(this._baseColumnName).getReconConfig());
                }
                ReconStats reconStats = ReconStats.create(project, cellIndex);
                if (reconStats.matchedTopics > 0) {
                    column.setReconStats(reconStats);
                }
                try {
                    project.columnModel.addColumn(this._columnInsertIndex + i, column, true);
                    this._columnNames.set(i, column.getName());
                    continue;
                }
                catch (ModelException modelException) {
                    // empty catch block
                }
            }
            project.update();
        }
    }

    protected void extendRow(Row row, ReconciledDataExtensionJob.DataExtension dataExtension, int extensionRowIndex, Map<String, Recon> reconMap) {
        Object[] values = dataExtension.data[extensionRowIndex];
        for (int c = 0; c < values.length; ++c) {
            Object value = values[c];
            Cell cell = null;
            if (value instanceof ReconCandidate) {
                Recon recon;
                ReconCandidate rc = (ReconCandidate)value;
                if (reconMap.containsKey(rc.id)) {
                    recon = reconMap.get(rc.id);
                } else {
                    recon = new Recon(this._historyEntryID, this._identifierSpace, this._schemaSpace);
                    recon.addCandidate(rc);
                    recon.service = this._service;
                    recon.match = rc;
                    recon.matchRank = 0;
                    recon.judgment = Recon.Judgment.Matched;
                    recon.judgmentAction = "auto";
                    recon.judgmentBatchSize = 1;
                    reconMap.put(rc.id, recon);
                }
                cell = new Cell((Serializable)((Object)rc.name), recon);
            } else {
                cell = value == null ? null : new Cell((Serializable)value, null);
            }
            row.setCell(this._firstNewCellIndex + c, cell);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void revert(Project project) {
        Project project2 = project;
        synchronized (project2) {
            project.rows.clear();
            project.rows.addAll(this._oldRows);
            for (int i = 0; i < this._columnNames.size(); ++i) {
                project.columnModel.columns.remove(this._columnInsertIndex);
            }
            project.update();
        }
    }

    @Override
    public void save(Writer writer, Properties options) throws IOException {
        writer.write("baseColumnName=");
        writer.write(this._baseColumnName);
        writer.write(10);
        writer.write("service=");
        writer.write(this._service);
        writer.write(10);
        writer.write("identifierSpace=");
        writer.write(this._identifierSpace);
        writer.write(10);
        writer.write("schemaSpace=");
        writer.write(this._schemaSpace);
        writer.write(10);
        writer.write("columnInsertIndex=");
        writer.write(Integer.toString(this._columnInsertIndex));
        writer.write(10);
        writer.write("columnNameCount=");
        writer.write(Integer.toString(this._columnNames.size()));
        writer.write(10);
        for (String name : this._columnNames) {
            writer.write(name);
            writer.write(10);
        }
        writer.write("columnTypeCount=");
        writer.write(Integer.toString(this._columnTypes.size()));
        writer.write(10);
        for (ReconType type : this._columnTypes) {
            if (type != null) {
                ParsingUtilities.defaultWriter.writeValue(writer, (Object)type);
            }
            writer.write(10);
        }
        writer.write("rowIndexCount=");
        writer.write(Integer.toString(this._rowIndices.size()));
        writer.write(10);
        for (Integer rowIndex : this._rowIndices) {
            writer.write(rowIndex.toString());
            writer.write(10);
        }
        writer.write("firstNewCellIndex=");
        writer.write(Integer.toString(this._firstNewCellIndex));
        writer.write(10);
        writer.write("newRowCount=");
        writer.write(Integer.toString(this._newRows.size()));
        writer.write(10);
        for (Row row : this._newRows) {
            row.save(writer, options);
            writer.write(10);
        }
        writer.write("oldRowCount=");
        writer.write(Integer.toString(this._oldRows.size()));
        writer.write(10);
        for (Row row : this._oldRows) {
            row.save(writer, options);
            writer.write(10);
        }
        writer.write("/ec/\n");
    }

    public static Change load(LineNumberReader reader, Pool pool) throws Exception {
        String line;
        String baseColumnName = null;
        String service = null;
        String identifierSpace = null;
        String schemaSpace = null;
        int columnInsertIndex = -1;
        ArrayList<String> columnNames = null;
        ArrayList<ReconType> columnTypes = null;
        ArrayList<Integer> rowIndices = null;
        ArrayList<Object> dataExtensions = null;
        ArrayList<Row> oldRows = null;
        ArrayList<Row> newRows = null;
        int firstNewCellIndex = -1;
        while ((line = reader.readLine()) != null && !"/ec/".equals(line)) {
            int i;
            int count;
            int equal = line.indexOf(61);
            CharSequence field = line.subSequence(0, equal);
            String value = line.substring(equal + 1);
            if ("baseColumnName".equals(field)) {
                baseColumnName = value;
                continue;
            }
            if ("service".equals(field)) {
                service = value;
                continue;
            }
            if ("identifierSpace".equals(field)) {
                identifierSpace = value;
                continue;
            }
            if ("schemaSpace".equals(field)) {
                schemaSpace = value;
                continue;
            }
            if ("columnInsertIndex".equals(field)) {
                columnInsertIndex = Integer.parseInt(value);
                continue;
            }
            if ("firstNewCellIndex".equals(field)) {
                firstNewCellIndex = Integer.parseInt(value);
                continue;
            }
            if ("rowIndexCount".equals(field)) {
                count = Integer.parseInt(value);
                rowIndices = new ArrayList<Integer>(count);
                for (i = 0; i < count; ++i) {
                    line = reader.readLine();
                    if (line == null) continue;
                    rowIndices.add(Integer.parseInt(line));
                }
                continue;
            }
            if ("columnNameCount".equals(field)) {
                count = Integer.parseInt(value);
                columnNames = new ArrayList<String>(count);
                for (i = 0; i < count; ++i) {
                    line = reader.readLine();
                    if (line == null) continue;
                    columnNames.add(line);
                }
                continue;
            }
            if ("columnTypeCount".equals(field)) {
                count = Integer.parseInt(value);
                columnTypes = new ArrayList<ReconType>(count);
                for (i = 0; i < count; ++i) {
                    line = reader.readLine();
                    if (line == null || line.length() == 0) {
                        columnTypes.add(null);
                        continue;
                    }
                    columnTypes.add(ReconType.load(line));
                }
                continue;
            }
            if ("dataExtensionCount".equals(field)) {
                count = Integer.parseInt(value);
                dataExtensions = new ArrayList<Object>(count);
                for (i = 0; i < count; ++i) {
                    line = reader.readLine();
                    if (line == null) continue;
                    if (line.length() == 0) {
                        dataExtensions.add(null);
                        continue;
                    }
                    int rowCount = Integer.parseInt(line);
                    for (int r = 0; r < rowCount; ++r) {
                        for (int c = 0; c < columnNames.size(); ++c) {
                            line = reader.readLine();
                        }
                    }
                }
                continue;
            }
            if ("oldRowCount".equals(field)) {
                count = Integer.parseInt(value);
                oldRows = new ArrayList<Row>(count);
                for (i = 0; i < count; ++i) {
                    line = reader.readLine();
                    if (line == null) continue;
                    oldRows.add(Row.load(line, pool));
                }
                continue;
            }
            if (!"newRowCount".equals(field)) continue;
            count = Integer.parseInt(value);
            newRows = new ArrayList<Row>(count);
            for (i = 0; i < count; ++i) {
                line = reader.readLine();
                if (line == null) continue;
                newRows.add(Row.load(line, pool));
            }
        }
        DataExtensionChange change = new DataExtensionChange(baseColumnName, service, identifierSpace, schemaSpace, columnInsertIndex, columnNames, columnTypes, rowIndices, dataExtensions, firstNewCellIndex, oldRows, newRows);
        return change;
    }
}

