/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.model.changes;

import com.google.refine.ProjectManager;
import com.google.refine.history.Change;
import com.google.refine.model.Cell;
import com.google.refine.model.Column;
import com.google.refine.model.ColumnGroup;
import com.google.refine.model.Project;
import com.google.refine.model.Row;
import com.google.refine.model.changes.ColumnChange;
import com.google.refine.util.ParsingUtilities;
import com.google.refine.util.Pool;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;

public class ColumnSplitChange
implements Change {
    protected final String _columnName;
    protected final List<String> _columnNames;
    protected final List<Integer> _rowIndices;
    protected final List<List<Serializable>> _tuples;
    protected final boolean _removeOriginalColumn;
    protected Column _column;
    protected int _columnIndex;
    protected int _firstNewCellIndex = -1;
    protected List<Row> _oldRows;
    protected List<Row> _newRows;
    protected List<ColumnGroup> _oldColumnGroups;

    public ColumnSplitChange(String columnName, List<String> columnNames, List<Integer> rowIndices, List<List<Serializable>> tuples, boolean removeOriginalColumn) {
        this._columnName = columnName;
        this._columnNames = columnNames;
        this._rowIndices = rowIndices;
        this._tuples = tuples;
        this._removeOriginalColumn = removeOriginalColumn;
    }

    protected ColumnSplitChange(String columnName, List<String> columnNames, List<Integer> rowIndices, List<List<Serializable>> tuples, boolean removeOriginalColumn, Column column, int columnIndex, int firstNewCellIndex, List<Row> oldRows, List<Row> newRows) {
        this._columnName = columnName;
        this._columnNames = columnNames;
        this._rowIndices = rowIndices;
        this._tuples = tuples;
        this._removeOriginalColumn = removeOriginalColumn;
        this._column = column;
        this._columnIndex = columnIndex;
        this._firstNewCellIndex = firstNewCellIndex;
        this._oldRows = oldRows;
        this._newRows = newRows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void apply(Project project) {
        Project project2 = project;
        synchronized (project2) {
            int i;
            if (this._firstNewCellIndex < 0) {
                this._firstNewCellIndex = project.columnModel.allocateNewCellIndex();
                for (int i2 = 1; i2 < this._columnNames.size(); ++i2) {
                    project.columnModel.allocateNewCellIndex();
                }
                ProjectManager.singleton.getLookupCacheManager().flushLookupsInvolvingProjectColumn(project.id, this._columnName);
                this._column = project.columnModel.getColumnByName(this._columnName);
                this._columnIndex = project.columnModel.getColumnIndexByName(this._columnName);
                this._oldRows = new ArrayList<Row>(this._rowIndices.size());
                this._newRows = new ArrayList<Row>(this._rowIndices.size());
                int cellIndex = this._column.getCellIndex();
                for (int i3 = 0; i3 < this._rowIndices.size(); ++i3) {
                    int r = this._rowIndices.get(i3);
                    List<Serializable> tuple = this._tuples.get(i3);
                    Row oldRow = project.rows.get(r);
                    Row newRow = oldRow.dup();
                    this._oldRows.add(oldRow);
                    this._newRows.add(newRow);
                    for (int c = 0; c < tuple.size(); ++c) {
                        Serializable value = tuple.get(c);
                        if (value == null) continue;
                        newRow.setCell(this._firstNewCellIndex + c, new Cell(value, null));
                    }
                    if (!this._removeOriginalColumn) continue;
                    newRow.setCell(cellIndex, null);
                }
            }
            int columnGroupCount = project.columnModel.columnGroups.size();
            int columnCountChange = this._columnNames.size() - (this._removeOriginalColumn ? 1 : 0);
            this._oldColumnGroups = new ArrayList<ColumnGroup>(columnGroupCount);
            for (i = columnGroupCount - 1; i >= 0; --i) {
                ColumnGroup columnGroup = project.columnModel.columnGroups.get(i);
                this._oldColumnGroups.add(columnGroup);
                if (columnGroup.startColumnIndex <= this._columnIndex) {
                    if (columnGroup.startColumnIndex + columnGroup.columnSpan <= this._columnIndex) continue;
                    if (columnGroup.keyColumnIndex == this._columnIndex) {
                        if (this._removeOriginalColumn) {
                            project.columnModel.columnGroups.remove(i);
                            continue;
                        }
                        project.columnModel.columnGroups.set(i, new ColumnGroup(columnGroup.startColumnIndex, columnGroup.columnSpan + columnCountChange, columnGroup.keyColumnIndex));
                        continue;
                    }
                    project.columnModel.columnGroups.set(i, new ColumnGroup(columnGroup.startColumnIndex, columnGroup.columnSpan + columnCountChange, columnGroup.keyColumnIndex < this._columnIndex ? columnGroup.keyColumnIndex : columnGroup.keyColumnIndex + columnCountChange));
                    continue;
                }
                project.columnModel.columnGroups.set(i, new ColumnGroup(columnGroup.startColumnIndex + columnCountChange, columnGroup.columnSpan, columnGroup.keyColumnIndex + columnCountChange));
            }
            for (i = 0; i < this._rowIndices.size(); ++i) {
                int r = this._rowIndices.get(i);
                Row newRow = this._newRows.get(i);
                project.rows.set(r, newRow);
            }
            for (i = 0; i < this._columnNames.size(); ++i) {
                String name = this._columnNames.get(i);
                int cellIndex = this._firstNewCellIndex + i;
                Column column = new Column(cellIndex, name);
                project.columnModel.columns.add(this._columnIndex + 1 + i, column);
            }
            if (this._removeOriginalColumn) {
                project.columnModel.columns.remove(this._columnIndex);
            }
            project.update();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void revert(Project project) {
        Project project2 = project;
        synchronized (project2) {
            int i;
            for (i = 0; i < this._rowIndices.size(); ++i) {
                int r = this._rowIndices.get(i);
                Row oldRow = this._oldRows.get(i);
                project.rows.set(r, oldRow);
            }
            if (this._removeOriginalColumn) {
                project.columnModel.columns.add(this._columnIndex, this._column);
            }
            for (i = 0; i < this._columnNames.size(); ++i) {
                project.columnModel.columns.remove(this._columnIndex + 1);
                ProjectManager.singleton.getLookupCacheManager().flushLookupsInvolvingProjectColumn(project.id, this._columnNames.get(i));
            }
            project.columnModel.columnGroups.clear();
            project.columnModel.columnGroups.addAll(this._oldColumnGroups);
            project.update();
        }
    }

    @Override
    public void save(Writer writer, Properties options) throws IOException {
        writer.write("columnName=");
        writer.write(this._columnName);
        writer.write(10);
        writer.write("columnNameCount=");
        writer.write(Integer.toString(this._columnNames.size()));
        writer.write(10);
        for (String string : this._columnNames) {
            writer.write(string);
            writer.write(10);
        }
        writer.write("rowIndexCount=");
        writer.write(Integer.toString(this._rowIndices.size()));
        writer.write(10);
        for (Integer n : this._rowIndices) {
            writer.write(n.toString());
            writer.write(10);
        }
        writer.write("tupleCount=");
        writer.write(Integer.toString(this._tuples.size()));
        writer.write(10);
        for (List list : this._tuples) {
            writer.write(Integer.toString(list.size()));
            writer.write(10);
            for (Serializable value : list) {
                if (value == null) {
                    writer.write("null");
                } else if (value instanceof String) {
                    writer.write(ParsingUtilities.mapper.writeValueAsString((Object)((String)((Object)value))));
                } else {
                    writer.write(value.toString());
                }
                writer.write(10);
            }
        }
        writer.write("removeOriginalColumn=");
        writer.write(Boolean.toString(this._removeOriginalColumn));
        writer.write(10);
        writer.write("column=");
        this._column.save(writer);
        writer.write(10);
        writer.write("columnIndex=");
        writer.write(Integer.toString(this._columnIndex));
        writer.write(10);
        writer.write("firstNewCellIndex=");
        writer.write(Integer.toString(this._firstNewCellIndex));
        writer.write(10);
        writer.write("newRowCount=");
        writer.write(Integer.toString(this._newRows.size()));
        writer.write(10);
        for (Row row : this._newRows) {
            row.save(writer, options);
            writer.write(10);
        }
        writer.write("oldRowCount=");
        writer.write(Integer.toString(this._oldRows.size()));
        writer.write(10);
        for (Row row : this._oldRows) {
            row.save(writer, options);
            writer.write(10);
        }
        ColumnChange.writeOldColumnGroups(writer, options, this._oldColumnGroups);
        writer.write("/ec/\n");
    }

    public static Change load(LineNumberReader reader, Pool pool) throws Exception {
        String line;
        String columnName = null;
        ArrayList<String> columnNames = null;
        ArrayList<Integer> rowIndices = null;
        ArrayList tuples = null;
        boolean removeOriginalColumn = false;
        Column column = null;
        int columnIndex = -1;
        int firstNewCellIndex = -1;
        ArrayList<Row> oldRows = null;
        ArrayList<Row> newRows = null;
        List<Object> oldColumnGroups = null;
        while ((line = reader.readLine()) != null && !"/ec/".equals(line)) {
            int i;
            int count;
            int equal = line.indexOf(61);
            CharSequence field = line.subSequence(0, equal);
            String value = line.substring(equal + 1);
            if ("columnName".equals(field)) {
                columnName = value;
                continue;
            }
            if ("columnNameCount".equals(field)) {
                count = Integer.parseInt(value);
                columnNames = new ArrayList<String>(count);
                for (i = 0; i < count; ++i) {
                    line = reader.readLine();
                    if (line == null) continue;
                    columnNames.add(line);
                }
                continue;
            }
            if ("rowIndexCount".equals(field)) {
                count = Integer.parseInt(value);
                rowIndices = new ArrayList<Integer>(count);
                for (i = 0; i < count; ++i) {
                    line = reader.readLine();
                    if (line == null) continue;
                    rowIndices.add(Integer.parseInt(line));
                }
                continue;
            }
            if ("tupleCount".equals(field)) {
                count = Integer.parseInt(value);
                tuples = new ArrayList(count);
                for (i = 0; i < count; ++i) {
                    line = reader.readLine();
                    if (line == null) continue;
                    int valueCount = Integer.parseInt(line);
                    ArrayList<Serializable> tuple = new ArrayList<Serializable>(valueCount);
                    for (int r = 0; r < valueCount; ++r) {
                        line = reader.readLine();
                        tuple.add((Serializable)ParsingUtilities.mapper.readValue(line, Object.class));
                    }
                    tuples.add(tuple);
                }
                continue;
            }
            if ("removeOriginalColumn".equals(field)) {
                removeOriginalColumn = Boolean.parseBoolean(value);
                continue;
            }
            if ("column".equals(field)) {
                column = Column.load(value);
                continue;
            }
            if ("columnIndex".equals(field)) {
                columnIndex = Integer.parseInt(value);
                continue;
            }
            if ("firstNewCellIndex".equals(field)) {
                firstNewCellIndex = Integer.parseInt(value);
                continue;
            }
            if ("oldRowCount".equals(field)) {
                count = Integer.parseInt(value);
                oldRows = new ArrayList<Row>(count);
                for (i = 0; i < count; ++i) {
                    line = reader.readLine();
                    if (line == null) continue;
                    oldRows.add(Row.load(line, pool));
                }
                continue;
            }
            if ("newRowCount".equals(field)) {
                count = Integer.parseInt(value);
                newRows = new ArrayList<Row>(count);
                for (i = 0; i < count; ++i) {
                    line = reader.readLine();
                    if (line == null) continue;
                    newRows.add(Row.load(line, pool));
                }
                continue;
            }
            if (!"oldColumnGroupCount".equals(field)) continue;
            int oldColumnGroupCount = Integer.parseInt(line.substring(equal + 1));
            oldColumnGroups = ColumnChange.readOldColumnGroups(reader, oldColumnGroupCount);
        }
        ColumnSplitChange change = new ColumnSplitChange(columnName, columnNames, rowIndices, tuples, removeOriginalColumn, column, columnIndex, firstNewCellIndex, oldRows, newRows);
        change._oldColumnGroups = oldColumnGroups != null ? oldColumnGroups : new LinkedList();
        return change;
    }
}

