/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.model.changes;

import com.google.refine.history.Change;
import com.google.refine.model.Cell;
import com.google.refine.model.Column;
import com.google.refine.model.ColumnGroup;
import com.google.refine.model.Project;
import com.google.refine.model.Row;
import com.google.refine.model.changes.CellAtRow;
import com.google.refine.model.changes.ColumnChange;
import com.google.refine.util.Pool;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;

public class ColumnRemovalChange
extends ColumnChange {
    protected final int _oldColumnIndex;
    protected Column _oldColumn;
    protected CellAtRow[] _oldCells;
    protected List<ColumnGroup> _oldColumnGroups;

    public ColumnRemovalChange(int index) {
        this._oldColumnIndex = index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void apply(Project project) {
        Project project2 = project;
        synchronized (project2) {
            int columnGroupCount = project.columnModel.columnGroups.size();
            this._oldColumnGroups = new ArrayList<ColumnGroup>(columnGroupCount);
            for (int i = columnGroupCount - 1; i >= 0; --i) {
                ColumnGroup columnGroup = project.columnModel.columnGroups.get(i);
                this._oldColumnGroups.add(columnGroup);
                if (columnGroup.startColumnIndex <= this._oldColumnIndex) {
                    if (columnGroup.startColumnIndex + columnGroup.columnSpan <= this._oldColumnIndex) continue;
                    if (columnGroup.keyColumnIndex == this._oldColumnIndex) {
                        project.columnModel.columnGroups.remove(i);
                        continue;
                    }
                    project.columnModel.columnGroups.set(i, new ColumnGroup(columnGroup.startColumnIndex, columnGroup.columnSpan - 1, columnGroup.keyColumnIndex < this._oldColumnIndex ? columnGroup.keyColumnIndex : columnGroup.keyColumnIndex - 1));
                    continue;
                }
                project.columnModel.columnGroups.set(i, new ColumnGroup(columnGroup.startColumnIndex - 1, columnGroup.columnSpan, columnGroup.keyColumnIndex - 1));
            }
            this._oldColumn = project.columnModel.columns.remove(this._oldColumnIndex);
            this._oldCells = new CellAtRow[project.rows.size()];
            int cellIndex = this._oldColumn.getCellIndex();
            for (int i = 0; i < this._oldCells.length; ++i) {
                Row row = project.rows.get(i);
                Cell oldCell = null;
                if (cellIndex < row.cells.size()) {
                    oldCell = row.cells.get(cellIndex);
                }
                this._oldCells[i] = new CellAtRow(i, oldCell);
                row.setCell(cellIndex, null);
            }
            project.update();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void revert(Project project) {
        Project project2 = project;
        synchronized (project2) {
            project.columnModel.columns.add(this._oldColumnIndex, this._oldColumn);
            int cellIndex = this._oldColumn.getCellIndex();
            for (CellAtRow cell : this._oldCells) {
                project.rows.get((int)cell.row).cells.set(cellIndex, cell.cell);
            }
            project.columnModel.columnGroups.clear();
            project.columnModel.columnGroups.addAll(this._oldColumnGroups);
            project.update();
        }
    }

    @Override
    public void save(Writer writer, Properties options) throws IOException {
        writer.write("oldColumnIndex=");
        writer.write(Integer.toString(this._oldColumnIndex));
        writer.write(10);
        writer.write("oldColumn=");
        this._oldColumn.save(writer);
        writer.write(10);
        writer.write("oldCellCount=");
        writer.write(Integer.toString(this._oldCells.length));
        writer.write(10);
        for (CellAtRow c : this._oldCells) {
            c.save(writer, options);
            writer.write(10);
        }
        ColumnRemovalChange.writeOldColumnGroups(writer, options, this._oldColumnGroups);
        writer.write("/ec/\n");
    }

    public static Change load(LineNumberReader reader, Pool pool) throws Exception {
        String line;
        int oldColumnIndex = -1;
        Column oldColumn = null;
        CellAtRow[] oldCells = null;
        List<Object> oldColumnGroups = null;
        while ((line = reader.readLine()) != null && !"/ec/".equals(line)) {
            int equal = line.indexOf(61);
            CharSequence field = line.subSequence(0, equal);
            if ("oldColumnIndex".equals(field)) {
                oldColumnIndex = Integer.parseInt(line.substring(equal + 1));
                continue;
            }
            if ("oldColumn".equals(field)) {
                oldColumn = Column.load(line.substring(equal + 1));
                continue;
            }
            if ("oldCellCount".equals(field)) {
                int oldCellCount = Integer.parseInt(line.substring(equal + 1));
                oldCells = new CellAtRow[oldCellCount];
                for (int i = 0; i < oldCellCount; ++i) {
                    line = reader.readLine();
                    if (line == null) continue;
                    oldCells[i] = CellAtRow.load(line, pool);
                }
                continue;
            }
            if (!"oldColumnGroupCount".equals(field)) continue;
            int oldColumnGroupCount = Integer.parseInt(line.substring(equal + 1));
            oldColumnGroups = ColumnRemovalChange.readOldColumnGroups(reader, oldColumnGroupCount);
        }
        ColumnRemovalChange change = new ColumnRemovalChange(oldColumnIndex);
        change._oldColumn = oldColumn;
        change._oldCells = oldCells;
        change._oldColumnGroups = oldColumnGroups != null ? oldColumnGroups : new LinkedList();
        return change;
    }
}

