/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.model.changes;

import com.google.refine.history.Change;
import com.google.refine.model.Column;
import com.google.refine.model.ColumnGroup;
import com.google.refine.model.Project;
import com.google.refine.model.changes.ColumnChange;
import com.google.refine.util.Pool;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;

public class ColumnMoveChange
extends ColumnChange {
    protected final String _columnName;
    protected final int _newColumnIndex;
    protected int _oldColumnIndex;
    protected List<ColumnGroup> _oldColumnGroups;

    public ColumnMoveChange(String columnName, int index) {
        this._columnName = columnName;
        this._newColumnIndex = index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void apply(Project project) {
        Project project2 = project;
        synchronized (project2) {
            this._oldColumnIndex = project.columnModel.getColumnIndexByName(this._columnName);
            if (this._oldColumnIndex < 0 || this._newColumnIndex < 0 || this._newColumnIndex > project.columnModel.getMaxCellIndex()) {
                throw new RuntimeException("Column index out of range");
            }
            if (this._oldColumnGroups == null) {
                this._oldColumnGroups = new ArrayList<ColumnGroup>(project.columnModel.columnGroups);
            }
            Column column = project.columnModel.columns.remove(this._oldColumnIndex);
            project.columnModel.columns.add(this._newColumnIndex, column);
            project.columnModel.columnGroups.clear();
            project.update();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void revert(Project project) {
        Project project2 = project;
        synchronized (project2) {
            Column column = project.columnModel.columns.remove(this._newColumnIndex);
            project.columnModel.columns.add(this._oldColumnIndex, column);
            project.columnModel.columnGroups.clear();
            project.columnModel.columnGroups.addAll(this._oldColumnGroups);
            project.update();
        }
    }

    @Override
    public void save(Writer writer, Properties options) throws IOException {
        writer.write("columnName=");
        writer.write(this._columnName);
        writer.write(10);
        writer.write("oldColumnIndex=");
        writer.write(Integer.toString(this._oldColumnIndex));
        writer.write(10);
        writer.write("newColumnIndex=");
        writer.write(Integer.toString(this._newColumnIndex));
        writer.write(10);
        ColumnMoveChange.writeOldColumnGroups(writer, options, this._oldColumnGroups);
        writer.write("/ec/\n");
    }

    public static Change load(LineNumberReader reader, Pool pool) throws Exception {
        String line;
        String columnName = null;
        int oldColumnIndex = -1;
        int newColumnIndex = -1;
        List<Object> oldColumnGroups = null;
        while ((line = reader.readLine()) != null && !"/ec/".equals(line)) {
            int equal = line.indexOf(61);
            CharSequence field = line.subSequence(0, equal);
            String value = line.substring(equal + 1);
            if ("oldColumnIndex".equals(field)) {
                oldColumnIndex = Integer.parseInt(value);
                continue;
            }
            if ("newColumnIndex".equals(field)) {
                newColumnIndex = Integer.parseInt(value);
                continue;
            }
            if ("columnName".equals(field)) {
                columnName = value;
                continue;
            }
            if (!"oldColumnGroupCount".equals(field)) continue;
            int oldColumnGroupCount = Integer.parseInt(line.substring(equal + 1));
            oldColumnGroups = ColumnMoveChange.readOldColumnGroups(reader, oldColumnGroupCount);
        }
        ColumnMoveChange change = new ColumnMoveChange(columnName, newColumnIndex);
        change._oldColumnIndex = oldColumnIndex;
        change._oldColumnGroups = oldColumnGroups != null ? oldColumnGroups : new LinkedList();
        return change;
    }
}

