/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.model.changes;

import com.google.refine.history.Change;
import com.google.refine.model.Column;
import com.google.refine.model.ColumnGroup;
import com.google.refine.model.Project;
import com.google.refine.model.Row;
import com.google.refine.model.changes.CellAtRow;
import com.google.refine.model.changes.ColumnChange;
import com.google.refine.util.Pool;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;

public class ColumnAdditionChange
extends ColumnChange {
    protected final String _columnName;
    protected final int _columnIndex;
    protected final CellAtRow[] _newCells;
    protected int _newCellIndex = -1;
    protected List<ColumnGroup> _oldColumnGroups;

    public ColumnAdditionChange(String columnName, int columnIndex, List<CellAtRow> newCells) {
        this._columnName = columnName;
        this._columnIndex = columnIndex;
        this._newCells = new CellAtRow[newCells.size()];
        newCells.toArray(this._newCells);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void apply(Project project) {
        Project project2 = project;
        synchronized (project2) {
            if (this._newCellIndex < 0) {
                this._newCellIndex = project.columnModel.allocateNewCellIndex();
            }
            int columnGroupCount = project.columnModel.columnGroups.size();
            this._oldColumnGroups = new ArrayList<ColumnGroup>(columnGroupCount);
            for (int i = columnGroupCount - 1; i >= 0; --i) {
                CellAtRow[] columnGroup = project.columnModel.columnGroups.get(i);
                this._oldColumnGroups.add((ColumnGroup)columnGroup);
                if (columnGroup.startColumnIndex <= this._columnIndex) {
                    if (columnGroup.startColumnIndex + columnGroup.columnSpan <= this._columnIndex) continue;
                    project.columnModel.columnGroups.set(i, new ColumnGroup(columnGroup.startColumnIndex, columnGroup.columnSpan + 1, columnGroup.keyColumnIndex < this._columnIndex ? columnGroup.keyColumnIndex : columnGroup.keyColumnIndex + 1));
                    continue;
                }
                project.columnModel.columnGroups.set(i, new ColumnGroup(columnGroup.startColumnIndex + 1, columnGroup.columnSpan, columnGroup.keyColumnIndex + 1));
            }
            Column column = new Column(this._newCellIndex, this._columnName);
            project.columnModel.columns.add(this._columnIndex, column);
            try {
                for (CellAtRow cell : this._newCells) {
                    project.rows.get(cell.row).setCell(this._newCellIndex, cell.cell);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            project.update();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void revert(Project project) {
        Project project2 = project;
        synchronized (project2) {
            for (CellAtRow cell : this._newCells) {
                Row row = project.rows.get(cell.row);
                row.setCell(this._newCellIndex, null);
            }
            project.columnModel.columns.remove(this._columnIndex);
            project.columnModel.columnGroups.clear();
            project.columnModel.columnGroups.addAll(this._oldColumnGroups);
            project.update();
        }
    }

    @Override
    public void save(Writer writer, Properties options) throws IOException {
        writer.write("columnName=");
        writer.write(this._columnName);
        writer.write(10);
        writer.write("columnIndex=");
        writer.write(Integer.toString(this._columnIndex));
        writer.write(10);
        writer.write("newCellIndex=");
        writer.write(Integer.toString(this._newCellIndex));
        writer.write(10);
        writer.write("newCellCount=");
        writer.write(Integer.toString(this._newCells.length));
        writer.write(10);
        for (CellAtRow c : this._newCells) {
            c.save(writer, options);
            writer.write(10);
        }
        ColumnAdditionChange.writeOldColumnGroups(writer, options, this._oldColumnGroups);
        writer.write("/ec/\n");
    }

    public static Change load(LineNumberReader reader, Pool pool) throws Exception {
        String line;
        String columnName = null;
        int columnIndex = -1;
        int newCellIndex = -1;
        ArrayList<CellAtRow> newCells = null;
        List<Object> oldColumnGroups = null;
        while ((line = reader.readLine()) != null && !"/ec/".equals(line)) {
            int equal = line.indexOf(61);
            CharSequence field = line.subSequence(0, equal);
            if ("columnName".equals(field)) {
                columnName = line.substring(equal + 1);
                continue;
            }
            if ("columnIndex".equals(field)) {
                columnIndex = Integer.parseInt(line.substring(equal + 1));
                continue;
            }
            if ("newCellIndex".equals(field)) {
                newCellIndex = Integer.parseInt(line.substring(equal + 1));
                continue;
            }
            if ("newCellCount".equals(field)) {
                int newCellCount = Integer.parseInt(line.substring(equal + 1));
                newCells = new ArrayList<CellAtRow>(newCellCount);
                for (int i = 0; i < newCellCount; ++i) {
                    line = reader.readLine();
                    if (line == null) continue;
                    newCells.add(CellAtRow.load(line, pool));
                }
                continue;
            }
            if (!"oldColumnGroupCount".equals(field)) continue;
            int oldColumnGroupCount = Integer.parseInt(line.substring(equal + 1));
            oldColumnGroups = ColumnAdditionChange.readOldColumnGroups(reader, oldColumnGroupCount);
        }
        ColumnAdditionChange change = new ColumnAdditionChange(columnName, columnIndex, newCells);
        change._newCellIndex = newCellIndex;
        change._oldColumnGroups = oldColumnGroups != null ? oldColumnGroups : new LinkedList();
        return change;
    }
}

