/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.model.changes;

import com.google.refine.ProjectManager;
import com.google.refine.history.Change;
import com.google.refine.model.Cell;
import com.google.refine.model.Column;
import com.google.refine.model.Project;
import com.google.refine.util.Pool;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Writer;
import java.util.Properties;

public class CellChange
implements Change {
    public final int row;
    public final int cellIndex;
    public final Cell oldCell;
    public final Cell newCell;

    public CellChange(int row, int cellIndex, Cell oldCell, Cell newCell) {
        this.row = row;
        this.cellIndex = cellIndex;
        this.oldCell = oldCell;
        this.newCell = newCell;
    }

    @Override
    public void apply(Project project) {
        project.rows.get(this.row).setCell(this.cellIndex, this.newCell);
        Column column = project.columnModel.getColumnByCellIndex(this.cellIndex);
        column.clearPrecomputes();
        ProjectManager.singleton.getLookupCacheManager().flushLookupsInvolvingProjectColumn(project.id, column.getName());
    }

    @Override
    public void revert(Project project) {
        project.rows.get(this.row).setCell(this.cellIndex, this.oldCell);
        Column column = project.columnModel.getColumnByCellIndex(this.cellIndex);
        column.clearPrecomputes();
        ProjectManager.singleton.getLookupCacheManager().flushLookupsInvolvingProjectColumn(project.id, column.getName());
    }

    @Override
    public void save(Writer writer, Properties options) throws IOException {
        writer.write("row=");
        writer.write(Integer.toString(this.row));
        writer.write(10);
        writer.write("cell=");
        writer.write(Integer.toString(this.cellIndex));
        writer.write(10);
        writer.write("old=");
        if (this.oldCell != null) {
            this.oldCell.save(writer, options);
        }
        writer.write(10);
        writer.write("new=");
        if (this.newCell != null) {
            this.newCell.save(writer, options);
        }
        writer.write(10);
        writer.write("/ec/\n");
    }

    public static CellChange load(LineNumberReader reader, Pool pool) throws Exception {
        String line;
        int row = -1;
        int cellIndex = -1;
        Cell oldCell = null;
        Cell newCell = null;
        while ((line = reader.readLine()) != null && !"/ec/".equals(line)) {
            int equal = line.indexOf(61);
            CharSequence field = line.subSequence(0, equal);
            String value = line.substring(equal + 1);
            if ("row".equals(field)) {
                row = Integer.parseInt(value);
                continue;
            }
            if ("cell".equals(field)) {
                cellIndex = Integer.parseInt(value);
                continue;
            }
            if ("new".equals(field) && value.length() > 0) {
                newCell = Cell.loadStreaming(value, pool);
                continue;
            }
            if (!"old".equals(field) || value.length() <= 0) continue;
            oldCell = Cell.loadStreaming(value, pool);
        }
        return new CellChange(row, cellIndex, oldCell, newCell);
    }
}

