/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.model.changes;

import com.google.refine.model.Cell;
import com.google.refine.util.Pool;
import java.io.IOException;
import java.io.Writer;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CellAtRowCellIndex {
    public final int row;
    public final int cellIndex;
    public final Cell cell;
    private static final Pattern semicolonPattern = Pattern.compile(";");

    public CellAtRowCellIndex(int row, int cellIndex, Cell cell) {
        this.row = row;
        this.cell = cell;
        this.cellIndex = cellIndex;
    }

    public void save(Writer writer, Properties options) throws IOException {
        writer.write(Integer.toString(this.row));
        writer.write(59);
        writer.write(Integer.toString(this.cellIndex));
        writer.write(59);
        if (this.cell != null) {
            this.cell.save(writer, options);
        }
    }

    public static CellAtRowCellIndex load(String s, Pool pool) throws Exception {
        Matcher m = semicolonPattern.matcher(s);
        m.find();
        int semicolon = m.start();
        m.find();
        int nextSemicolon = m.start();
        int row = Integer.parseInt(s.substring(0, semicolon));
        int cellIndex = Integer.parseInt(s.substring(semicolon + 1, nextSemicolon));
        Cell cell = nextSemicolon < s.length() - 1 ? Cell.loadStreaming(s.substring(nextSemicolon + 1), pool) : null;
        return new CellAtRowCellIndex(row, cellIndex, cell);
    }
}

