/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.model.changes;

import com.google.refine.model.Cell;
import com.google.refine.util.Pool;
import java.io.IOException;
import java.io.Writer;
import java.util.Objects;
import java.util.Properties;

public class CellAtRow {
    public final int row;
    public final Cell cell;

    public CellAtRow(int row, Cell cell) {
        this.row = row;
        this.cell = cell;
    }

    public void save(Writer writer, Properties options) throws IOException {
        writer.write(Integer.toString(this.row));
        writer.write(59);
        if (this.cell != null) {
            this.cell.save(writer, options);
        }
    }

    public static CellAtRow load(String s, Pool pool) throws Exception {
        int semicolon = s.indexOf(59);
        int row = Integer.parseInt(s.substring(0, semicolon));
        Cell cell = semicolon < s.length() - 1 ? Cell.loadStreaming(s.substring(semicolon + 1), pool) : null;
        return new CellAtRow(row, cell);
    }

    public int hashCode() {
        return Objects.hash(this.cell, this.row);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CellAtRow other = (CellAtRow)obj;
        return Objects.equals(this.cell, other.cell) && this.row == other.row;
    }

    public String toString() {
        return "CellAtRow [row=" + this.row + ", cell=" + String.valueOf(this.cell) + "]";
    }
}

