/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.google.refine.expr.HasFields;
import com.google.refine.util.ParsingUtilities;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.Properties;

public class ReconCandidate
implements HasFields {
    @JsonProperty(value="id")
    public final String id;
    @JsonProperty(value="name")
    public final String name;
    @JsonProperty(value="types")
    public final String[] types;
    @JsonProperty(value="score")
    public final double score;

    @JsonCreator
    public ReconCandidate(@JsonProperty(value="id") String topicID, @JsonProperty(value="name") String topicName, @JsonProperty(value="types") String[] typeIDs, @JsonProperty(value="score") double score) {
        this.id = topicID;
        this.name = topicName;
        this.types = typeIDs == null ? new String[]{} : typeIDs;
        this.score = score;
    }

    @Override
    public Object getField(String name, Properties bindings) {
        if ("id".equals(name)) {
            return this.id;
        }
        if ("name".equals(name)) {
            return this.name;
        }
        if ("type".equals(name)) {
            return this.types;
        }
        if ("score".equals(name)) {
            return this.score;
        }
        return null;
    }

    @Override
    public boolean fieldAlsoHasFields(String name) {
        return false;
    }

    public static ReconCandidate loadStreaming(String s) throws IOException {
        return (ReconCandidate)ParsingUtilities.mapper.readValue(s, ReconCandidate.class);
    }

    @Deprecated
    public static ReconCandidate loadStreaming(JsonParser jp) throws IOException {
        String[] typesA;
        JsonToken t = jp.getCurrentToken();
        if (t == JsonToken.VALUE_NULL || t != JsonToken.START_OBJECT) {
            return null;
        }
        String id = null;
        String name = null;
        ArrayList<String> types = null;
        double score = 0.0;
        while (jp.nextToken() != JsonToken.END_OBJECT) {
            String fieldName = jp.getCurrentName();
            jp.nextToken();
            if ("id".equals(fieldName)) {
                id = jp.getText();
                continue;
            }
            if ("name".equals(fieldName)) {
                name = jp.getText();
                continue;
            }
            if ("score".equals(fieldName)) {
                score = jp.getDoubleValue();
                continue;
            }
            if (!"types".equals(fieldName)) continue;
            if (jp.getCurrentToken() != JsonToken.START_ARRAY) {
                return null;
            }
            types = new ArrayList<String>();
            while (jp.nextToken() != JsonToken.END_ARRAY) {
                types.add(jp.getText());
            }
        }
        if (types != null) {
            typesA = new String[types.size()];
            types.toArray(typesA);
        } else {
            typesA = new String[]{};
        }
        return new ReconCandidate(id, name, typesA, score);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.types);
        result = 31 * result + Objects.hash(this.id, this.name, this.score);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ReconCandidate other = (ReconCandidate)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.name, other.name) && Double.doubleToLongBits(this.score) == Double.doubleToLongBits(other.score) && Arrays.equals(this.types, other.types);
    }

    public String toString() {
        return "ReconCandidate [id=" + this.id + ", name=" + this.name + ", types=" + Arrays.toString(this.types) + ", score=" + this.score + "]";
    }
}

