/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonView;
import com.google.refine.expr.HasFields;
import com.google.refine.model.ReconCandidate;
import com.google.refine.util.JsonViews;
import com.google.refine.util.ParsingUtilities;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Random;

@JsonFilter(value="reconCandidateFilter")
public class Recon
implements HasFields {
    private static final String FREEBASE_SCHEMA_SPACE = "http://rdf.freebase.com/ns/type.object.id";
    private static final String FREEBASE_IDENTIFIER_SPACE = "http://rdf.freebase.com/ns/type.object.mid";
    private static final String WIKIDATA_SCHEMA_SPACE = "http://www.wikidata.org/prop/direct/";
    private static final String WIKIDATA_IDENTIFIER_SPACE = "http://www.wikidata.org/entity/";
    private static final Random idGenerator = new Random();
    public static final int Feature_typeMatch = 0;
    public static final int Feature_nameMatch = 1;
    public static final int Feature_nameLevenshtein = 2;
    public static final int Feature_nameWordDistance = 3;
    public static final int Feature_max = 4;
    protected static final Map<String, Integer> s_featureMap = new HashMap<String, Integer>();
    @JsonIgnore
    public final long id;
    @JsonIgnore
    public String service = "unknown";
    @JsonIgnore
    public String identifierSpace = null;
    @JsonIgnore
    public String schemaSpace = null;
    @JsonIgnore
    public Object[] features = new Object[4];
    @JsonIgnore
    public List<ReconCandidate> candidates;
    @JsonIgnore
    public Judgment judgment = Judgment.None;
    @JsonIgnore
    public String judgmentAction = "unknown";
    @JsonIgnore
    public long judgmentHistoryEntry;
    @JsonIgnore
    public int judgmentBatchSize = 0;
    @JsonIgnore
    public ReconCandidate match = null;
    @JsonIgnore
    public String error = null;
    @JsonIgnore
    public int matchRank = -1;

    @Deprecated
    public static String judgmentToString(Judgment judgment) {
        if (judgment == Judgment.Matched) {
            return "matched";
        }
        if (judgment == Judgment.New) {
            return "new";
        }
        if (judgment == Judgment.Error) {
            return "errors";
        }
        return "none";
    }

    @Deprecated
    public static Judgment stringToJudgment(String s) {
        if ("matched".equals(s)) {
            return Judgment.Matched;
        }
        if ("new".equals(s)) {
            return Judgment.New;
        }
        if ("errors".equals(s)) {
            return Judgment.Error;
        }
        return Judgment.None;
    }

    @Deprecated
    public static Recon makeFreebaseRecon(long judgmentHistoryEntry) {
        return new Recon(judgmentHistoryEntry, FREEBASE_IDENTIFIER_SPACE, FREEBASE_SCHEMA_SPACE);
    }

    public static Recon makeWikidataRecon(long judgmentHistoryEntry) {
        return new Recon(judgmentHistoryEntry, WIKIDATA_IDENTIFIER_SPACE, WIKIDATA_SCHEMA_SPACE);
    }

    public Recon(long judgmentHistoryEntry, String identifierSpace, String schemaSpace) {
        this.id = idGenerator.nextLong();
        this.judgmentHistoryEntry = judgmentHistoryEntry;
        this.identifierSpace = identifierSpace;
        this.schemaSpace = schemaSpace;
    }

    protected Recon(long id, long judgmentHistoryEntry) {
        this.id = id;
        this.judgmentHistoryEntry = judgmentHistoryEntry;
    }

    public Recon dup() {
        Recon r = new Recon(this.id, this.judgmentHistoryEntry);
        r.identifierSpace = this.identifierSpace;
        r.schemaSpace = this.schemaSpace;
        this.copyTo(r);
        return r;
    }

    public Recon dup(long judgmentHistoryEntry) {
        Recon r = new Recon(judgmentHistoryEntry, this.identifierSpace, this.schemaSpace);
        this.copyTo(r);
        return r;
    }

    protected void copyTo(Recon r) {
        System.arraycopy(this.features, 0, r.features, 0, this.features.length);
        if (this.candidates != null) {
            r.candidates = new ArrayList<ReconCandidate>(this.candidates);
        }
        r.service = this.service;
        r.judgment = this.judgment;
        r.judgmentAction = this.judgmentAction;
        r.judgmentBatchSize = this.judgmentBatchSize;
        r.match = this.match;
        r.matchRank = this.matchRank;
        r.error = this.error;
    }

    public void addCandidate(ReconCandidate candidate) {
        if (this.candidates == null) {
            this.candidates = new ArrayList<ReconCandidate>(3);
        }
        this.candidates.add(candidate);
        this.error = null;
    }

    @JsonIgnore
    public ReconCandidate getBestCandidate() {
        if (this.candidates != null && this.candidates.size() > 0) {
            return this.candidates.get(0);
        }
        return null;
    }

    public Object getFeature(int feature) {
        return feature < this.features.length ? this.features[feature] : null;
    }

    public void setFeature(int feature, Object v) {
        if (feature >= this.features.length) {
            if (feature >= 4) {
                return;
            }
            Object[] newFeatures = new Object[4];
            System.arraycopy(this.features, 0, newFeatures, 0, this.features.length);
            this.features = newFeatures;
        }
        this.features[feature] = v;
    }

    @Override
    public Object getField(String name, Properties bindings) {
        if ("id".equals(name)) {
            return this.id;
        }
        if ("best".equals(name)) {
            return this.candidates != null && this.candidates.size() > 0 ? this.candidates.get(0) : null;
        }
        if ("candidates".equals(name)) {
            return this.candidates;
        }
        if ("judgment".equals(name) || "judgement".equals(name)) {
            return this.judgmentToString();
        }
        if ("judgmentAction".equals(name) || "judgementAction".equals(name)) {
            return this.judgmentAction;
        }
        if ("judgmentHistoryEntry".equals(name) || "judgementHistoryEntry".equals(name)) {
            return this.judgmentHistoryEntry;
        }
        if ("judgmentBatchSize".equals(name) || "judgementBatchSize".equals(name)) {
            return this.judgmentBatchSize;
        }
        if ("matched".equals(name)) {
            return this.judgment == Judgment.Matched;
        }
        if ("new".equals(name)) {
            return this.judgment == Judgment.New;
        }
        if ("match".equals(name)) {
            return this.match;
        }
        if ("error".equals(name)) {
            return this.error;
        }
        if ("matchRank".equals(name)) {
            return this.matchRank;
        }
        if ("features".equals(name)) {
            return new Features();
        }
        if ("service".equals(name)) {
            return this.service;
        }
        if ("identifierSpace".equals(name)) {
            return this.identifierSpace;
        }
        if ("schemaSpace".equals(name)) {
            return this.schemaSpace;
        }
        return null;
    }

    @Override
    public boolean fieldAlsoHasFields(String name) {
        return "match".equals(name) || "best".equals(name);
    }

    @Deprecated
    protected String judgmentToString() {
        return Recon.judgmentToString(this.judgment);
    }

    @JsonProperty(value="id")
    public long getId() {
        return this.id;
    }

    @JsonProperty(value="judgmentHistoryEntry")
    @JsonView(value={JsonViews.SaveMode.class})
    public long getJudgmentHistoryEntry() {
        return this.judgmentHistoryEntry;
    }

    @JsonProperty(value="service")
    public String getServiceURI() {
        return this.service;
    }

    @JsonProperty(value="identifierSpace")
    public String getIdentifierSpace() {
        return this.identifierSpace;
    }

    @JsonProperty(value="schemaSpace")
    public String getSchemaSpace() {
        return this.schemaSpace;
    }

    @JsonProperty(value="j")
    public Judgment getJudgment() {
        return this.judgment;
    }

    @JsonProperty(value="m")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public ReconCandidate getMatch() {
        return this.match;
    }

    @JsonProperty(value="e")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getError() {
        return this.error;
    }

    @JsonProperty(value="c")
    public List<ReconCandidate> getCandidates() {
        if (this.candidates != null) {
            return this.candidates;
        }
        return Collections.emptyList();
    }

    @JsonProperty(value="f")
    @JsonView(value={JsonViews.SaveMode.class})
    public Object[] getfeatures() {
        return this.features;
    }

    @JsonProperty(value="judgmentAction")
    @JsonView(value={JsonViews.SaveMode.class})
    public String getJudgmentAction() {
        return this.judgmentAction;
    }

    @JsonProperty(value="judgmentBatchSize")
    @JsonView(value={JsonViews.SaveMode.class})
    public int getJudgmentBatchSize() {
        return this.judgmentBatchSize;
    }

    @JsonProperty(value="matchRank")
    @JsonView(value={JsonViews.SaveMode.class})
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer getMatchRank() {
        if (this.match != null) {
            return this.matchRank;
        }
        return null;
    }

    public static Recon loadStreaming(String s) throws IOException {
        return (Recon)ParsingUtilities.mapper.readValue(s, Recon.class);
    }

    public Recon(@JsonProperty(value="id") long id, @JsonProperty(value="judgmentHistoryEntry") long judgmentHistoryEntry, @JsonProperty(value="j") Judgment judgment, @JsonProperty(value="m") ReconCandidate match, @JsonProperty(value="e") String error, @JsonProperty(value="f") Object[] features, @JsonProperty(value="c") List<ReconCandidate> candidates, @JsonProperty(value="service") String service, @JsonProperty(value="identifierSpace") String identifierSpace, @JsonProperty(value="schemaSpace") String schemaSpace, @JsonProperty(value="judgmentAction") String judgmentAction, @JsonProperty(value="judgmentBatchSize") Integer judgmentBatchSize, @JsonProperty(value="matchRank") Integer matchRank) {
        this.id = id;
        this.judgmentHistoryEntry = judgmentHistoryEntry;
        this.judgment = judgment != null ? judgment : Judgment.None;
        this.match = match;
        this.error = error;
        this.features = features != null ? features : new Object[4];
        ArrayList arrayList = this.candidates = candidates != null ? candidates : new ArrayList();
        if (error != null && !this.candidates.isEmpty()) {
            throw new IllegalArgumentException("Recon deserialization: inconsistent state - error & candidates not allowed together");
        }
        this.service = service != null ? service : "unknown";
        this.identifierSpace = identifierSpace;
        this.schemaSpace = schemaSpace;
        this.judgmentAction = judgmentAction != null ? judgmentAction : "unknown";
        this.judgmentBatchSize = judgmentBatchSize != null ? judgmentBatchSize : 0;
        this.matchRank = matchRank != null ? matchRank : -1;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.deepHashCode(this.features);
        result = 31 * result + Objects.hash(new Object[]{this.candidates, this.error, this.id, this.identifierSpace, this.judgment, this.judgmentAction, this.judgmentBatchSize, this.judgmentHistoryEntry, this.match, this.matchRank, this.schemaSpace, this.service});
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Recon other = (Recon)obj;
        return Objects.equals(this.candidates, other.candidates) && Objects.equals(this.error, other.error) && Arrays.deepEquals(this.features, other.features) && this.id == other.id && Objects.equals(this.identifierSpace, other.identifierSpace) && this.judgment == other.judgment && Objects.equals(this.judgmentAction, other.judgmentAction) && this.judgmentBatchSize == other.judgmentBatchSize && this.judgmentHistoryEntry == other.judgmentHistoryEntry && Objects.equals(this.match, other.match) && this.matchRank == other.matchRank && Objects.equals(this.schemaSpace, other.schemaSpace) && Objects.equals(this.service, other.service);
    }

    public String toString() {
        return "Recon [id=" + this.id + ", service=" + this.service + ", identifierSpace=" + this.identifierSpace + ", schemaSpace=" + this.schemaSpace + ", features=" + Arrays.toString(this.features) + ", candidates=" + String.valueOf(this.candidates) + ", judgment=" + String.valueOf((Object)this.judgment) + ", judgmentAction=" + this.judgmentAction + ", judgmentHistoryEntry=" + this.judgmentHistoryEntry + ", judgmentBatchSize=" + this.judgmentBatchSize + ", match=" + String.valueOf(this.match) + ", error=" + this.error + ", matchRank=" + this.matchRank + "]";
    }

    static {
        s_featureMap.put("typeMatch", 0);
        s_featureMap.put("nameMatch", 1);
        s_featureMap.put("nameLevenshtein", 2);
        s_featureMap.put("nameWordDistance", 3);
    }

    public static enum Judgment {
        None,
        Matched,
        New,
        Error;

    }

    public class Features
    implements HasFields {
        @Override
        public Object getField(String name, Properties bindings) {
            int index = s_featureMap.containsKey(name) ? s_featureMap.get(name) : -1;
            return index >= 0 && index < Recon.this.features.length ? Recon.this.features[index] : null;
        }

        @Override
        public boolean fieldAlsoHasFields(String name) {
            return false;
        }
    }
}

