/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.model;

import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.refine.ProjectManager;
import com.google.refine.ProjectMetadata;
import com.google.refine.RefineServlet;
import com.google.refine.history.History;
import com.google.refine.model.ColumnModel;
import com.google.refine.model.OverlayModel;
import com.google.refine.model.RecordModel;
import com.google.refine.model.Row;
import com.google.refine.process.ProcessManager;
import com.google.refine.util.ParsingUtilities;
import com.google.refine.util.Pool;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Project {
    protected static final Map<String, Class<? extends OverlayModel>> s_overlayModelClasses = new HashMap<String, Class<? extends OverlayModel>>();
    public final long id;
    public final List<Row> rows = new ArrayList<Row>();
    public final ColumnModel columnModel = new ColumnModel();
    public final RecordModel recordModel = new RecordModel();
    public final Map<String, OverlayModel> overlayModels = new HashMap<String, OverlayModel>();
    public final History history;
    public transient ProcessManager processManager = new ProcessManager();
    private transient Instant _lastSave = Instant.now();
    static final Logger logger = LoggerFactory.getLogger(Project.class);

    public static long generateID() {
        return System.currentTimeMillis() + Math.round(Math.random() * 1.0E12);
    }

    public Project() {
        this(Project.generateID());
    }

    protected Project(long id) {
        this.id = id;
        this.history = new History(this);
    }

    public static void registerOverlayModel(String modelName, Class<? extends OverlayModel> klass) {
        s_overlayModelClasses.put(modelName, klass);
    }

    public void dispose() {
        for (OverlayModel overlayModel : this.overlayModels.values()) {
            try {
                overlayModel.dispose(this);
            }
            catch (Exception e) {
                logger.warn("Error signaling overlay model before disposing", (Throwable)e);
            }
        }
        ProjectManager.singleton.getLookupCacheManager().flushLookupsInvolvingProject(this.id);
    }

    public Instant getLastSave() {
        return this._lastSave;
    }

    public void setLastSave() {
        this._lastSave = Instant.now();
    }

    public ProjectMetadata getMetadata() {
        return ProjectManager.singleton.getProjectMetadata(this.id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveToOutputStream(OutputStream out, Pool pool) throws IOException {
        for (OverlayModel overlayModel : this.overlayModels.values()) {
            try {
                overlayModel.onBeforeSave(this);
            }
            catch (Exception e) {
                logger.warn("Error signaling overlay model before saving", (Throwable)e);
            }
        }
        OutputStreamWriter writer = new OutputStreamWriter(out, "UTF-8");
        try {
            Properties options = new Properties();
            options.setProperty("mode", "save");
            options.put("pool", pool);
            this.saveToWriter(writer, options);
        }
        finally {
            ((Writer)writer).flush();
        }
        for (OverlayModel overlayModel : this.overlayModels.values()) {
            try {
                overlayModel.onAfterSave(this);
            }
            catch (Exception e) {
                logger.warn("Error signaling overlay model after saving", (Throwable)e);
            }
        }
    }

    protected void saveToWriter(Writer writer, Properties options) throws IOException {
        writer.write(RefineServlet.VERSION);
        writer.write(10);
        writer.write("columnModel=\n");
        this.columnModel.save(writer, options);
        writer.write("history=\n");
        this.history.save(writer, options);
        for (String modelName : this.overlayModels.keySet()) {
            writer.write("overlayModel:");
            writer.write(modelName);
            writer.write("=");
            ParsingUtilities.saveWriter.writeValue(writer, (Object)this.overlayModels.get(modelName));
            writer.write(10);
        }
        writer.write("rowCount=");
        writer.write(Integer.toString(this.rows.size()));
        writer.write(10);
        for (Row row : this.rows) {
            row.save(writer, options);
            writer.write(10);
        }
    }

    public static Project loadFromInputStream(InputStream is, long id, Pool pool) throws IOException {
        return Project.loadFromReader(new LineNumberReader(new InputStreamReader(is, StandardCharsets.UTF_8)), id, pool);
    }

    private static Project loadFromReader(LineNumberReader reader, long id, Pool pool) throws IOException {
        String line;
        long start = System.currentTimeMillis();
        reader.readLine();
        Project project = new Project(id);
        int maxCellCount = 0;
        ObjectMapper mapper = ParsingUtilities.mapper.copy();
        InjectableValues.Std injections = new InjectableValues.Std().addValue("project", (Object)project);
        mapper.setInjectableValues((InjectableValues)injections);
        while ((line = reader.readLine()) != null) {
            String modelName;
            int equal = line.indexOf(61);
            String field = line.substring(0, equal);
            String value = line.substring(equal + 1);
            if ("protograph".equals(field)) {
                field = "overlayModel:freebaseProtograph";
            }
            if ("columnModel".equals(field)) {
                project.columnModel.load(reader);
                continue;
            }
            if ("history".equals(field)) {
                project.history.load(project, reader);
                continue;
            }
            if ("rowCount".equals(field)) {
                int count = Integer.parseInt(value);
                for (int i = 0; i < count; ++i) {
                    line = reader.readLine();
                    if (line == null) continue;
                    Row row = Row.load(line, pool);
                    project.rows.add(row);
                    maxCellCount = Math.max(maxCellCount, row.cells.size());
                }
                continue;
            }
            if (!field.startsWith("overlayModel:") || !s_overlayModelClasses.containsKey(modelName = field.substring("overlayModel:".length()))) continue;
            Class<? extends OverlayModel> klass = s_overlayModelClasses.get(modelName);
            try {
                OverlayModel overlayModel = (OverlayModel)ParsingUtilities.mapper.readValue(value, klass);
                project.overlayModels.put(modelName, overlayModel);
            }
            catch (IOException e) {
                logger.error("Failed to load overlay model " + modelName);
            }
        }
        project.columnModel.setMaxCellIndex(maxCellCount - 1);
        logger.info("Loaded project {} from disk in {} sec(s)", (Object)id, (Object)Long.toString((System.currentTimeMillis() - start) / 1000L));
        project.update();
        return project;
    }

    public void update() {
        this.columnModel.update();
        this.recordModel.update(this);
        if (this.getMetadata() != null) {
            this.getMetadata().setRowCountInternal(this.rows.size());
        }
    }

    public ProcessManager getProcessManager() {
        return this.processManager;
    }
}

