/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.model;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.InjectableValues;
import com.google.refine.expr.EvalError;
import com.google.refine.expr.ExpressionUtils;
import com.google.refine.expr.HasFields;
import com.google.refine.model.Recon;
import com.google.refine.util.ParsingUtilities;
import com.google.refine.util.Pool;
import com.google.refine.util.StringUtils;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Objects;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Cell
implements HasFields,
Serializable {
    private static final long serialVersionUID = 7456683757764146620L;
    @JsonIgnore
    public final Serializable value;
    @JsonIgnore
    public final Recon recon;
    private static final Logger logger = LoggerFactory.getLogger(Cell.class);

    public Cell(Serializable value, Recon recon) {
        this.value = value;
        this.recon = recon;
    }

    @Override
    public Object getField(String name, Properties bindings) {
        if ("value".equals(name)) {
            return this.value;
        }
        if ("recon".equals(name)) {
            return this.recon;
        }
        if ("errorMessage".equals(name)) {
            return this.getErrorMessage();
        }
        return null;
    }

    @Override
    public boolean fieldAlsoHasFields(String name) {
        return "recon".equals(name);
    }

    @JsonProperty(value="e")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getErrorMessage() {
        if (ExpressionUtils.isError(this.value)) {
            return ((EvalError)this.value).message;
        }
        return null;
    }

    @JsonProperty(value="t")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getTypeString() {
        if (this.value instanceof OffsetDateTime || this.value instanceof LocalDateTime) {
            return "date";
        }
        return null;
    }

    @JsonProperty(value="v")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Object getValue() {
        if (this.value != null && !ExpressionUtils.isError(this.value)) {
            Instant instant = null;
            if (this.value instanceof OffsetDateTime) {
                instant = ((OffsetDateTime)this.value).toInstant();
            } else if (this.value instanceof LocalDateTime) {
                instant = ((LocalDateTime)this.value).toInstant(ZoneOffset.of("Z"));
            }
            if (instant != null) {
                return instant.toString();
            }
            if (this.value instanceof Double && (((Double)this.value).isNaN() || ((Double)this.value).isInfinite())) {
                return this.value.toString();
            }
            if (this.value instanceof Float && (((Float)this.value).isNaN() || ((Float)this.value).isInfinite())) {
                return this.value.toString();
            }
            if (this.value instanceof Boolean || this.value instanceof Number) {
                return this.value;
            }
            return this.value.toString();
        }
        return null;
    }

    @JsonProperty(value="r")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getReconIdString() {
        if (this.recon != null) {
            return Long.toString(this.recon.id);
        }
        return null;
    }

    public void save(Writer writer, Properties options) {
        try {
            Pool pool = (Pool)options.get("pool");
            if (pool != null && this.recon != null) {
                pool.pool(this.recon);
            }
            ParsingUtilities.saveWriter.writeValue(writer, (Object)this);
        }
        catch (IOException e) {
            logger.error("Error writing cell to writer", (Throwable)e);
        }
    }

    public static Cell loadStreaming(String s, Pool pool) throws Exception {
        InjectableValues.Std injectableValues = new InjectableValues.Std().addValue("pool", (Object)pool);
        return (Cell)ParsingUtilities.mapper.setInjectableValues((InjectableValues)injectableValues).readValue(s, Cell.class);
    }

    @JsonCreator
    public static Cell deserialize(@JsonProperty(value="v") Object value, @JsonProperty(value="t") String type, @JsonProperty(value="r") String reconId, @JsonProperty(value="e") String error, @JacksonInject(value="pool") Pool pool) {
        Recon recon = null;
        if (reconId != null) {
            recon = pool.getRecon(reconId);
        }
        if ("date".equals(type)) {
            value = ParsingUtilities.stringToDate((String)value);
        }
        if (error != null) {
            value = new EvalError(error);
        }
        return new Cell((Serializable)value, recon);
    }

    public Cell deepCopy() {
        return new Cell(this.value, this.recon == null ? null : this.recon.dup());
    }

    public String toString() {
        return StringUtils.toString(this.value);
    }

    public int hashCode() {
        return Objects.hash(this.recon, this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Cell other = (Cell)obj;
        return Objects.equals(this.recon, other.recon) && Objects.equals(this.value, other.value);
    }
}

