/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.io;

import com.google.refine.ProjectMetadata;
import com.google.refine.io.ProjectUtilities;
import com.google.refine.model.Project;
import com.google.refine.util.ParsingUtilities;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectMetadataUtilities {
    static final Logger logger = LoggerFactory.getLogger((String)"project_metadata_utilities");

    public static void save(ProjectMetadata projectMeta, File projectDir) throws IOException {
        File tempFile = new File(projectDir, "metadata.temp.json");
        ProjectMetadataUtilities.saveToFile(projectMeta, tempFile);
        if (tempFile.length() == 0L) {
            throw new IOException("Failed to save project metadata - keeping backups");
        }
        File file = new File(projectDir, "metadata.json");
        File oldFile = new File(projectDir, "metadata.old.json");
        if (file.exists()) {
            if (file.length() > 0L) {
                if (oldFile.exists()) {
                    oldFile.delete();
                }
                file.renameTo(oldFile);
            } else {
                file.delete();
            }
        }
        projectMeta.setLastSave();
        tempFile.renameTo(file);
    }

    protected static void saveToFile(ProjectMetadata projectMeta, File metadataFile) throws IOException {
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(metadataFile), StandardCharsets.UTF_8);){
            ParsingUtilities.saveWriter.writeValue((Writer)writer, (Object)projectMeta);
        }
    }

    public static ProjectMetadata load(File projectDir) {
        if (!projectDir.exists()) {
            logger.error("Project directory doesn't exist - {}", (Object)projectDir);
            return null;
        }
        if (!projectDir.isDirectory()) {
            logger.error("File isn't a project directory {}", (Object)projectDir);
            return null;
        }
        for (String filename : new String[]{"metadata.json", "metadata.temp.json", "metadata.old.json"}) {
            File file = new File(projectDir, filename);
            try {
                return ProjectMetadataUtilities.loadFromFile(file);
            }
            catch (IOException e) {
                logger.warn("load metadata failed: {}", (Object)file.getAbsolutePath(), (Object)e);
            }
        }
        logger.error("Failed to load any metadata for project {}", (Object)projectDir.getAbsolutePath());
        return null;
    }

    public static ProjectMetadata recover(File projectDir, long id) {
        ProjectMetadata pm = null;
        Project p = ProjectUtilities.load(projectDir, id);
        if (p != null) {
            long mtime;
            List<String> columnNames = p.columnModel.getColumnNames();
            String tempName = "<recovered project> - " + columnNames.size() + " cols X " + p.rows.size() + " rows - " + StringUtils.join(columnNames, (char)'|');
            p.dispose();
            File dataFile = new File(projectDir, "data.zip");
            long ctime = mtime = dataFile.lastModified();
            File historyDir = new File(projectDir, "history");
            File[] files = historyDir.listFiles();
            if (files != null) {
                for (File f : files) {
                    long time = f.lastModified();
                    ctime = Math.min(ctime, time);
                    mtime = Math.max(mtime, time);
                }
            }
            pm = new ProjectMetadata(Instant.ofEpochMilli(ctime), Instant.ofEpochMilli(mtime), tempName);
            logger.error("Partially recovered missing metadata project in directory {} / {} ", (Object)projectDir, (Object)tempName);
        }
        return pm;
    }

    protected static ProjectMetadata loadFromFile(File metadataFile) throws IOException {
        InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(metadataFile), StandardCharsets.UTF_8);
        ProjectMetadata metadata = (ProjectMetadata)ParsingUtilities.mapper.readValue((Reader)reader, ProjectMetadata.class);
        metadata.setLastSave();
        return metadata;
    }
}

