/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.io;

import com.google.refine.ProjectManager;
import com.google.refine.history.History;
import com.google.refine.history.HistoryEntry;
import com.google.refine.history.HistoryEntryManager;
import com.google.refine.io.FileProjectManager;
import com.google.refine.util.ParsingUtilities;
import com.google.refine.util.Pool;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Writer;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class FileHistoryEntryManager
implements HistoryEntryManager {
    public static final String HISTORY_DIR = "history";

    @Override
    public void delete(HistoryEntry historyEntry) {
        File file = this.getChangeFile(historyEntry);
        if (file.exists()) {
            file.delete();
        }
    }

    @Override
    public void save(HistoryEntry historyEntry, Writer writer, Properties options) {
        try {
            if ("save".equals(options.getProperty("mode"))) {
                ParsingUtilities.saveWriter.writeValue(writer, (Object)historyEntry);
            } else {
                ParsingUtilities.defaultWriter.writeValue(writer, (Object)historyEntry);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void loadChange(HistoryEntry historyEntry) {
        File changeFile = this.getChangeFile(historyEntry);
        try {
            this.loadChange(historyEntry, changeFile);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load change file " + changeFile.getAbsolutePath(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadChange(HistoryEntry historyEntry, File file) throws Exception {
        try (ZipFile zipFile = new ZipFile(file);){
            Pool pool = new Pool();
            ZipEntry poolEntry = zipFile.getEntry("pool.txt");
            if (poolEntry != null) {
                pool.load(new InputStreamReader(zipFile.getInputStream(poolEntry)));
            }
            historyEntry.setChange(History.readOneChange(zipFile.getInputStream(zipFile.getEntry("change.txt")), pool));
        }
    }

    @Override
    public void saveChange(HistoryEntry historyEntry) throws Exception {
        File changeFile = this.getChangeFile(historyEntry);
        if (!changeFile.exists()) {
            this.saveChange(historyEntry, changeFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveChange(HistoryEntry historyEntry, File file) throws Exception {
        try (ZipOutputStream out = new ZipOutputStream(new FileOutputStream(file));){
            Pool pool = new Pool();
            out.putNextEntry(new ZipEntry("change.txt"));
            try {
                History.writeOneChange(out, historyEntry.getChange(), pool);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                out.closeEntry();
            }
            out.putNextEntry(new ZipEntry("pool.txt"));
            try {
                pool.save(out);
            }
            finally {
                out.closeEntry();
            }
        }
    }

    protected File getChangeFile(HistoryEntry historyEntry) {
        return new File(this.getHistoryDir(historyEntry), historyEntry.id + ".change.zip");
    }

    protected File getHistoryDir(HistoryEntry historyEntry) {
        File dir = new File(((FileProjectManager)ProjectManager.singleton).getProjectDir(historyEntry.projectID), HISTORY_DIR);
        dir.mkdirs();
        return dir;
    }
}

