/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.importing;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.refine.RefineServlet;
import com.google.refine.importing.FormatGuesser;
import com.google.refine.importing.ImportingController;
import com.google.refine.importing.ImportingJob;
import com.google.refine.importing.ImportingParser;
import com.google.refine.importing.UrlRewriter;
import edu.mit.simile.butterfly.ButterflyModule;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportingManager {
    static final Logger logger = LoggerFactory.getLogger((String)"importing");
    private static RefineServlet servlet;
    private static File importDir;
    private static final Map<Long, ImportingJob> jobs;
    private static long jobIdCounter;
    private static final Object jobIdLock;
    public static final Map<String, Format> formatToRecord;
    public static final Map<String, List<FormatGuesser>> formatToGuessers;
    public static final Map<String, String> extensionToFormat;
    public static final Map<String, String> mimeTypeToFormat;
    public static final Set<UrlRewriter> urlRewriters;
    public static final Map<String, ImportingController> controllers;
    private static ScheduledExecutorService service;
    private static final long TIMER_PERIOD = 10L;
    private static final long STALE_PERIOD = 3600000L;

    public static void initialize(RefineServlet servlet) {
        ImportingManager.servlet = servlet;
        service = Executors.newSingleThreadScheduledExecutor();
        service.scheduleWithFixedDelay(new CleaningTimerTask(), 10L, 10L, TimeUnit.MINUTES);
    }

    public static void registerFormat(String format, String label) {
        ImportingManager.registerFormat(format, label, null, null);
    }

    public static void registerFormat(String format, String label, String uiClass, ImportingParser parser) {
        formatToRecord.put(format, new Format(format, label, true, uiClass, parser));
    }

    public static void registerFormat(String format, String label, boolean download, String uiClass, ImportingParser parser) {
        formatToRecord.put(format, new Format(format, label, download, uiClass, parser));
    }

    public static void registerFormatGuesser(String format, FormatGuesser guesser) {
        List<FormatGuesser> guessers = formatToGuessers.get(format);
        if (guessers == null) {
            guessers = new LinkedList<FormatGuesser>();
            formatToGuessers.put(format, guessers);
        }
        guessers.add(0, guesser);
    }

    public static void registerExtension(String extension, String format) {
        extensionToFormat.put((String)(extension.startsWith(".") ? extension : "." + extension), format);
    }

    public static void registerMimeType(String mimeType, String format) {
        mimeTypeToFormat.put(mimeType, format);
    }

    public static void registerUrlRewriter(UrlRewriter urlRewriter) {
        urlRewriters.add(urlRewriter);
    }

    public static void registerController(ButterflyModule module, String name, ImportingController controller) {
        String key = module.getName() + "/" + name;
        controllers.put(key, controller);
        controller.init(servlet);
    }

    public static synchronized File getImportDir() {
        if (importDir == null) {
            File tempDir = servlet.getTempDir();
            File file = importDir = tempDir == null ? new File(".import-temp") : new File(tempDir, "import");
            if (importDir.exists()) {
                try {
                    FileUtils.deleteDirectory((File)importDir);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            importDir.mkdirs();
        }
        return importDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ImportingJob createJob() {
        long id;
        Object object = jobIdLock;
        synchronized (object) {
            if (++jobIdCounter < 0L) {
                jobIdCounter = 1L;
            }
            id = jobIdCounter;
        }
        File jobDir = new File(ImportingManager.getImportDir(), Long.toString(id));
        ImportingJob job = new ImportingJob(id, jobDir);
        jobs.put(id, job);
        return job;
    }

    public static ImportingJob getJob(long id) {
        return jobs.get(id);
    }

    public static void disposeJob(long id) {
        ImportingJob job = ImportingManager.getJob(id);
        if (job != null) {
            job.dispose();
            jobs.remove(id);
        }
    }

    public static String getFormatFromFileName(String fileName) {
        int dot;
        int start = 0;
        while ((dot = fileName.indexOf(46, start)) >= 0) {
            String extension = fileName.substring(dot);
            String format = extensionToFormat.get(extension);
            if (format != null) {
                return format;
            }
            start = dot + 1;
        }
        return null;
    }

    public static String getFormatFromMimeType(String mimeType) {
        String format = mimeTypeToFormat.get(mimeType);
        if (format == null && ((String)mimeType).contains("+")) {
            mimeType = "+" + ((String)mimeType).split("\\+")[1];
            format = mimeTypeToFormat.get(mimeType);
        }
        return format;
    }

    public static String getFormat(String fileName, String mimeType) {
        String mimeTypeFormat;
        String fileNameFormat = ImportingManager.getFormatFromFileName(fileName);
        String string = mimeTypeFormat = mimeType == null ? null : ImportingManager.getFormatFromMimeType(mimeType);
        if (mimeTypeFormat == null) {
            return fileNameFormat;
        }
        if (fileNameFormat == null) {
            return mimeTypeFormat;
        }
        if (mimeTypeFormat.startsWith(fileNameFormat)) {
            return mimeTypeFormat;
        }
        return fileNameFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cleanUpStaleJobs() {
        ArrayList<Long> keys;
        long now = System.currentTimeMillis();
        Map<Long, ImportingJob> map = jobs;
        synchronized (map) {
            keys = new ArrayList<Long>(jobs.keySet());
        }
        for (Long id : keys) {
            ImportingJob job = jobs.get(id);
            if (job == null || job.updating || now - job.lastTouched <= 3600000L) continue;
            job.dispose();
            jobs.remove(id);
            logger.info("Removed Stale Import Job ID " + id);
        }
    }

    static {
        jobs = Collections.synchronizedMap(new HashMap());
        jobIdCounter = 0L;
        jobIdLock = new Object();
        formatToRecord = new HashMap<String, Format>();
        formatToGuessers = new HashMap<String, List<FormatGuesser>>();
        extensionToFormat = new HashMap<String, String>();
        mimeTypeToFormat = new HashMap<String, String>();
        urlRewriters = new HashSet<UrlRewriter>();
        controllers = new HashMap<String, ImportingController>();
    }

    private static class CleaningTimerTask
    implements Runnable {
        private CleaningTimerTask() {
        }

        @Override
        public void run() {
            ImportingManager.cleanUpStaleJobs();
        }
    }

    public static class Format {
        @JsonProperty(value="id")
        public final String id;
        @JsonProperty(value="label")
        public final String label;
        @JsonProperty(value="download")
        public final boolean download;
        @JsonProperty(value="uiClass")
        public final String uiClass;
        @JsonIgnore
        public final ImportingParser parser;

        private Format(String id, String label, boolean download, String uiClass, ImportingParser parser) {
            this.id = id;
            this.label = label;
            this.download = download;
            this.uiClass = uiClass;
            this.parser = parser;
        }
    }

    public static class ImportingConfiguration {
        @JsonProperty(value="formats")
        public Map<String, Format> getFormats() {
            return formatToRecord;
        }

        @JsonProperty(value="mimeTypeToFormat")
        public Map<String, String> getMimeTypeToFormat() {
            return mimeTypeToFormat;
        }

        @JsonProperty(value="extensionToFormat")
        public Map<String, String> getExtensionToFormat() {
            return extensionToFormat;
        }
    }
}

