/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.importing;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRawValue;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.refine.ProjectManager;
import com.google.refine.ProjectMetadata;
import com.google.refine.importing.DefaultImportingController;
import com.google.refine.model.Project;
import com.google.refine.util.JSONUtilities;
import com.google.refine.util.ParsingUtilities;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;

public class ImportingJob {
    public final long id;
    public final File dir;
    private ObjectNode config;
    public Project project;
    public ProjectMetadata metadata;
    public long lastTouched;
    public boolean updating;
    public boolean canceled;
    private final Object lock = new Object();

    public ImportingJob(long id, File dir) {
        this.id = id;
        this.dir = dir;
        ObjectNode cfg = ParsingUtilities.mapper.createObjectNode();
        JSONUtilities.safePut(cfg, "state", "new");
        JSONUtilities.safePut(cfg, "hasData", false);
        this.config = cfg;
        this.lastTouched = System.currentTimeMillis();
        dir.mkdirs();
    }

    @JsonProperty(value="config")
    @JsonRawValue
    public String getJsonConfig() {
        return this.config.toString();
    }

    @JsonIgnore
    public ObjectNode getOrCreateDefaultConfig() {
        return this.config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setState(String state) {
        ObjectNode objectNode = this.config;
        synchronized (objectNode) {
            JSONUtilities.safePut(this.config, "state", state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setError(List<Exception> exceptions) {
        ObjectNode objectNode = this.config;
        synchronized (objectNode) {
            JSONUtilities.safePut(this.config, "errors", (JsonNode)DefaultImportingController.convertErrorsToJsonArray(exceptions));
            this.setState("error");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProjectID(long projectID) {
        ObjectNode objectNode = this.config;
        synchronized (objectNode) {
            JSONUtilities.safePut(this.config, "projectID", projectID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProgress(int percent, String message) {
        ObjectNode objectNode = this.config;
        synchronized (objectNode) {
            ObjectNode progress = JSONUtilities.getObject(this.config, "progress");
            if (progress == null) {
                progress = ParsingUtilities.mapper.createObjectNode();
                JSONUtilities.safePut(this.config, "progress", (JsonNode)progress);
            }
            JSONUtilities.safePut(progress, "message", message);
            JSONUtilities.safePut(progress, "percent", percent);
            JSONUtilities.safePut(progress, "memory", (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 0x100000L);
            JSONUtilities.safePut(progress, "maxmemory", Runtime.getRuntime().maxMemory() / 0x100000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFileSelection(ArrayNode fileSelectionArray) {
        ObjectNode objectNode = this.config;
        synchronized (objectNode) {
            JSONUtilities.safePut(this.config, "fileSelection", (JsonNode)fileSelectionArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRankedFormats(ArrayNode rankedFormats) {
        ObjectNode objectNode = this.config;
        synchronized (objectNode) {
            JSONUtilities.safePut(this.config, "rankedFormats", (JsonNode)rankedFormats);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JsonIgnore
    public ObjectNode getRetrievalRecord() {
        ObjectNode objectNode = this.config;
        synchronized (objectNode) {
            return JSONUtilities.getObject(this.config, "retrievalRecord");
        }
    }

    @JsonIgnore
    public List<ObjectNode> getSelectedFileRecords() {
        ArrayNode fileSelectionArray;
        ArrayNode fileRecordArray;
        ArrayList<ObjectNode> results = new ArrayList<ObjectNode>();
        ObjectNode retrievalRecord = JSONUtilities.getObject(this.config, "retrievalRecord");
        if (retrievalRecord != null && (fileRecordArray = JSONUtilities.getArray(retrievalRecord, "files")) != null && (fileSelectionArray = JSONUtilities.getArray(this.config, "fileSelection")) != null) {
            for (int i = 0; i < fileSelectionArray.size(); ++i) {
                int index = JSONUtilities.getIntElement(fileSelectionArray, i, -1);
                if (index < 0 || index >= fileRecordArray.size()) continue;
                results.add(JSONUtilities.getObjectElement(fileRecordArray, index));
            }
        }
        return results;
    }

    public void touch() {
        this.lastTouched = System.currentTimeMillis();
    }

    public void prepareNewProject() {
        if (this.project != null) {
            this.project.dispose();
        }
        ProjectManager.singleton.save(true);
        this.project = new Project();
        this.metadata = new ProjectMetadata();
    }

    public void dispose() {
        if (this.project != null) {
            this.project.dispose();
            this.project = null;
        }
        this.metadata = null;
        try {
            FileUtils.deleteDirectory((File)this.dir);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public File getRawDataDir() {
        File dir2 = new File(this.dir, "raw-data");
        dir2.mkdirs();
        return dir2;
    }
}

