/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.importers.tree;

import com.google.common.base.CharMatcher;
import com.google.refine.importers.tree.ImportColumn;
import com.google.refine.importers.tree.ImportColumnGroup;
import com.google.refine.importers.tree.ImportParameters;
import com.google.refine.importers.tree.ImportRecord;
import com.google.refine.importers.tree.TreeImportUtilities;
import com.google.refine.importers.tree.TreeReader;
import com.google.refine.importers.tree.TreeReaderException;
import com.google.refine.model.Cell;
import com.google.refine.model.Project;
import com.google.refine.model.Row;
import java.io.Serializable;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlImportUtilities
extends TreeImportUtilities {
    static final Logger logger = LoggerFactory.getLogger((String)"XmlImportUtilities");

    public static String[] detectPathFromTag(TreeReader parser, String tag) throws TreeReaderException {
        while (parser.hasNext()) {
            List<String> path;
            TreeReader.Token eventType = parser.next();
            if (eventType != TreeReader.Token.StartEntity || (path = XmlImportUtilities.detectRecordElement(parser, tag)) == null) continue;
            String[] path2 = new String[path.size()];
            path.toArray(path2);
            return path2;
        }
        return null;
    }

    protected static List<String> detectRecordElement(TreeReader parser, String tag) throws TreeReaderException {
        TreeReader.Token eventType;
        if (parser.current() == TreeReader.Token.Ignorable) {
            parser.next();
        }
        String localName = parser.getFieldName();
        String fullName = XmlImportUtilities.composeName(parser.getPrefix(), localName);
        if (tag.equals(parser.getFieldName()) || tag.equals(fullName)) {
            LinkedList<String> path = new LinkedList<String>();
            path.add(localName);
            return path;
        }
        while (parser.hasNext() && (eventType = parser.next()) != TreeReader.Token.EndEntity) {
            List<String> path;
            if (eventType != TreeReader.Token.StartEntity || (path = XmlImportUtilities.detectRecordElement(parser, tag)) == null) continue;
            path.add(0, localName);
            return path;
        }
        return null;
    }

    protected static String composeName(String prefix, String localName) {
        return prefix != null && prefix.length() > 0 ? prefix + ":" + localName : localName;
    }

    @Deprecated
    public static void importTreeData(TreeReader parser, Project project, String[] recordPath, ImportColumnGroup rootColumnGroup, int limit, ImportParameters parameters) throws TreeReaderException {
        XmlImportUtilities.importTreeData(parser, project, recordPath, rootColumnGroup, limit, parameters.trimStrings, parameters.storeEmptyStrings, parameters.guessDataType);
    }

    public static void importTreeData(TreeReader parser, Project project, String[] recordPath, ImportColumnGroup rootColumnGroup, int limit, boolean trimStrings, boolean storeEmptyStrings, boolean guessDataTypes) throws TreeReaderException {
        if (logger.isTraceEnabled()) {
            logger.trace("importTreeData(TreeReader, Project, String[], ImportColumnGroup)");
        }
        try {
            while (parser.hasNext()) {
                TreeReader.Token eventType = parser.next();
                if (eventType != TreeReader.Token.StartEntity) continue;
                XmlImportUtilities.findRecord(project, parser, recordPath, 0, rootColumnGroup, limit--, trimStrings, storeEmptyStrings, guessDataTypes);
            }
        }
        catch (TreeReaderException e) {
            logger.error("Exception from XML parse", (Throwable)e);
            throw e;
        }
    }

    @Deprecated
    protected static void findRecord(Project project, TreeReader parser, String[] recordPath, int pathIndex, ImportColumnGroup rootColumnGroup, int limit, ImportParameters parameters) throws TreeReaderException {
        XmlImportUtilities.findRecord(project, parser, recordPath, pathIndex, rootColumnGroup, limit, parameters.trimStrings, parameters.storeEmptyStrings, parameters.guessDataType);
    }

    protected static void findRecord(Project project, TreeReader parser, String[] recordPath, int pathIndex, ImportColumnGroup rootColumnGroup, int limit, boolean trimStrings, boolean storeEmptyStrings, boolean guessDataTypes) throws TreeReaderException {
        if (logger.isTraceEnabled()) {
            logger.trace("findRecord(Project, TreeReader, String[], int, ImportColumnGroup - path:" + Arrays.toString(recordPath));
        }
        if (parser.current() == TreeReader.Token.Ignorable) {
            logger.warn("Cannot use findRecord method for START_DOCUMENT event");
            return;
        }
        String recordPathSegment = recordPath[pathIndex];
        String localName = parser.getFieldName();
        String fullName = XmlImportUtilities.composeName(parser.getPrefix(), localName);
        if (recordPathSegment.equals(localName) || recordPathSegment.equals(fullName)) {
            if (pathIndex < recordPath.length - 1) {
                while (parser.hasNext() && limit != 0) {
                    TreeReader.Token eventType = parser.next();
                    if (eventType == TreeReader.Token.StartEntity) {
                        XmlImportUtilities.findRecord(project, parser, recordPath, pathIndex + 1, rootColumnGroup, limit--, trimStrings, storeEmptyStrings, guessDataTypes);
                        continue;
                    }
                    if (eventType != TreeReader.Token.EndEntity) {
                        String currentFieldName;
                        String desiredFieldName;
                        if (eventType != TreeReader.Token.Value || pathIndex != recordPath.length - 2 || !(desiredFieldName = recordPath[pathIndex + 1]).equals(currentFieldName = parser.getFieldName())) continue;
                        XmlImportUtilities.processFieldAsRecord(project, parser, rootColumnGroup, trimStrings, storeEmptyStrings, guessDataTypes);
                        continue;
                    }
                    break;
                }
            } else {
                XmlImportUtilities.processRecord(project, parser, rootColumnGroup, trimStrings, storeEmptyStrings, guessDataTypes);
            }
        } else {
            XmlImportUtilities.skip(parser);
        }
    }

    protected static void skip(TreeReader parser) throws TreeReaderException {
        while (parser.hasNext()) {
            TreeReader.Token eventType = parser.next();
            if (eventType == TreeReader.Token.StartEntity) {
                XmlImportUtilities.skip(parser);
                continue;
            }
            if (eventType != TreeReader.Token.EndEntity) continue;
            return;
        }
    }

    @Deprecated
    protected static void processRecord(Project project, TreeReader parser, ImportColumnGroup rootColumnGroup, ImportParameters parameter) throws TreeReaderException {
        XmlImportUtilities.processRecord(project, parser, rootColumnGroup, parameter.trimStrings, parameter.storeEmptyStrings, parameter.guessDataType);
    }

    protected static void processRecord(Project project, TreeReader parser, ImportColumnGroup rootColumnGroup, boolean trimStrings, boolean storeEmptyStrings, boolean guessDataTypes) throws TreeReaderException {
        if (logger.isTraceEnabled()) {
            logger.trace("processRecord(Project,TreeReader,ImportColumnGroup)");
        }
        ImportRecord record = new ImportRecord();
        XmlImportUtilities.processSubRecord(project, parser, rootColumnGroup, record, 0, trimStrings, storeEmptyStrings, guessDataTypes);
        XmlImportUtilities.addImportRecordToProject(record, project);
    }

    @Deprecated
    protected static void processFieldAsRecord(Project project, TreeReader parser, ImportColumnGroup rootColumnGroup, ImportParameters parameter) throws TreeReaderException {
        XmlImportUtilities.processFieldAsRecord(project, parser, rootColumnGroup, parameter.trimStrings, parameter.storeEmptyStrings, parameter.guessDataType);
    }

    protected static void processFieldAsRecord(Project project, TreeReader parser, ImportColumnGroup rootColumnGroup, boolean trimStrings, boolean storeEmptyStrings, boolean guessDataType) throws TreeReaderException {
        if (logger.isTraceEnabled()) {
            logger.trace("processFieldAsRecord(Project,TreeReader,ImportColumnGroup)");
        }
        Serializable value = parser.getValue();
        ImportRecord record = null;
        if (value instanceof String) {
            String text = (String)((Object)value);
            if (trimStrings) {
                text = CharMatcher.whitespace().trimFrom((CharSequence)text);
            }
            if (text.length() > 0 | !storeEmptyStrings) {
                record = new ImportRecord();
                XmlImportUtilities.addCell(project, rootColumnGroup, record, parser.getFieldName(), (String)((Object)value), storeEmptyStrings, guessDataType);
            }
        } else {
            record = new ImportRecord();
            XmlImportUtilities.addCell(project, rootColumnGroup, record, parser.getFieldName(), value);
        }
        if (record != null) {
            XmlImportUtilities.addImportRecordToProject(record, project);
        }
    }

    @Deprecated
    protected static void addImportRecordToProject(ImportRecord record, Project project, boolean includeFileSources, String fileSource, boolean includeArchiveFileName, String archiveFileName) {
        XmlImportUtilities.addImportRecordToProject(record, project);
    }

    protected static void addImportRecordToProject(ImportRecord record, Project project) {
        for (List<Cell> row : record.rows) {
            if (row.size() <= 0) continue;
            Row realRow = new Row(row.size());
            for (int c = 0; c < row.size(); ++c) {
                Cell cell = row.get(c);
                if (cell == null) continue;
                realRow.setCell(c, cell);
            }
            project.rows.add(realRow);
        }
    }

    @Deprecated
    protected static void processSubRecord(Project project, TreeReader parser, ImportColumnGroup columnGroup, ImportRecord record, int level, ImportParameters parameter) throws TreeReaderException {
        XmlImportUtilities.processSubRecord(project, parser, columnGroup, record, level, parameter.trimStrings, parameter.storeEmptyStrings, parameter.guessDataType);
    }

    protected static void processSubRecord(Project project, TreeReader parser, ImportColumnGroup columnGroup, ImportRecord record, int level, boolean trimStrings, boolean storeEmptyStrings, boolean guessDataType) throws TreeReaderException {
        if (logger.isTraceEnabled()) {
            logger.trace("processSubRecord(Project,TreeReader,ImportColumnGroup,ImportRecord) lvl:" + level + " " + String.valueOf(columnGroup));
        }
        if (parser.current() == TreeReader.Token.Ignorable) {
            return;
        }
        ImportColumnGroup thisColumnGroup = XmlImportUtilities.getColumnGroup(project, columnGroup, XmlImportUtilities.composeName(parser.getPrefix(), parser.getFieldName()));
        thisColumnGroup.nextRowIndex = Math.max(thisColumnGroup.nextRowIndex, columnGroup.nextRowIndex);
        int attributeCount = parser.getAttributeCount();
        for (int i = 0; i < attributeCount; ++i) {
            String text = parser.getAttributeValue(i);
            if (trimStrings) {
                text = CharMatcher.whitespace().trimFrom((CharSequence)text);
            }
            if (!(text.length() > 0 | !storeEmptyStrings)) continue;
            XmlImportUtilities.addCell(project, thisColumnGroup, record, XmlImportUtilities.composeName(parser.getAttributePrefix(i), parser.getAttributeLocalName(i)), text, storeEmptyStrings, guessDataType);
        }
        while (parser.hasNext()) {
            TreeReader.Token eventType = parser.next();
            if (eventType == TreeReader.Token.StartEntity) {
                XmlImportUtilities.processSubRecord(project, parser, thisColumnGroup, record, level + 1, trimStrings, storeEmptyStrings, guessDataType);
                continue;
            }
            if (eventType == TreeReader.Token.Value) {
                Serializable value = parser.getValue();
                String colName = parser.getFieldName();
                if (value instanceof String) {
                    String text = (String)((Object)value);
                    if (trimStrings) {
                        text = CharMatcher.whitespace().trimFrom((CharSequence)text);
                    }
                    XmlImportUtilities.addCell(project, thisColumnGroup, record, colName, text, storeEmptyStrings, guessDataType);
                    continue;
                }
                XmlImportUtilities.addCell(project, thisColumnGroup, record, colName, value);
                continue;
            }
            if (eventType == TreeReader.Token.EndEntity) break;
            if (eventType == TreeReader.Token.Ignorable) continue;
            logger.info("unknown event type " + String.valueOf((Object)eventType));
        }
        int nextRowIndex = thisColumnGroup.nextRowIndex;
        for (ImportColumn column2 : thisColumnGroup.columns.values()) {
            nextRowIndex = Math.max(nextRowIndex, column2.nextRowIndex);
        }
        for (ImportColumnGroup columnGroup2 : thisColumnGroup.subgroups.values()) {
            nextRowIndex = Math.max(nextRowIndex, columnGroup2.nextRowIndex);
        }
        thisColumnGroup.nextRowIndex = nextRowIndex;
    }
}

