/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.importers.tree;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.refine.ProjectMetadata;
import com.google.refine.importers.ImporterUtilities;
import com.google.refine.importers.ImportingParserBase;
import com.google.refine.importers.tree.ImportColumnGroup;
import com.google.refine.importers.tree.TreeReader;
import com.google.refine.importers.tree.XmlImportUtilities;
import com.google.refine.importing.ImportingJob;
import com.google.refine.importing.ImportingUtilities;
import com.google.refine.model.Cell;
import com.google.refine.model.Project;
import com.google.refine.model.Row;
import com.google.refine.util.JSONUtilities;
import com.google.refine.util.NotImplementedException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.util.List;

public abstract class TreeImportingParserBase
extends ImportingParserBase {
    protected TreeImportingParserBase(boolean useInputStream) {
        super(useInputStream);
    }

    @Override
    public ObjectNode createParserUIInitializationData(ImportingJob job, List<ObjectNode> fileRecords, String format) {
        ObjectNode options = super.createParserUIInitializationData(job, fileRecords, format);
        JSONUtilities.safePut(options, "trimStrings", false);
        JSONUtilities.safePut(options, "guessCellValueTypes", false);
        JSONUtilities.safePut(options, "storeEmptyStrings", true);
        return options;
    }

    @Override
    public void parse(Project project, ProjectMetadata metadata, ImportingJob job, List<ObjectNode> fileRecords, String format, int limit, ObjectNode options, List<Exception> exceptions) {
        ImporterUtilities.MultiFileReadingProgress progress = ImporterUtilities.createMultiFileReadingProgress(job, fileRecords);
        ImportColumnGroup rootColumnGroup = new ImportColumnGroup();
        for (ObjectNode fileRecord : fileRecords) {
            try {
                this.parseOneFile(project, metadata, job, fileRecord, rootColumnGroup, limit, options, exceptions, progress);
            }
            catch (IOException e) {
                exceptions.add(e);
            }
            if (limit <= 0 || project.rows.size() < limit) continue;
            break;
        }
        rootColumnGroup.tabulate();
        XmlImportUtilities.createColumnsFromImport(project, rootColumnGroup);
        project.columnModel.update();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseOneFile(Project project, ProjectMetadata metadata, ImportingJob job, ObjectNode fileRecord, ImportColumnGroup rootColumnGroup, int limit, ObjectNode options, List<Exception> exceptions, ImporterUtilities.MultiFileReadingProgress progress) throws IOException {
        File file = ImportingUtilities.getFile(job, fileRecord);
        String fileSource = ImportingUtilities.getFileSource(fileRecord);
        String archiveFileName = ImportingUtilities.getArchiveFileName(fileRecord);
        int filenameColumnIndex = -1;
        int archiveColumnIndex = -1;
        int startingRowCount = project.rows.size();
        progress.startFile(fileSource);
        try (InputStream inputStream = ImporterUtilities.openAndTrackFile(fileSource, file, progress);){
            if (JSONUtilities.getBoolean((JsonNode)options, "includeArchiveFileName", false) && archiveFileName != null) {
                archiveColumnIndex = TreeImportingParserBase.addArchiveColumn(project);
            }
            if (JSONUtilities.getBoolean((JsonNode)options, "includeFileSources", false)) {
                filenameColumnIndex = TreeImportingParserBase.addFilenameColumn(project, archiveColumnIndex >= 0);
            }
            if (this.useInputStream) {
                this.parseOneFile(project, metadata, job, fileSource, inputStream, rootColumnGroup, limit, options, exceptions);
            } else {
                String commonEncoding = JSONUtilities.getString((JsonNode)options, "encoding", null);
                if (commonEncoding != null && commonEncoding.isEmpty()) {
                    commonEncoding = null;
                }
                Reader reader = ImportingUtilities.getFileReader(file, fileRecord, commonEncoding);
                this.parseOneFile(project, metadata, job, fileSource, reader, rootColumnGroup, limit, options, exceptions);
            }
            int endingRowCount = project.rows.size();
            for (int i = startingRowCount; i < endingRowCount; ++i) {
                Row row = project.rows.get(i);
                if (archiveColumnIndex >= 0) {
                    row.setCell(archiveColumnIndex, new Cell((Serializable)((Object)archiveFileName), null));
                }
                if (filenameColumnIndex < 0) continue;
                row.setCell(filenameColumnIndex, new Cell((Serializable)((Object)fileSource), null));
            }
            ObjectNode fileOptions = options.deepCopy();
            JSONUtilities.safePut(fileOptions, "fileSource", fileSource);
            JSONUtilities.safePut(fileOptions, "archiveFileName", archiveFileName);
            metadata.appendImportOptionMetadata(fileOptions);
        }
        finally {
            progress.endFile(fileSource, file.length());
        }
    }

    public void parseOneFile(Project project, ProjectMetadata metadata, ImportingJob job, String fileSource, Reader reader, ImportColumnGroup rootColumnGroup, int limit, ObjectNode options, List<Exception> exceptions) {
        throw new NotImplementedException();
    }

    public void parseOneFile(Project project, ProjectMetadata metadata, ImportingJob job, String fileSource, InputStream inputStream, ImportColumnGroup rootColumnGroup, int limit, ObjectNode options, List<Exception> exceptions) {
        throw new NotImplementedException();
    }

    protected void parseOneFile(Project project, ProjectMetadata metadata, ImportingJob job, String fileSource, TreeReader treeParser, ImportColumnGroup rootColumnGroup, int limit, ObjectNode options, List<Exception> exceptions) {
        String[] recordPath = JSONUtilities.getStringArray(options, "recordPath");
        int limit2 = JSONUtilities.getInt((JsonNode)options, "limit", -1);
        if (limit > 0) {
            limit2 = limit2 > 0 ? Math.min(limit, limit2) : limit;
        }
        if (limit2 == 0) {
            limit2 = -1;
        }
        boolean trimStrings = JSONUtilities.getBoolean((JsonNode)options, "trimStrings", true);
        boolean storeEmptyStrings = JSONUtilities.getBoolean((JsonNode)options, "storeEmptyStrings", false);
        boolean guessCellValueTypes = JSONUtilities.getBoolean((JsonNode)options, "guessCellValueTypes", true);
        try {
            XmlImportUtilities.importTreeData(treeParser, project, recordPath, rootColumnGroup, limit2, trimStrings, storeEmptyStrings, guessCellValueTypes);
        }
        catch (Exception e) {
            exceptions.add(e);
        }
    }
}

