/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.importers.tree;

import com.google.refine.importers.ImporterUtilities;
import com.google.refine.importers.tree.ImportColumn;
import com.google.refine.importers.tree.ImportColumnGroup;
import com.google.refine.importers.tree.ImportRecord;
import com.google.refine.importers.tree.RecordElementCandidate;
import com.google.refine.model.Cell;
import com.google.refine.model.Column;
import com.google.refine.model.Project;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TreeImportUtilities {
    static final Logger logger = LoggerFactory.getLogger((String)"TreeImportUtilities");

    protected static void sortRecordElementCandidates(List<RecordElementCandidate> list) {
        Collections.sort(list, new Comparator<RecordElementCandidate>(){

            @Override
            public int compare(RecordElementCandidate o1, RecordElementCandidate o2) {
                return o2.count - o1.count;
            }
        });
    }

    public static void createColumnsFromImport(Project project, ImportColumnGroup columnGroup) {
        int startColumnIndex = project.columnModel.columns.size();
        ArrayList<ImportColumn> columns = new ArrayList<ImportColumn>(columnGroup.columns.values());
        Collections.sort(columns, new Comparator<ImportColumn>(){

            @Override
            public int compare(ImportColumn o1, ImportColumn o2) {
                if (o1.blankOnFirstRow != o2.blankOnFirstRow) {
                    return o1.blankOnFirstRow ? 1 : -1;
                }
                return o2.nonBlankCount - o1.nonBlankCount;
            }
        });
        for (int i = 0; i < columns.size(); ++i) {
            ImportColumn c = (ImportColumn)columns.get(i);
            Column column = new Column(c.cellIndex, c.name);
            project.columnModel.columns.add(column);
        }
        ArrayList<ImportColumnGroup> subgroups = new ArrayList<ImportColumnGroup>(columnGroup.subgroups.values());
        Collections.sort(subgroups, new Comparator<ImportColumnGroup>(){

            @Override
            public int compare(ImportColumnGroup o1, ImportColumnGroup o2) {
                return o2.nonBlankCount - o1.nonBlankCount;
            }
        });
        for (ImportColumnGroup g : subgroups) {
            TreeImportUtilities.createColumnsFromImport(project, g);
        }
        int endColumnIndex = project.columnModel.columns.size();
        int span = endColumnIndex - startColumnIndex;
        if (span > 1 && span < project.columnModel.columns.size()) {
            project.columnModel.addColumnGroup(startColumnIndex, span, startColumnIndex);
        }
    }

    @Deprecated
    protected static void addCell(Project project, ImportColumnGroup columnGroup, ImportRecord record, String columnLocalName, String text) {
        TreeImportUtilities.addCell(project, columnGroup, record, columnLocalName, text, true, true);
    }

    protected static void addCell(Project project, ImportColumnGroup columnGroup, ImportRecord record, String columnLocalName, String text, boolean storeEmptyString, boolean guessDataType) {
        Object value = text;
        if (!storeEmptyString && (text == null || text.isEmpty())) {
            return;
        }
        if (guessDataType) {
            value = ImporterUtilities.parseCellValue(text);
        }
        TreeImportUtilities.addCell(project, columnGroup, record, columnLocalName, (Serializable)value);
    }

    protected static void addCell(Project project, ImportColumnGroup columnGroup, ImportRecord record, String columnLocalName, Serializable value) {
        ImportColumn column = TreeImportUtilities.getColumn(project, columnGroup, columnLocalName);
        int cellIndex = column.cellIndex;
        int rowIndex = Math.max(columnGroup.nextRowIndex, column.nextRowIndex);
        List<Cell> row = record.rows.get(rowIndex);
        if (row == null) {
            row = new ArrayList<Cell>();
            record.rows.set(rowIndex, row);
        }
        while (cellIndex >= row.size()) {
            row.add(null);
        }
        row.set(cellIndex, new Cell(value, null));
        column.nextRowIndex = rowIndex + 1;
        ++column.nonBlankCount;
    }

    protected static ImportColumn getColumn(Project project, ImportColumnGroup columnGroup, String localName) {
        if (columnGroup.columns.containsKey(localName)) {
            return columnGroup.columns.get(localName);
        }
        ImportColumn column = TreeImportUtilities.createColumn(project, columnGroup, localName);
        columnGroup.columns.put(localName, column);
        return column;
    }

    protected static ImportColumn createColumn(Project project, ImportColumnGroup columnGroup, String localName) {
        ImportColumn newColumn = new ImportColumn();
        newColumn.name = columnGroup.name.length() == 0 ? (localName == null ? "Text" : localName) : (localName == null ? columnGroup.name : columnGroup.name + " - " + localName);
        newColumn.cellIndex = project.columnModel.allocateNewCellIndex();
        newColumn.nextRowIndex = columnGroup.nextRowIndex;
        return newColumn;
    }

    protected static ImportColumnGroup getColumnGroup(Project project, ImportColumnGroup columnGroup, String localName) {
        if (columnGroup.subgroups.containsKey(localName)) {
            return columnGroup.subgroups.get(localName);
        }
        ImportColumnGroup subgroup = TreeImportUtilities.createColumnGroup(project, columnGroup, localName);
        columnGroup.subgroups.put(localName, subgroup);
        return subgroup;
    }

    protected static ImportColumnGroup createColumnGroup(Project project, ImportColumnGroup columnGroup, String localName) {
        ImportColumnGroup newGroup = new ImportColumnGroup();
        newGroup.name = columnGroup.name.length() == 0 ? (localName == null ? "Text" : localName) : (localName == null ? columnGroup.name : columnGroup.name + " - " + localName);
        newGroup.nextRowIndex = columnGroup.nextRowIndex;
        return newGroup;
    }
}

