/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.importers.tree;

import com.google.refine.model.Cell;
import java.util.ArrayList;
import java.util.List;

public class ImportRecord {
    public List<List<Cell>> rows = new BasedList<List<Cell>>();

    class BasedList<T>
    extends ArrayList<T> {
        private static final long serialVersionUID = 1L;
        int offset = Integer.MAX_VALUE;

        BasedList() {
        }

        @Override
        public T set(int index, T element) {
            this.rebase(index);
            this.extend(index);
            return super.set(index - this.offset, element);
        }

        @Override
        public T get(int index) {
            if (this.offset == Integer.MAX_VALUE || index - this.offset > this.size() - 1) {
                return null;
            }
            return (T)super.get(index - this.offset);
        }

        private void rebase(int index) {
            if (index < this.offset) {
                if (this.offset < Integer.MAX_VALUE) {
                    int i;
                    int new_offset = Math.max(0, index - 10);
                    int delta = this.offset - new_offset;
                    for (i = 0; i < delta; ++i) {
                        this.add(null);
                    }
                    for (i = this.size(); i > delta; --i) {
                        this.set(i, this.get(i - delta));
                    }
                    for (i = 0; i < delta; ++i) {
                        this.set(i, (T)null);
                    }
                    this.offset = new_offset;
                } else {
                    this.offset = index;
                }
            }
        }

        private void extend(int index) {
            int i = index - this.offset;
            while (i >= this.size()) {
                this.add(null);
            }
        }
    }
}

