/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.importers;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.refine.ProjectMetadata;
import com.google.refine.importers.ImporterUtilities;
import com.google.refine.importing.EncodingGuesser;
import com.google.refine.importing.ImportingJob;
import com.google.refine.importing.ImportingParser;
import com.google.refine.importing.ImportingUtilities;
import com.google.refine.model.Cell;
import com.google.refine.model.Column;
import com.google.refine.model.ModelException;
import com.google.refine.model.Project;
import com.google.refine.model.Row;
import com.google.refine.util.JSONUtilities;
import com.google.refine.util.NotImplementedException;
import com.google.refine.util.ParsingUtilities;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ImportingParserBase
implements ImportingParser {
    static final Logger logger = LoggerFactory.getLogger((String)"ImportingParserBase");
    protected final boolean useInputStream;

    protected ImportingParserBase(boolean useInputStream) {
        this.useInputStream = useInputStream;
    }

    @Override
    public ObjectNode createParserUIInitializationData(ImportingJob job, List<ObjectNode> fileRecords, String format) {
        ObjectNode options = ParsingUtilities.mapper.createObjectNode();
        JSONUtilities.safePut(options, "includeFileSources", fileRecords.size() > 1);
        JSONUtilities.safePut(options, "includeArchiveFileName", ImportingUtilities.hasArchiveFileField(fileRecords));
        EncodingGuesser.guessInitialEncoding(fileRecords, options);
        return options;
    }

    @Override
    public void parse(Project project, ProjectMetadata metadata, ImportingJob job, List<ObjectNode> fileRecords, String format, int limit, ObjectNode options, List<Exception> exceptions) {
        ImporterUtilities.MultiFileReadingProgress progress = ImporterUtilities.createMultiFileReadingProgress(job, fileRecords);
        for (ObjectNode fileRecord : fileRecords) {
            if (job.canceled) break;
            try {
                this.parseOneFile(project, metadata, job, fileRecord, limit, options, exceptions, progress);
            }
            catch (IOException e) {
                exceptions.add(e);
            }
            if (limit <= 0 || project.rows.size() < limit) continue;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseOneFile(Project project, ProjectMetadata metadata, ImportingJob job, ObjectNode fileRecord, int limit, ObjectNode options, List<Exception> exceptions, ImporterUtilities.MultiFileReadingProgress progress) throws IOException {
        File file = ImportingUtilities.getFile(job, fileRecord);
        String fileSource = ImportingUtilities.getFileSource(fileRecord);
        String fileName = ImportingUtilities.getFileName(fileRecord);
        String archiveFileName = ImportingUtilities.getArchiveFileName(fileRecord);
        int filenameColumnIndex = -1;
        int archiveColumnIndex = -1;
        int startingRowCount = project.rows.size();
        progress.startFile(fileSource);
        try (InputStream inputStream = ImporterUtilities.openAndTrackFile(fileSource, file, progress);){
            if (JSONUtilities.getBoolean((JsonNode)options, "includeArchiveFileName", false) && archiveFileName != null) {
                archiveColumnIndex = ImportingParserBase.addArchiveColumn(project);
            }
            if (JSONUtilities.getBoolean((JsonNode)options, "includeFileSources", false)) {
                filenameColumnIndex = ImportingParserBase.addFilenameColumn(project, archiveColumnIndex >= 0);
            }
            if (this.useInputStream) {
                this.parseOneFile(project, metadata, job, fileName, inputStream, limit, options, exceptions);
            } else {
                String commonEncoding = JSONUtilities.getString((JsonNode)options, "encoding", null);
                if (commonEncoding != null && commonEncoding.isEmpty()) {
                    commonEncoding = null;
                }
                Reader reader = ImportingUtilities.getReaderFromStream(inputStream, fileRecord, commonEncoding);
                this.parseOneFile(project, metadata, job, fileName, reader, limit, options, exceptions);
            }
            int endingRowCount = project.rows.size();
            for (int i = startingRowCount; i < endingRowCount; ++i) {
                Row row = project.rows.get(i);
                if (archiveColumnIndex >= 0) {
                    row.setCell(archiveColumnIndex, new Cell((Serializable)((Object)archiveFileName), null));
                }
                if (filenameColumnIndex < 0) continue;
                row.setCell(filenameColumnIndex, new Cell((Serializable)((Object)fileSource), null));
            }
            ObjectNode fileOptions = options.deepCopy();
            JSONUtilities.safePut(fileOptions, "fileSource", fileSource);
            JSONUtilities.safePut(fileOptions, "archiveFileName", archiveFileName);
            metadata.appendImportOptionMetadata(fileOptions);
        }
        finally {
            progress.endFile(fileSource, file.length());
        }
    }

    public void parseOneFile(Project project, ProjectMetadata metadata, ImportingJob job, String fileSource, Reader reader, int limit, ObjectNode options, List<Exception> exceptions) {
        throw new NotImplementedException();
    }

    public void parseOneFile(Project project, ProjectMetadata metadata, ImportingJob job, String fileSource, InputStream inputStream, int limit, ObjectNode options, List<Exception> exceptions) {
        throw new NotImplementedException();
    }

    @Deprecated
    protected static int addFilenameColumn(Project project, boolean archiveColumnAdded) {
        String fileNameColumnName = "File";
        int columnId = archiveColumnAdded ? 1 : 0;
        return ImportingParserBase.addColumn(project, fileNameColumnName, columnId);
    }

    protected static int addArchiveColumn(Project project) {
        String columnName = "Archive";
        return ImportingParserBase.addColumn(project, columnName, 0);
    }

    private static int addColumn(Project project, String columnName, int columnId) {
        if (project.columnModel.getColumnByName(columnName) == null) {
            try {
                project.columnModel.addColumn(columnId, new Column(project.columnModel.allocateNewCellIndex(), columnName), false);
                return columnId;
            }
            catch (ModelException e) {
                logger.error("ModelException adding Filename column", (Throwable)e);
                return -1;
            }
        }
        return columnId;
    }
}

