/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.history;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonView;
import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.refine.ProjectManager;
import com.google.refine.history.Change;
import com.google.refine.history.HistoryEntryManager;
import com.google.refine.model.AbstractOperation;
import com.google.refine.model.Project;
import com.google.refine.util.JsonViews;
import com.google.refine.util.ParsingUtilities;
import java.io.IOException;
import java.io.Writer;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HistoryEntry {
    static final Logger logger = LoggerFactory.getLogger((String)"HistoryEntry");
    @JsonProperty(value="id")
    public final long id;
    @JsonIgnore
    public final long projectID;
    @JsonProperty(value="description")
    public final String description;
    @JsonProperty(value="time")
    public final Instant time;
    @JsonIgnore
    public final HistoryEntryManager _manager;
    @JsonProperty(value="operation")
    @JsonView(value={JsonViews.SaveMode.class})
    public final AbstractOperation operation;
    @JsonIgnore
    private transient Change _change;
    private static final String OPERATION = "operation";

    public void setChange(Change _change) {
        this._change = _change;
    }

    @JsonIgnore
    public Change getChange() {
        return this._change;
    }

    public static long allocateID() {
        return Math.round(Math.random() * 1000000.0) + System.currentTimeMillis();
    }

    @JsonCreator
    protected HistoryEntry(@JsonProperty(value="id") long id, @JacksonInject(value="projectID") long projectID, @JsonProperty(value="description") String description, @JsonProperty(value="operation") AbstractOperation operation) {
        this(id, projectID, description, operation, Instant.now());
    }

    public HistoryEntry(long id, Project project, String description, AbstractOperation operation, Change change) {
        this(id, project.id, description, operation, Instant.now());
        this.setChange(change);
    }

    @Deprecated(since="3.8")
    protected HistoryEntry(long id, long projectID, String description, AbstractOperation operation, OffsetDateTime time) {
        this(id, projectID, description, operation, time.toInstant());
    }

    protected HistoryEntry(long id, long projectID, String description, AbstractOperation operation, Instant time) {
        this.id = id;
        this.projectID = projectID;
        this.description = description;
        this.operation = operation;
        this.time = time;
        this._manager = ProjectManager.singleton.getHistoryEntryManager();
        if (this._manager == null) {
            logger.error("Failed to get history entry manager from project manager: " + String.valueOf(ProjectManager.singleton));
        }
    }

    public void save(Writer writer, Properties options) {
        this._manager.save(this, writer, options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void apply(Project project) {
        if (this.getChange() == null) {
            ProjectManager.singleton.getHistoryEntryManager().loadChange(this);
        }
        Project project2 = project;
        synchronized (project2) {
            this.getChange().apply(project);
            try {
                this._manager.saveChange(this);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.getChange().revert(project);
                throw new RuntimeException("Failed to apply change", e);
            }
        }
    }

    public void revert(Project project) {
        if (this.getChange() == null) {
            this._manager.loadChange(this);
        }
        this.getChange().revert(project);
    }

    public static HistoryEntry load(Project project, String s) throws IOException {
        ObjectMapper mapper = ParsingUtilities.mapper.copy();
        InjectableValues.Std injection = new InjectableValues.Std().addValue("projectID", (Object)project.id);
        mapper.setInjectableValues((InjectableValues)injection);
        return (HistoryEntry)mapper.readValue(s, HistoryEntry.class);
    }

    public void delete() {
        this._manager.delete(this);
    }
}

