/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.history;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.refine.ProjectManager;
import com.google.refine.ProjectMetadata;
import com.google.refine.RefineServlet;
import com.google.refine.history.Change;
import com.google.refine.history.HistoryEntry;
import com.google.refine.model.Project;
import com.google.refine.util.Pool;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;

public class History {
    protected long _projectID;
    @JsonProperty(value="past")
    protected List<HistoryEntry> _pastEntries;
    @JsonProperty(value="future")
    protected List<HistoryEntry> _futureEntries;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Change readOneChange(InputStream in, Pool pool) throws Exception {
        try (LineNumberReader reader = new LineNumberReader(new InputStreamReader(in, "UTF-8"));){
            Change change = History.readOneChange(reader, pool);
            return change;
        }
    }

    public static Change readOneChange(LineNumberReader reader, Pool pool) throws Exception {
        reader.readLine();
        String className = reader.readLine();
        Class<? extends Change> klass = History.getChangeClass(className);
        Method load = klass.getMethod("load", LineNumberReader.class, Pool.class);
        return (Change)load.invoke(null, reader, pool);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeOneChange(OutputStream out, Change change, Pool pool) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(out, "UTF-8");
        try {
            History.writeOneChange((Writer)writer, change, pool);
        }
        finally {
            ((Writer)writer).flush();
        }
    }

    public static void writeOneChange(Writer writer, Change change, Pool pool) throws IOException {
        Properties options = new Properties();
        options.setProperty("mode", "save");
        options.put("pool", pool);
        History.writeOneChange(writer, change, options);
    }

    public static void writeOneChange(Writer writer, Change change, Properties options) throws IOException {
        writer.write(RefineServlet.VERSION);
        writer.write(10);
        writer.write(change.getClass().getName());
        writer.write(10);
        change.save(writer, options);
    }

    public static Class<? extends Change> getChangeClass(String className) throws ClassNotFoundException {
        return RefineServlet.getClass(className);
    }

    public History(Project project) {
        this._projectID = project.id;
        this._pastEntries = new ArrayList<HistoryEntry>();
        this._futureEntries = new ArrayList<HistoryEntry>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEntry(HistoryEntry entry) {
        Project project;
        Project project2 = project = ProjectManager.singleton.getProject(this._projectID);
        synchronized (project2) {
            History history = this;
            synchronized (history) {
                entry.apply(project);
                this._pastEntries.add(entry);
                this.setModified();
                List<HistoryEntry> futureEntries = this._futureEntries;
                this._futureEntries = new ArrayList<HistoryEntry>();
                for (HistoryEntry entry2 : futureEntries) {
                    try {
                        entry2.delete();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    protected void setModified() {
        int rowCount = ProjectManager.singleton.getProject((long)this._projectID).rows.size();
        ProjectMetadata projectMetadata = ProjectManager.singleton.getProjectMetadata(this._projectID);
        projectMetadata.setRowCount(rowCount);
        projectMetadata.updateModified();
    }

    public synchronized List<HistoryEntry> getLastPastEntries(int count) {
        if (count <= 0) {
            return new LinkedList<HistoryEntry>(this._pastEntries);
        }
        return this._pastEntries.subList(Math.max(this._pastEntries.size() - count, 0), this._pastEntries.size());
    }

    public synchronized void undoRedo(long lastDoneEntryID) {
        if (lastDoneEntryID == 0L) {
            this.undo(this._pastEntries.size());
        } else {
            int i;
            for (i = 0; i < this._pastEntries.size(); ++i) {
                if (this._pastEntries.get((int)i).id != lastDoneEntryID) continue;
                this.undo(this._pastEntries.size() - i - 1);
                return;
            }
            for (i = 0; i < this._futureEntries.size(); ++i) {
                if (this._futureEntries.get((int)i).id != lastDoneEntryID) continue;
                this.redo(i + 1);
                return;
            }
        }
    }

    public synchronized long getPrecedingEntryID(long entryID) {
        int i;
        if (entryID == 0L) {
            return -1L;
        }
        for (i = 0; i < this._pastEntries.size(); ++i) {
            if (this._pastEntries.get((int)i).id != entryID) continue;
            return i == 0 ? 0L : this._pastEntries.get((int)(i - 1)).id;
        }
        for (i = 0; i < this._futureEntries.size(); ++i) {
            if (this._futureEntries.get((int)i).id != entryID) continue;
            if (i > 0) {
                return this._futureEntries.get((int)(i - 1)).id;
            }
            if (this._pastEntries.size() > 0) {
                return this._pastEntries.get((int)(this._pastEntries.size() - 1)).id;
            }
            return 0L;
        }
        return -1L;
    }

    protected HistoryEntry getEntry(long entryID) {
        int i;
        for (i = 0; i < this._pastEntries.size(); ++i) {
            if (this._pastEntries.get((int)i).id != entryID) continue;
            return this._pastEntries.get(i);
        }
        for (i = 0; i < this._futureEntries.size(); ++i) {
            if (this._futureEntries.get((int)i).id != entryID) continue;
            return this._futureEntries.get(i);
        }
        return null;
    }

    protected void undo(int times) {
        Project project = ProjectManager.singleton.getProject(this._projectID);
        while (times > 0 && this._pastEntries.size() > 0) {
            HistoryEntry entry = this._pastEntries.get(this._pastEntries.size() - 1);
            entry.revert(project);
            this.setModified();
            --times;
            this._pastEntries.remove(this._pastEntries.size() - 1);
            this._futureEntries.add(0, entry);
        }
    }

    protected void redo(int times) {
        Project project = ProjectManager.singleton.getProject(this._projectID);
        while (times > 0 && this._futureEntries.size() > 0) {
            HistoryEntry entry = this._futureEntries.get(0);
            entry.apply(project);
            this.setModified();
            --times;
            this._pastEntries.add(entry);
            this._futureEntries.remove(0);
        }
    }

    public synchronized void save(Writer writer, Properties options) throws IOException {
        writer.write("pastEntryCount=");
        writer.write(Integer.toString(this._pastEntries.size()));
        writer.write(10);
        for (HistoryEntry entry : this._pastEntries) {
            entry.save(writer, options);
            writer.write(10);
        }
        writer.write("futureEntryCount=");
        writer.write(Integer.toString(this._futureEntries.size()));
        writer.write(10);
        for (HistoryEntry entry : this._futureEntries) {
            entry.save(writer, options);
            writer.write(10);
        }
        writer.write("/e/\n");
    }

    public synchronized void load(Project project, LineNumberReader reader) throws IOException {
        String line;
        while ((line = reader.readLine()) != null && !"/e/".equals(line)) {
            int i;
            int count;
            int equal = line.indexOf(61);
            CharSequence field = line.subSequence(0, equal);
            String value = line.substring(equal + 1);
            if ("pastEntryCount".equals(field)) {
                count = Integer.parseInt(value);
                for (i = 0; i < count; ++i) {
                    this._pastEntries.add(HistoryEntry.load(project, reader.readLine()));
                }
                continue;
            }
            if (!"futureEntryCount".equals(field)) continue;
            count = Integer.parseInt(value);
            for (i = 0; i < count; ++i) {
                this._futureEntries.add(HistoryEntry.load(project, reader.readLine()));
            }
        }
    }
}

