/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.history;

import com.google.refine.history.Change;
import com.google.refine.history.History;
import com.google.refine.model.Project;
import com.google.refine.util.Pool;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Writer;
import java.util.Properties;

public class ChangeSequence
implements Change {
    protected final Change[] _changes;

    public ChangeSequence(Change[] changes) {
        this._changes = changes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void apply(Project project) {
        Project project2 = project;
        synchronized (project2) {
            for (Change change : this._changes) {
                change.apply(project);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void revert(Project project) {
        Project project2 = project;
        synchronized (project2) {
            for (int i = this._changes.length - 1; i >= 0; --i) {
                this._changes[i].revert(project);
            }
        }
    }

    @Override
    public void save(Writer writer, Properties options) throws IOException {
        writer.write("count=");
        writer.write(Integer.toString(this._changes.length));
        writer.write(10);
        for (Change change : this._changes) {
            History.writeOneChange(writer, change, options);
        }
        writer.write("/ec/\n");
    }

    public static Change load(LineNumberReader reader, Pool pool) throws Exception {
        String line = reader.readLine();
        if (line == null) {
            line = "";
        }
        int equal = line.indexOf(61);
        assert ("count".equals(line.substring(0, equal)));
        int count = Integer.parseInt(line.substring(equal + 1));
        Change[] changes = new Change[count];
        for (int i = 0; i < count; ++i) {
            changes[i] = History.readOneChange(reader, pool);
        }
        line = reader.readLine();
        assert ("/ec/".equals(line));
        return new ChangeSequence(changes);
    }
}

