/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.expr.util;

import com.fasterxml.jackson.databind.JsonNode;

public class JsonValueConverter {
    public static Object convert(JsonNode value) {
        if (value == null) {
            return null;
        }
        if (value.isObject()) {
            return value;
        }
        if (value.isArray()) {
            return value;
        }
        if (value.isBigDecimal() || value.isDouble() || value.isFloat()) {
            return value.asDouble();
        }
        if (value.isBigInteger()) {
            return value.asLong();
        }
        if (value.isInt()) {
            return value.asInt();
        }
        if (value.isBinary() || value.isTextual()) {
            return value.asText();
        }
        if (value.isBoolean()) {
            return value.asBoolean();
        }
        if (value.isNull()) {
            return null;
        }
        return null;
    }

    public static Comparable convertComparable(JsonNode value) {
        if (value == null) {
            return null;
        }
        if (value.isContainerNode()) {
            throw new IllegalArgumentException("Arrays and objects aren't comparable");
        }
        if (value.isBigDecimal() || value.isDouble() || value.isFloat()) {
            return Double.valueOf(value.asDouble());
        }
        if (value.isBigInteger()) {
            return Long.valueOf(value.asLong());
        }
        if (value.isInt()) {
            return Integer.valueOf(value.asInt());
        }
        if (value.isBinary() || value.isTextual()) {
            return value.asText();
        }
        if (value.isBoolean()) {
            return Boolean.valueOf(value.asBoolean());
        }
        if (value.isNull()) {
            return null;
        }
        return null;
    }
}

