/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.expr.util;

import com.google.refine.expr.util.CalendarParserException;
import com.google.refine.expr.util.ParserState;
import com.google.refine.util.ParsingUtilities;
import java.time.OffsetDateTime;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CalendarParser {
    public static final int YEAR_BEFORE_MONTH = 4;
    public static final int YEAR_BEFORE_DAY = 2;
    public static final int MONTH_BEFORE_DAY = 1;
    public static final int YEAR_AFTER_MONTH = 0;
    public static final int YEAR_AFTER_DAY = 0;
    public static final int MONTH_AFTER_DAY = 0;
    public static final int DD_MM_YY = 0;
    public static final int MM_DD_YY = 1;
    public static final int MM_YY_DD = 3;
    public static final int DD_YY_MM = 4;
    public static final int YY_DD_MM = 6;
    public static final int YY_MM_DD = 7;
    private static final String[] zoneNames = CalendarParser.loadTimeZoneNames();
    private static final int PLACE_UNKNOWN = 0;
    private static final int PLACE_HOUR = 1;
    private static final int PLACE_MINUTE = 2;
    private static final int PLACE_SECOND = 3;
    private static final int PLACE_MILLI = 4;
    private static final int CENTURY_OFFSET = 2000;
    private static final int UNSET = Integer.MIN_VALUE;
    private static final boolean DEBUG = false;
    private static final String[] WEEKDAY_NAMES = new String[]{"sunday", "monday", "tuesday", "wednesday", "thursday", "friday", "saturday"};
    private static final String[][] MONTHS = new String[][]{{"jan", "January"}, {"feb", "February"}, {"mar", "March"}, {"apr", "April"}, {"may", "May"}, {"jun", "June"}, {"jul", "July"}, {"aug", "August"}, {"sep", "September"}, {"oct", "October"}, {"nov", "November"}, {"dec", "December"}};

    private static final void appendTimeString(StringBuffer buf, Calendar cal, boolean needSpace) {
        TimeZone tz;
        int hour = cal.get(11);
        int minute = cal.get(12);
        int second = cal.get(13);
        int milli = cal.get(14);
        if (hour != 0 || minute != 0 || second != 0 || milli != 0) {
            if (needSpace) {
                buf.append(' ');
            }
            if (hour < 10) {
                buf.append(' ');
            }
            buf.append(hour);
            if (minute < 10) {
                buf.append(":0");
            } else {
                buf.append(':');
            }
            buf.append(minute);
            if (second != 0 || milli != 0) {
                if (second < 10) {
                    buf.append(":0");
                } else {
                    buf.append(':');
                }
                buf.append(second);
                if (milli != 0) {
                    if (milli < 10) {
                        buf.append(".00");
                    } else if (milli < 100) {
                        buf.append(".0");
                    } else {
                        buf.append('.');
                    }
                    buf.append(milli);
                }
            }
        }
        if ((tz = cal.getTimeZone()).getRawOffset() == 0) {
            buf.append(" GMT");
        } else {
            buf.append(' ');
            int offset = tz.getRawOffset() / 60000;
            if (offset < 0) {
                buf.append('-');
                offset = -offset;
            } else {
                buf.append('+');
            }
            int hrOff = offset / 60;
            if (hrOff < 10) {
                buf.append('0');
            }
            buf.append(hrOff);
            buf.append(':');
            int minOff = offset % 60;
            if (minOff < 10) {
                buf.append('0');
            }
            buf.append(minOff);
        }
    }

    public static final String getOrderString(int order) {
        switch (order) {
            case 0: {
                return "DD_MM_YY";
            }
            case 1: {
                return "MM_DD_YY";
            }
            case 3: {
                return "MM_YY_DD";
            }
            case 4: {
                return "DD_YY_MM";
            }
            case 6: {
                return "YY_DD_MM";
            }
            case 7: {
                return "YY_MM_DD";
            }
        }
        return "??" + order + "??";
    }

    private static final int getOrdinalNumber(String str) {
        String suffix;
        int len;
        int n = len = str == null ? 0 : str.length();
        if (len >= 3 && ((suffix = str.substring(len - 2)).equalsIgnoreCase("st") || suffix.equalsIgnoreCase("nd") || suffix.equalsIgnoreCase("rd") || suffix.equalsIgnoreCase("th"))) {
            try {
                return Integer.parseInt(str.substring(0, len - 2));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return Integer.MIN_VALUE;
    }

    private static final String getTimePlaceString(int place) {
        switch (place) {
            case 1: {
                return "hour";
            }
            case 2: {
                return "minute";
            }
            case 3: {
                return "second";
            }
            case 4: {
                return "millisecond";
            }
        }
        return "unknown";
    }

    private static final boolean isWeekdayName(String str) {
        if (str == null || str.length() < 3) {
            return false;
        }
        String lstr = str.toLowerCase();
        for (String element : WEEKDAY_NAMES) {
            if (!lstr.startsWith(element) && !element.toLowerCase().startsWith(lstr)) continue;
            return true;
        }
        return false;
    }

    private static final String[] loadTimeZoneNames() {
        String[] tmpList = TimeZone.getAvailableIDs();
        int numSaved = 0;
        String[] finalList = null;
        for (int i = 0; i < 2; ++i) {
            if (i > 0) {
                if (numSaved == 0) {
                    return null;
                }
                finalList = new String[numSaved];
                numSaved = 0;
            }
            for (int j = 0; j < tmpList.length; ++j) {
                int len = tmpList[j].length();
                if (len <= 2 || !Character.isUpperCase(tmpList[j].charAt(1)) || len == 7 && Character.isDigit(tmpList[j].charAt(3))) continue;
                if (finalList == null) {
                    ++numSaved;
                } else {
                    finalList[numSaved++] = tmpList[j];
                }
                if (len != 3 || tmpList[j].charAt(1) != 'S' || tmpList[j].charAt(2) != 'T') continue;
                if (finalList == null) {
                    ++numSaved;
                    continue;
                }
                StringBuffer dst = new StringBuffer();
                dst.append(tmpList[j].charAt(0));
                dst.append("DT");
                finalList[numSaved++] = dst.toString();
            }
        }
        return finalList;
    }

    public static int monthNameToNumber(String str) {
        if (str != null && str.length() >= 3) {
            String lstr = str.toLowerCase();
            for (int i = 0; i < MONTHS.length; ++i) {
                if (!lstr.startsWith(MONTHS[i][0]) && !MONTHS[i][1].toLowerCase().startsWith(lstr)) continue;
                return i + 1;
            }
        }
        return Integer.MIN_VALUE;
    }

    public static final Calendar parse(String dateStr) throws CalendarParserException {
        return CalendarParser.parse(dateStr, 7);
    }

    public static final OffsetDateTime parseAsOffsetDateTime(String dateStr) throws CalendarParserException {
        return ParsingUtilities.calendarToOffsetDateTime(CalendarParser.parse(dateStr));
    }

    public static final Calendar parse(String dateStr, int order) throws CalendarParserException {
        return CalendarParser.parse(dateStr, order, true);
    }

    public static final OffsetDateTime parseAsOffsetDateTime(String dateStr, int order) throws CalendarParserException {
        return ParsingUtilities.calendarToOffsetDateTime(CalendarParser.parse(dateStr, order));
    }

    public static final Calendar parse(String dateStr, int order, boolean ignoreChanges) throws CalendarParserException {
        if (dateStr == null) {
            return null;
        }
        return CalendarParser.parseString(dateStr, order, ignoreChanges);
    }

    public static final OffsetDateTime parseAsOffsetDateTime(String dateStr, int order, boolean ignoreChanges) throws CalendarParserException {
        return ParsingUtilities.calendarToOffsetDateTime(CalendarParser.parse(dateStr, order, ignoreChanges));
    }

    private static final void parseNonNumericToken(String dateStr, ParserState state, String token) throws CalendarParserException {
        if (CalendarParser.isWeekdayName(token)) {
            return;
        }
        if (token.indexOf(58) > 0) {
            char firstChar = token.charAt(0);
            if (Character.isDigit(firstChar)) {
                CalendarParser.parseTime(dateStr, state, token);
                return;
            }
            if (firstChar == '+' || firstChar == '-') {
                CalendarParser.parseTimeZoneOffset(dateStr, state, token);
                return;
            }
            throw new CalendarParserException("Unrecognized time \"" + token + "\" in date \"" + dateStr + "\"");
        }
        int tmpMon = CalendarParser.monthNameToNumber(token);
        if (tmpMon != Integer.MIN_VALUE) {
            if (!state.isMonthSet()) {
                state.setMonth(tmpMon);
                return;
            }
            if (!state.isYearSet()) {
                if (state.isDateSet() || state.isYearBeforeDay()) {
                    state.setYear(state.getMonth());
                    state.setMonth(tmpMon);
                } else {
                    state.setDate(state.getMonth());
                    state.setMonth(tmpMon);
                }
                return;
            }
            if (!state.isDateSet()) {
                state.setDate(state.getMonth());
                state.setMonth(tmpMon);
                return;
            }
            throw new CalendarParserException("Too many numbers in date \"" + dateStr + "\"");
        }
        int val = CalendarParser.getOrdinalNumber(token);
        if (val == Integer.MIN_VALUE) {
            String lToken = token.toLowerCase();
            if (lToken.equals("am")) {
                return;
            }
            if (lToken.equals("pm")) {
                if (!state.isHourSet()) {
                    state.setTimePostMeridian(true);
                } else {
                    state.setHour(state.getHour() + 12);
                }
                return;
            }
            if (zoneNames != null) {
                for (String zoneName : zoneNames) {
                    TimeZone tz;
                    if (!token.equalsIgnoreCase(zoneName) || (tz = TimeZone.getTimeZone(token)).getRawOffset() == 0 && !lToken.equals("gmt")) continue;
                    state.setTimeZone(tz);
                    return;
                }
            }
            throw new CalendarParserException("Unknown string \"" + token + "\" in date \"" + dateStr + "\"");
        }
        if (!state.isDateSet()) {
            state.setDate(val);
            return;
        }
        if (!state.isYearSet() || !state.isMonthSet()) {
            if (state.getDate() > 12) {
                if (!state.isYearSet()) {
                    state.setYear(state.getDate());
                    state.setDate(val);
                    return;
                }
                if (state.getYear() <= 12) {
                    state.setMonth(state.getYear());
                    state.setYear(state.getDate());
                    state.setDate(val);
                    return;
                }
            } else {
                if (!state.isYearSet()) {
                    if (!state.isMonthSet() && !state.isYearBeforeMonth()) {
                        state.setMonth(state.getDate());
                        state.setDate(val);
                        return;
                    }
                    state.setYear(state.getDate());
                    state.setDate(val);
                    return;
                }
                state.setMonth(state.getDate());
                state.setDate(val);
                return;
            }
        }
        throw new CalendarParserException("Cannot assign ordinal in \"" + dateStr + "\"");
    }

    private static final void parseNumericBlob(String dateStr, ParserState state, int val) throws CalendarParserException {
        if (state.isYearSet() || state.isMonthSet() || state.isDateSet()) {
            throw new CalendarParserException("Unknown value " + val + " in date \"" + dateStr + "\"");
        }
        int tmpVal = val;
        if (state.isYearBeforeMonth()) {
            if (state.isYearBeforeDay()) {
                int last = tmpVal % 100;
                int middle = (tmpVal /= 100) % 100;
                state.setYear(tmpVal /= 100);
                if (state.isMonthBeforeDay()) {
                    state.setMonth(middle);
                    state.setDate(last);
                } else {
                    state.setDate(middle);
                    state.setMonth(last);
                }
            } else {
                state.setMonth(tmpVal % 100);
                state.setYear((tmpVal /= 100) % 10000);
                state.setDate(tmpVal /= 10000);
            }
        } else if (state.isYearBeforeDay()) {
            state.setDate(tmpVal % 100);
            state.setYear((tmpVal /= 100) % 10000);
            state.setMonth(tmpVal /= 10000);
        } else {
            state.setYear(tmpVal % 10000);
            int middle = (tmpVal /= 10000) % 100;
            tmpVal /= 100;
            if (state.isMonthBeforeDay()) {
                state.setDate(middle);
                state.setMonth(tmpVal);
            } else {
                state.setDate(tmpVal);
                state.setMonth(middle);
            }
        }
    }

    private static final void parseNumericToken(String dateStr, ParserState state, int val) throws CalendarParserException {
        if (state.isYearSet() && state.isMonthSet() && state.isDateSet()) {
            throw new CalendarParserException("Extra value \"" + val + "\" in date \"" + dateStr + "\"");
        }
        if (val < 0) {
            throw new CalendarParserException("Found negative number in date \"" + dateStr + "\"");
        }
        if (val > 9999) {
            CalendarParser.parseNumericBlob(dateStr, state, val);
            return;
        }
        if (val > 31) {
            if (!state.isYearSet()) {
                state.setYear(val);
                return;
            }
            if (state.getYear() > 31) {
                String errMsg = "Couldn't decide on year number in date \"" + dateStr + "\"";
                throw new CalendarParserException(errMsg);
            }
            if (state.getYear() > 12) {
                if (!state.isDateSet()) {
                    state.setDate(state.getYear());
                    state.setYear(val);
                    return;
                }
                if (state.getDate() <= 12) {
                    state.setMonth(state.getDate());
                    state.setDate(state.getYear());
                    state.setYear(val);
                    return;
                }
                throw new CalendarParserException("Bad number " + val + " found in date \"" + dateStr + "\"");
            }
            if (!state.isDateSet() && !state.isMonthSet()) {
                if (state.isMonthBeforeDay()) {
                    state.setMonth(state.getYear());
                    state.setYear(val);
                } else {
                    state.setDate(state.getYear());
                    state.setYear(val);
                }
                return;
            }
            if (!state.isDateSet()) {
                state.setDate(state.getYear());
                state.setYear(val);
                return;
            }
            state.setMonth(state.getYear());
            state.setYear(val);
            return;
        }
        if (val > 12) {
            if (!state.isYearSet()) {
                if (state.isDateSet() || state.isYearBeforeDay()) {
                    state.setYear(val);
                } else {
                    state.setDate(val);
                }
                return;
            }
            if (!state.isDateSet()) {
                state.setDate(val);
                return;
            }
            throw new CalendarParserException("Bad number " + val + " found in date \"" + dateStr + "\"");
        }
        if (state.isYearSet()) {
            if (state.isMonthSet() || !state.isDateSet() && !state.isMonthBeforeDay()) {
                state.setDate(val);
            } else {
                state.setMonth(val);
            }
            return;
        }
        if (state.isMonthSet()) {
            if (state.isDateSet() || state.isYearBeforeDay()) {
                state.setYear(val);
            } else {
                state.setDate(val);
            }
            return;
        }
        if (state.isDateSet()) {
            if (state.isYearBeforeMonth()) {
                state.setYear(val);
            } else {
                state.setMonth(val);
            }
            return;
        }
        if (state.isYearBeforeMonth()) {
            if (state.isYearBeforeDay()) {
                state.setYear(val);
            } else {
                state.setDate(val);
            }
        } else if (state.isMonthBeforeDay()) {
            state.setMonth(val);
        } else {
            state.setDate(val);
        }
    }

    private static final Calendar parseString(String dateStr, int order, boolean ignoreChanges) throws CalendarParserException {
        ParserState state = new ParserState(order);
        Pattern pat = Pattern.compile("([\\s/,]+|(\\S)\\-)");
        Matcher matcher = pat.matcher(dateStr);
        int prevEnd = 0;
        while (prevEnd < dateStr.length()) {
            Object token;
            if (!matcher.find()) {
                token = dateStr.substring(prevEnd);
                prevEnd = dateStr.length();
            } else {
                boolean isMinus = matcher.groupCount() == 2 && matcher.group(2) != null;
                token = !isMinus ? dateStr.substring(prevEnd, matcher.start()) : dateStr.substring(prevEnd, matcher.start()) + matcher.group(2);
                prevEnd = matcher.end();
            }
            try {
                int val = Integer.parseInt((String)token);
                CalendarParser.parseNumericToken(dateStr, state, val);
            }
            catch (NumberFormatException e) {
                CalendarParser.parseNonNumericToken(dateStr, state, (String)token);
            }
        }
        if (!state.isDateSet() && state.getYear() <= 31) {
            int tmp = state.getDate();
            state.setDate(state.getYear());
            state.setYear(tmp);
        }
        if (!state.isDateSet()) {
            if (!state.isMonthSet()) {
                if (!state.isYearSet()) {
                    throw new CalendarParserException("No date found in \"" + dateStr + "\"");
                }
                throw new CalendarParserException("Day and month missing from \"" + dateStr + "\"");
            }
            throw new CalendarParserException("Day missing from \"" + dateStr + "\"");
        }
        if (!state.isMonthSet()) {
            if (!state.isYearSet()) {
                throw new CalendarParserException("Year and month missing from \"" + dateStr + "\"");
            }
            throw new CalendarParserException("Month missing from \"" + dateStr + "\"");
        }
        if (!state.isYearSet()) {
            throw new CalendarParserException("Year missing from \"" + dateStr + "\"");
        }
        int tmpYear = state.getYear();
        if (tmpYear < 50) {
            state.setYear(tmpYear + 2000);
        } else if (tmpYear < 100) {
            state.setYear(tmpYear + 1900);
        }
        GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("Z"));
        state.setCalendar(cal, ignoreChanges);
        return cal;
    }

    private static final void parseTime(String dateStr, ParserState state, String timeStr) throws CalendarParserException {
        String[] tList;
        String tmpTime;
        int place = 1;
        char lastChar = timeStr.charAt(timeStr.length() - 1);
        if (lastChar != 'm' && lastChar != 'M') {
            tmpTime = timeStr;
        } else {
            char preLast = timeStr.charAt(timeStr.length() - 2);
            if (preLast == 'a' || preLast == 'A') {
                state.setTimePostMeridian(false);
            } else if (preLast == 'p' || preLast == 'P') {
                state.setTimePostMeridian(true);
            } else {
                throw new CalendarParserException("Bad time \"" + timeStr + "\" in date \"" + dateStr + "\"");
            }
            tmpTime = timeStr.substring(0, timeStr.length() - 2);
        }
        block16: for (String token : tList = tmpTime.split("[:\\.]")) {
            int val;
            try {
                val = Integer.parseInt(token);
            }
            catch (NumberFormatException nfe) {
                throw new CalendarParserException("Bad " + CalendarParser.getTimePlaceString(place) + " string \"" + token + "\" in \"" + dateStr + "\"");
            }
            switch (place) {
                case 1: {
                    try {
                        state.setHour(val);
                    }
                    catch (CalendarParserException dfe) {
                        throw new CalendarParserException(dfe.getMessage() + " in \"" + dateStr + "\"");
                    }
                    place = 2;
                    continue block16;
                }
                case 2: {
                    try {
                        state.setMinute(val);
                    }
                    catch (CalendarParserException dfe) {
                        throw new CalendarParserException(dfe.getMessage() + " in \"" + dateStr + "\"");
                    }
                    place = 3;
                    continue block16;
                }
                case 3: {
                    try {
                        state.setSecond(val);
                    }
                    catch (CalendarParserException dfe) {
                        throw new CalendarParserException(dfe.getMessage() + " in \"" + dateStr + "\"");
                    }
                    place = 4;
                    continue block16;
                }
                case 4: {
                    try {
                        state.setMillisecond(val);
                    }
                    catch (CalendarParserException dfe) {
                        throw new CalendarParserException(dfe.getMessage() + " in \"" + dateStr + "\"");
                    }
                    place = 0;
                    continue block16;
                }
                default: {
                    throw new CalendarParserException("Unexpected place value " + place);
                }
            }
        }
    }

    private static final void parseTimeZoneOffset(String dateStr, ParserState state, String zoneStr) throws CalendarParserException {
        String[] tList;
        boolean isNegative;
        int place = 1;
        boolean bl = isNegative = zoneStr.charAt(0) == '-';
        if (!isNegative && zoneStr.charAt(0) != '+') {
            throw new CalendarParserException("Bad time zone offset \"" + zoneStr + "\" in date \"" + dateStr + "\"");
        }
        int hour = Integer.MIN_VALUE;
        int minute = Integer.MIN_VALUE;
        block6: for (String token : tList = zoneStr.substring(1).split(":")) {
            int val;
            try {
                val = Integer.parseInt(token);
            }
            catch (NumberFormatException nfe) {
                throw new CalendarParserException("Bad time zone " + CalendarParser.getTimePlaceString(place) + " offset \"" + token + "\" in \"" + dateStr + "\"");
            }
            switch (place) {
                case 1: {
                    hour = val;
                    place = 2;
                    continue block6;
                }
                case 2: {
                    minute = val;
                    place = 0;
                    continue block6;
                }
                default: {
                    throw new CalendarParserException("Unexpected place value " + place);
                }
            }
        }
        String customID = "GMT" + (isNegative ? "-" : "+") + hour + ":" + (minute < 10 ? "0" : "") + minute;
        state.setTimeZone(TimeZone.getTimeZone(customID));
    }

    public static final String toString(Calendar cal) {
        if (cal == null) {
            return null;
        }
        int calYear = cal.get(1);
        int calMonth = cal.get(2);
        int calDay = cal.get(5);
        boolean needSpace = false;
        StringBuffer buf = new StringBuffer();
        if (calDay > 0) {
            if (needSpace) {
                buf.append(' ');
            }
            buf.append(calDay);
            needSpace = true;
        }
        if (calMonth >= 0 && calMonth < MONTHS.length) {
            if (needSpace) {
                buf.append(' ');
            }
            buf.append(MONTHS[calMonth][1].substring(0, 3));
            needSpace = true;
        }
        if (calYear > Integer.MIN_VALUE) {
            if (needSpace) {
                buf.append(' ');
            }
            buf.append(calYear);
        }
        CalendarParser.appendTimeString(buf, cal, needSpace);
        return buf.toString();
    }
}

