/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.expr;

import com.google.refine.expr.CellTuple;
import com.google.refine.expr.ExpressionUtils;
import com.google.refine.expr.HasFields;
import com.google.refine.expr.HasFieldsListImpl;
import com.google.refine.expr.WrappedCell;
import com.google.refine.model.Cell;
import com.google.refine.model.Column;
import com.google.refine.model.Project;
import com.google.refine.model.Record;
import com.google.refine.model.Row;
import java.util.Properties;

public class WrappedRow
implements HasFields {
    public final Project project;
    public final int rowIndex;
    public final Row row;

    public WrappedRow(Project project, int rowIndex, Row row) {
        this.project = project;
        this.rowIndex = rowIndex;
        this.row = row;
    }

    @Override
    public Object getField(String name, Properties bindings) {
        if ("cells".equals(name)) {
            return new CellTuple(this.project, this.row);
        }
        if ("index".equals(name)) {
            return this.rowIndex;
        }
        if ("record".equals(name)) {
            return new WrappedRecord(this.project.recordModel.getRecordOfRow(this.rowIndex));
        }
        if ("columnNames".equals(name)) {
            return this.project.columnModel.getColumnNames();
        }
        return this.row.getField(name, bindings);
    }

    @Override
    public boolean fieldAlsoHasFields(String name) {
        return this.row.fieldAlsoHasFields(name);
    }

    protected class WrappedRecord
    implements HasFields {
        final Record _record;

        protected WrappedRecord(Record record) {
            this._record = record;
        }

        @Override
        public Object getField(String name, Properties bindings) {
            if ("cells".equals(name)) {
                return new RecordCells(this._record);
            }
            if ("index".equals(name)) {
                return this._record.recordIndex;
            }
            if ("fromRowIndex".equals(name)) {
                return this._record.fromRowIndex;
            }
            if ("toRowIndex".equals(name)) {
                return this._record.toRowIndex;
            }
            if ("rowCount".equals(name)) {
                return this._record.toRowIndex - this._record.fromRowIndex;
            }
            return null;
        }

        @Override
        public boolean fieldAlsoHasFields(String name) {
            return "cells".equals(name);
        }
    }

    protected class RecordCells
    implements HasFields {
        final Record _record;

        protected RecordCells(Record record) {
            this._record = record;
        }

        @Override
        public Object getField(String name, Properties bindings) {
            Column column = WrappedRow.this.project.columnModel.getColumnByName(name);
            if (column != null) {
                int cellIndex = column.getCellIndex();
                HasFieldsListImpl cells = new HasFieldsListImpl();
                for (int r = this._record.fromRowIndex; r < this._record.toRowIndex; ++r) {
                    Row row = WrappedRow.this.project.rows.get(r);
                    Cell cell = row.getCell(cellIndex);
                    if (cell == null || !ExpressionUtils.isNonBlankData(cell.value)) continue;
                    cells.add(new WrappedCell(WrappedRow.this.project, name, cell));
                }
                return cells;
            }
            return null;
        }

        @Override
        public boolean fieldAlsoHasFields(String name) {
            return true;
        }
    }
}

