/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.expr;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.refine.expr.Binder;
import com.google.refine.expr.CellTuple;
import com.google.refine.expr.EvalError;
import com.google.refine.expr.WrappedCell;
import com.google.refine.expr.WrappedRow;
import com.google.refine.model.Cell;
import com.google.refine.model.Project;
import com.google.refine.model.Row;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public class ExpressionUtils {
    protected static final Set<Binder> s_binders = new HashSet<Binder>();

    public static void registerBinder(Binder binder) {
        s_binders.add(binder);
    }

    public static Properties createBindings(Project project) {
        Properties bindings = new Properties();
        bindings.put("true", (Object)true);
        bindings.put("false", (Object)false);
        bindings.put("PI", (Object)Math.PI);
        bindings.put("project", project);
        for (Binder binder : s_binders) {
            binder.initializeBindings(bindings, project);
        }
        return bindings;
    }

    public static void bind(Properties bindings, Row row, int rowIndex, String columnName, Cell cell) {
        Project project = (Project)bindings.get("project");
        bindings.put("rowIndex", (Object)rowIndex);
        bindings.put("row", new WrappedRow(project, rowIndex, row));
        bindings.put("cells", new CellTuple(project, row));
        if (columnName != null) {
            bindings.put("columnName", columnName);
        }
        if (cell == null) {
            bindings.remove("cell");
            bindings.remove("value");
        } else {
            bindings.put("cell", new WrappedCell(project, columnName, cell));
            if (cell.value == null) {
                bindings.remove("value");
            } else {
                bindings.put("value", cell.value);
            }
        }
        for (Binder binder : s_binders) {
            binder.bind(bindings, row, rowIndex, columnName, cell);
        }
    }

    public static boolean isError(Object o) {
        return o instanceof EvalError;
    }

    public static boolean isNonBlankData(Object o) {
        return o != null && !(o instanceof EvalError) && (!(o instanceof String) || ((String)o).length() > 0);
    }

    public static boolean isTrue(Object o) {
        return o != null && (o instanceof Boolean ? (Boolean)o != false : Boolean.parseBoolean(o.toString()));
    }

    public static boolean sameValue(Object v1, Object v2) {
        if (v1 == null) {
            return v2 == null;
        }
        if (v2 == null) {
            return v1 == null;
        }
        return v1.equals(v2);
    }

    public static boolean isStorable(Object v) {
        return v == null || v instanceof Number || v instanceof String || v instanceof Boolean || v instanceof OffsetDateTime || v instanceof EvalError;
    }

    public static Serializable wrapStorable(Object v) {
        if (v instanceof ArrayNode) {
            return ((ArrayNode)v).toString();
        }
        if (v instanceof ObjectNode) {
            return ((ObjectNode)v).toString();
        }
        return ExpressionUtils.isStorable(v) ? (Serializable)v : new EvalError(v.getClass().getSimpleName() + " value not storable");
    }

    public static boolean isArray(Object v) {
        return v != null && v.getClass().isArray();
    }

    public static boolean isArrayOrCollection(Object v) {
        return v != null && (v.getClass().isArray() || v instanceof Collection);
    }

    public static boolean isArrayOrList(Object v) {
        return v != null && (v.getClass().isArray() || v instanceof List);
    }

    public static List<Object> toObjectList(Object v) {
        return (List)v;
    }

    public static Collection<Object> toObjectCollection(Object v) {
        return (Collection)v;
    }
}

