/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.commands;

import com.google.refine.browsing.EngineConfig;
import com.google.refine.commands.Command;
import com.google.refine.model.AbstractOperation;
import com.google.refine.model.Project;
import com.google.refine.process.Process;
import java.io.IOException;
import java.util.Properties;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class EngineDependentCommand
extends Command {
    @Override
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (!this.hasValidCSRFToken(request)) {
            EngineDependentCommand.respondCSRFError(response);
            return;
        }
        try {
            Project project = this.getProject(request);
            AbstractOperation op = this.createOperation(project, request, EngineDependentCommand.getEngineConfig(request));
            op.validate();
            Process process = op.createProcess(project, new Properties());
            EngineDependentCommand.performProcessAndRespond(request, response, project, process);
        }
        catch (Exception e) {
            EngineDependentCommand.respondException(response, e);
        }
    }

    protected abstract AbstractOperation createOperation(Project var1, HttpServletRequest var2, EngineConfig var3) throws Exception;
}

