/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.commands;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.security.SecureRandom;
import java.time.Instant;
import java.util.Random;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.RandomStringUtils;

public class CSRFTokenFactory {
    protected final LoadingCache<String, Instant> tokenCache;
    protected final long timeToLive;
    protected final int tokenLength;
    protected final SecureRandom rng;

    public CSRFTokenFactory(long timeToLive, int tokenLength) {
        this.tokenCache = CacheBuilder.newBuilder().expireAfterWrite(timeToLive, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<String, Instant>(){

            public Instant load(String key) {
                return Instant.now();
            }
        });
        this.timeToLive = timeToLive;
        this.rng = new SecureRandom();
        this.tokenLength = tokenLength;
    }

    public String getFreshToken() {
        String token = RandomStringUtils.random((int)this.tokenLength, (int)0, (int)0, (boolean)true, (boolean)true, null, (Random)this.rng);
        try {
            this.tokenCache.get((Object)token);
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
        return token;
    }

    public boolean validToken(String token) {
        ConcurrentMap map = this.tokenCache.asMap();
        Instant cutoff = Instant.now().minusSeconds(this.timeToLive);
        return map.containsKey(token) && ((Instant)map.get(token)).isAfter(cutoff);
    }
}

