/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.clustering.binning;

import com.google.common.base.CharMatcher;
import com.google.common.collect.ImmutableMap;
import com.google.refine.clustering.binning.Keyer;
import java.text.Normalizer;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class FingerprintKeyer
extends Keyer {
    static final Pattern punctctrl = Pattern.compile("\\p{Punct}|[\\x00-\\x08\\x0E-\\x1F\\x7F\\x80-\\x84\\x86-\\x9F]", 256);
    public static final Pattern DIACRITICS_AND_FRIENDS = Pattern.compile("[\\p{InCombiningDiacriticalMarks}\\p{IsLm}\\p{IsSk}]+");
    private static final Pattern WHITESPACE = Pattern.compile("\\s+", 256);
    private static final ImmutableMap<String, String> NONDIACRITICS = ImmutableMap.builder().put((Object)"\u00df", (Object)"ss").put((Object)"\u00e6", (Object)"ae").put((Object)"\u00f8", (Object)"oe").put((Object)"\u00e5", (Object)"aa").put((Object)"\u00a9", (Object)"c").put((Object)"\u00f0", (Object)"d").put((Object)"\u0111", (Object)"d").put((Object)"\u0256", (Object)"d").put((Object)"\u00fe", (Object)"th").put((Object)"\u01bf", (Object)"w").put((Object)"\u0127", (Object)"h").put((Object)"\u0131", (Object)"i").put((Object)"\u0138", (Object)"k").put((Object)"\u0142", (Object)"l").put((Object)"\u014b", (Object)"n").put((Object)"\u017f", (Object)"s").put((Object)"\u0167", (Object)"t").put((Object)"\u0153", (Object)"oe").put((Object)"\u1e9c", (Object)"s").put((Object)"\u1e9d", (Object)"s").build();

    @Override
    public String key(String s, Object ... o) {
        if (s == null || o != null && o.length > 0) {
            throw new IllegalArgumentException("Fingerprint keyer accepts a single string parameter");
        }
        return WHITESPACE.splitAsStream(this.normalize(s, true)).sorted().distinct().collect(Collectors.joining(" "));
    }

    protected String normalize(String s) {
        s = this.normalize(s, false);
        return s;
    }

    protected String normalize(String s, boolean strong) {
        if (strong) {
            s = CharMatcher.whitespace().trimFrom((CharSequence)s);
            s = s.toLowerCase();
        }
        s = FingerprintKeyer.stripDiacritics(s);
        s = FingerprintKeyer.stripNonDiacritics(s);
        if (strong) {
            s = punctctrl.matcher(s).replaceAll("");
        }
        return s;
    }

    @Deprecated
    protected String asciify(String s) {
        return this.normalize(s);
    }

    protected static String stripDiacritics(String str) {
        str = Normalizer.normalize(str, Normalizer.Form.NFKD);
        str = DIACRITICS_AND_FRIENDS.matcher(str).replaceAll("");
        return str;
    }

    private static String stripNonDiacritics(String orig) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < orig.length(); ++i) {
            String source = orig.substring(i, i + 1);
            String replace = (String)NONDIACRITICS.get((Object)source);
            result.append(replace == null ? source : replace);
        }
        return result.toString();
    }
}

