/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.clustering.binning;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.refine.browsing.Engine;
import com.google.refine.browsing.FilteredRows;
import com.google.refine.browsing.RowVisitor;
import com.google.refine.clustering.ClusteredEntry;
import com.google.refine.clustering.Clusterer;
import com.google.refine.clustering.ClustererConfig;
import com.google.refine.clustering.binning.Keyer;
import com.google.refine.clustering.binning.KeyerFactory;
import com.google.refine.clustering.binning.NGramFingerprintKeyer;
import com.google.refine.model.Cell;
import com.google.refine.model.Project;
import com.google.refine.model.Row;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinningClusterer
extends Clusterer {
    protected Keyer _keyer;
    protected BinningParameters _parameters;
    static final Logger logger = LoggerFactory.getLogger((String)"binning_clusterer");
    List<Map<String, Integer>> _clusters;

    public void initializeFromConfig(Project project, BinningClustererConfig config) {
        super.initializeFromConfig(project, config);
        this._keyer = config.getKeyer();
        this._parameters = config.getParameters();
    }

    @Override
    public void computeClusters(Engine engine) {
        BinningRowVisitor visitor = new BinningRowVisitor(this._keyer, this._parameters);
        FilteredRows filteredRows = engine.getAllFilteredRows();
        filteredRows.accept(this._project, visitor);
        Map<String, Map<String, Integer>> map = visitor.getMap();
        this._clusters = new ArrayList<Map<String, Integer>>(map.values());
        Collections.sort(this._clusters, new SizeComparator());
    }

    protected static Map<String, Object> entryToMap(Map.Entry<String, Integer> entry) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("v", entry.getKey());
        map.put("c", entry.getValue());
        return map;
    }

    @JsonValue
    public List<List<ClusteredEntry>> getJsonRepresentation() {
        EntriesComparator c = new EntriesComparator();
        return this._clusters.stream().filter(m -> m.size() > 1).map(m -> m.entrySet().stream().sorted(c).map(e -> new ClusteredEntry((Serializable)e.getKey(), (Integer)e.getValue())).collect(Collectors.toList())).collect(Collectors.toList());
    }

    public static class BinningClustererConfig
    extends ClustererConfig {
        @JsonIgnore
        private String _keyerName;
        @JsonIgnore
        private Keyer _keyer;
        @JsonIgnore
        private BinningParameters _parameters = null;

        @JsonIgnore
        public Keyer getKeyer() {
            return this._keyer;
        }

        @JsonProperty(value="function")
        public void setKeyer(String keyerName) {
            this._keyerName = keyerName;
            this._keyer = KeyerFactory.get(this._keyerName.toLowerCase());
        }

        @JsonProperty(value="function")
        public String getKeyerName() {
            return this._keyerName;
        }

        @JsonProperty(value="params")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public BinningParameters getParameters() {
            return this._parameters;
        }

        @JsonProperty(value="params")
        public void setParameters(BinningParameters params) {
            this._parameters = params;
        }

        @Override
        public BinningClusterer apply(Project project) {
            BinningClusterer clusterer = new BinningClusterer();
            clusterer.initializeFromConfig(project, this);
            return clusterer;
        }

        @Override
        public String getType() {
            return "binning";
        }
    }

    public static class BinningParameters {
        @JsonProperty(value="ngram-size")
        @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
        public int ngramSize = 0;
    }

    class BinningRowVisitor
    implements RowVisitor {
        Keyer _keyer;
        Object[] _params;
        BinningParameters _parameters;
        Map<String, Map<String, Integer>> _map = new HashMap<String, Map<String, Integer>>();

        public BinningRowVisitor(Keyer k, BinningParameters parameters) {
            this._keyer = k;
            this._parameters = parameters;
            if (k instanceof NGramFingerprintKeyer && this._parameters != null) {
                this._params = new Object[1];
                this._params[0] = this._parameters.ngramSize;
            }
        }

        @Override
        public void start(Project project) {
        }

        @Override
        public void end(Project project) {
        }

        @Override
        public boolean visit(Project project, int rowIndex, Row row) {
            Cell cell = row.getCell(BinningClusterer.this._colindex);
            if (cell != null && cell.value != null) {
                Serializable v = cell.value;
                String s = v instanceof String ? (String)((Object)v) : v.toString();
                String key = this._keyer.key(s, this._params);
                if (this._map.containsKey(key)) {
                    Map<String, Integer> m = this._map.get(key);
                    if (m.containsKey(s)) {
                        m.put(s, m.get(s) + 1);
                    } else {
                        m.put(s, 1);
                    }
                } else {
                    TreeMap<String, Integer> m = new TreeMap<String, Integer>();
                    m.put(s, 1);
                    this._map.put(key, m);
                }
            }
            return false;
        }

        public Map<String, Map<String, Integer>> getMap() {
            return this._map;
        }
    }

    public static class SizeComparator
    implements Comparator<Map<String, Integer>>,
    Serializable {
        private static final long serialVersionUID = -1390696157208674054L;

        @Override
        public int compare(Map<String, Integer> o1, Map<String, Integer> o2) {
            int s1 = o1.size();
            int s2 = o2.size();
            if (o1 == o2) {
                int total1 = 0;
                for (int i : o1.values()) {
                    total1 += i;
                }
                int total2 = 0;
                for (int i : o2.values()) {
                    total2 += i;
                }
                return total2 - total1;
            }
            return s2 - s1;
        }
    }

    public static class EntriesComparator
    implements Comparator<Map.Entry<String, Integer>>,
    Serializable {
        private static final long serialVersionUID = 2763378036791777964L;

        @Override
        public int compare(Map.Entry<String, Integer> o1, Map.Entry<String, Integer> o2) {
            return o2.getValue() - o1.getValue();
        }
    }
}

