/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.browsing.util;

import com.google.refine.browsing.util.RowEvaluable;
import com.google.refine.expr.ExpressionUtils;
import com.google.refine.model.Project;
import com.google.refine.model.Row;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public abstract class NumericBinIndex {
    protected int _totalValueCount;
    protected int _numbericValueCount;
    protected double _min = Double.POSITIVE_INFINITY;
    protected double _max = Double.NEGATIVE_INFINITY;
    protected double _step;
    protected int[] _bins;
    protected int _numericRowCount;
    protected int _nonNumericRowCount;
    protected int _blankRowCount;
    protected int _errorRowCount;
    protected boolean _hasError = false;
    protected boolean _hasNonNumeric = false;
    protected boolean _hasNumeric = false;
    protected boolean _hasBlank = false;

    protected abstract void iterate(Project var1, RowEvaluable var2, List<Double> var3);

    public NumericBinIndex(Project project, RowEvaluable rowEvaluable) {
        ArrayList<Double> allValues = new ArrayList<Double>();
        this.iterate(project, rowEvaluable, allValues);
        this._numbericValueCount = allValues.size();
        if (this._min >= this._max) {
            this._step = 1.0;
            this._min = Math.min(this._min, this._max);
            this._max = this._min + this._step;
            this._bins = new int[1];
            return;
        }
        double diff = this._max - this._min;
        this._step = 1.0;
        if (diff > 10.0) {
            while (this._step * 100.0 < diff) {
                this._step *= 10.0;
            }
        } else {
            while (this._step * 100.0 > diff) {
                this._step /= 10.0;
            }
        }
        double originalMax = this._max;
        this._min = Math.floor(this._min / this._step) * this._step;
        this._max = Math.ceil(this._max / this._step) * this._step;
        double binCount = (this._max - this._min) / this._step;
        if (binCount > 100.0) {
            this._step *= 2.0;
            binCount = (binCount + 1.0) / 2.0;
        }
        if (this._max <= originalMax) {
            this._max += this._step;
            binCount += 1.0;
        }
        this._bins = new int[(int)Math.round(binCount)];
        Iterator iterator = allValues.iterator();
        while (iterator.hasNext()) {
            int bin;
            double d = (Double)iterator.next();
            int n = bin = Math.max((int)Math.floor((d - this._min) / this._step), 0);
            this._bins[n] = this._bins[n] + 1;
        }
    }

    public boolean isNumeric() {
        return this._numbericValueCount > this._totalValueCount / 2;
    }

    public double getMin() {
        return this._min;
    }

    public double getMax() {
        return this._max;
    }

    public double getStep() {
        return this._step;
    }

    public int[] getBins() {
        return this._bins;
    }

    public int getNumericRowCount() {
        return this._numericRowCount;
    }

    public int getNonNumericRowCount() {
        return this._nonNumericRowCount;
    }

    public int getBlankRowCount() {
        return this._blankRowCount;
    }

    public int getErrorRowCount() {
        return this._errorRowCount;
    }

    protected void processRow(Project project, RowEvaluable rowEvaluable, List<Double> allValues, int rowIndex, Row row, Properties bindings) {
        Object value = rowEvaluable.eval(project, rowIndex, row, bindings);
        if (ExpressionUtils.isError(value)) {
            this._hasError = true;
        } else if (ExpressionUtils.isNonBlankData(value)) {
            if (value.getClass().isArray()) {
                Object[] a;
                for (Object v : a = (Object[])value) {
                    ++this._totalValueCount;
                    if (ExpressionUtils.isError(v)) {
                        this._hasError = true;
                        continue;
                    }
                    if (ExpressionUtils.isNonBlankData(v)) {
                        if (v instanceof Number) {
                            if (this.processValue(((Number)v).doubleValue(), allValues)) {
                                this._hasNumeric = true;
                                continue;
                            }
                            this._hasError = true;
                            continue;
                        }
                        this._hasNonNumeric = true;
                        continue;
                    }
                    this._hasBlank = true;
                }
            } else if (value instanceof Collection) {
                for (Object v : ExpressionUtils.toObjectCollection(value)) {
                    ++this._totalValueCount;
                    if (ExpressionUtils.isError(v)) {
                        this._hasError = true;
                        continue;
                    }
                    if (ExpressionUtils.isNonBlankData(v)) {
                        if (v instanceof Number) {
                            if (this.processValue(((Number)v).doubleValue(), allValues)) {
                                this._hasNumeric = true;
                                continue;
                            }
                            this._hasError = true;
                            continue;
                        }
                        this._hasNonNumeric = true;
                        continue;
                    }
                    this._hasBlank = true;
                }
            } else {
                ++this._totalValueCount;
                if (value instanceof Number) {
                    if (this.processValue(((Number)value).doubleValue(), allValues)) {
                        this._hasNumeric = true;
                    } else {
                        this._hasError = true;
                    }
                } else {
                    this._hasNonNumeric = true;
                }
            }
        } else {
            this._hasBlank = true;
        }
    }

    protected void preprocessing() {
        this._hasBlank = false;
        this._hasError = false;
        this._hasNonNumeric = false;
        this._hasNumeric = false;
    }

    protected void postprocessing() {
        if (this._hasError) {
            ++this._errorRowCount;
        }
        if (this._hasBlank) {
            ++this._blankRowCount;
        }
        if (this._hasNumeric) {
            ++this._numericRowCount;
        }
        if (this._hasNonNumeric) {
            ++this._nonNumericRowCount;
        }
    }

    protected boolean processValue(double v, List<Double> allValues) {
        if (!Double.isInfinite(v) && !Double.isNaN(v)) {
            this._min = Math.min(this._min, v);
            this._max = Math.max(this._max, v);
            allValues.add(v);
            return true;
        }
        return false;
    }
}

