/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.browsing.util;

import com.google.refine.browsing.RecordVisitor;
import com.google.refine.browsing.RowVisitor;
import com.google.refine.browsing.util.RowEvaluable;
import com.google.refine.browsing.util.TimeBinIndex;
import com.google.refine.expr.ExpressionUtils;
import com.google.refine.model.Project;
import com.google.refine.model.Record;
import com.google.refine.model.Row;
import java.time.OffsetDateTime;
import java.util.Collection;
import java.util.Properties;

public class ExpressionTimeValueBinner
implements RowVisitor,
RecordVisitor {
    protected final RowEvaluable _rowEvaluable;
    protected final TimeBinIndex _index;
    public final int[] bins;
    public int timeCount;
    public int nonTimeCount;
    public int blankCount;
    public int errorCount;
    protected boolean hasError;
    protected boolean hasBlank;
    protected boolean hasTime;
    protected boolean hasNonTime;

    public ExpressionTimeValueBinner(RowEvaluable rowEvaluable, TimeBinIndex index) {
        this._rowEvaluable = rowEvaluable;
        this._index = index;
        this.bins = new int[this._index.getBins().length];
    }

    @Override
    public void start(Project project) {
    }

    @Override
    public void end(Project project) {
    }

    @Override
    public boolean visit(Project project, int rowIndex, Row row) {
        this.resetFlags();
        Properties bindings = ExpressionUtils.createBindings(project);
        this.processRow(project, rowIndex, row, bindings);
        this.updateCounts();
        return false;
    }

    @Override
    public boolean visit(Project project, Record record) {
        this.resetFlags();
        Properties bindings = ExpressionUtils.createBindings(project);
        for (int r = record.fromRowIndex; r < record.toRowIndex; ++r) {
            this.processRow(project, r, project.rows.get(r), bindings);
        }
        this.updateCounts();
        return false;
    }

    protected void resetFlags() {
        this.hasError = false;
        this.hasBlank = false;
        this.hasTime = false;
        this.hasNonTime = false;
    }

    protected void updateCounts() {
        if (this.hasError) {
            ++this.errorCount;
        }
        if (this.hasBlank) {
            ++this.blankCount;
        }
        if (this.hasTime) {
            ++this.timeCount;
        }
        if (this.hasNonTime) {
            ++this.nonTimeCount;
        }
    }

    protected void processRow(Project project, int rowIndex, Row row, Properties bindings) {
        Object value = this._rowEvaluable.eval(project, rowIndex, row, bindings);
        if (value != null) {
            if (value.getClass().isArray()) {
                Object[] a;
                for (Object v : a = (Object[])value) {
                    this.processValue(v);
                }
                return;
            }
            if (value instanceof Collection) {
                for (Object v : ExpressionUtils.toObjectCollection(value)) {
                    this.processValue(v);
                }
                return;
            }
        }
        this.processValue(value);
    }

    protected void processValue(Object value) {
        if (ExpressionUtils.isError(value)) {
            this.hasError = true;
        } else if (ExpressionUtils.isNonBlankData(value)) {
            if (value instanceof OffsetDateTime) {
                long t = ((OffsetDateTime)value).toInstant().toEpochMilli();
                this.hasTime = true;
                int bin = (int)Math.floor((double)(t - this._index.getMin()) / (double)this._index.getStep());
                if (bin >= 0 && bin < this.bins.length) {
                    int n = bin;
                    this.bins[n] = this.bins[n] + 1;
                }
            } else {
                this.hasNonTime = true;
            }
        } else {
            this.hasBlank = true;
        }
    }
}

