/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.browsing.util;

import com.google.refine.browsing.FilteredRows;
import com.google.refine.browsing.RowFilter;
import com.google.refine.browsing.RowVisitor;
import com.google.refine.model.Project;
import com.google.refine.model.Row;
import java.util.LinkedList;
import java.util.List;

public class ConjunctiveFilteredRows
implements FilteredRows {
    protected final List<RowFilter> _rowFilters = new LinkedList<RowFilter>();

    public void add(RowFilter rowFilter) {
        this._rowFilters.add(rowFilter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void accept(Project project, RowVisitor visitor) {
        try {
            visitor.start(project);
            int c = project.rows.size();
            for (int rowIndex = 0; rowIndex < c; ++rowIndex) {
                Row row = project.rows.get(rowIndex);
                if (!this.matchRow(project, rowIndex, row) || !this.visitRow(project, visitor, rowIndex, row)) continue;
                break;
            }
        }
        finally {
            visitor.end(project);
        }
    }

    protected boolean visitRow(Project project, RowVisitor visitor, int rowIndex, Row row) {
        return visitor.visit(project, rowIndex, rowIndex, row);
    }

    protected boolean matchRow(Project project, int rowIndex, Row row) {
        for (RowFilter rowFilter : this._rowFilters) {
            if (rowFilter.filterRow(project, rowIndex, row)) continue;
            return false;
        }
        return true;
    }
}

