/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.browsing.filters;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.google.refine.browsing.RowFilter;
import com.google.refine.expr.Evaluable;
import com.google.refine.expr.ExpressionUtils;
import com.google.refine.expr.util.JsonValueConverter;
import com.google.refine.model.Cell;
import com.google.refine.model.Project;
import com.google.refine.model.Row;
import java.util.Collection;
import java.util.Properties;

public abstract class ExpressionStringComparisonRowFilter
implements RowFilter {
    protected final Evaluable _evaluable;
    protected final Boolean _invert;
    protected final String _columnName;
    protected final int _cellIndex;

    public ExpressionStringComparisonRowFilter(Evaluable evaluable, Boolean invert, String columnName, int cellIndex) {
        this._evaluable = evaluable;
        this._invert = invert;
        this._columnName = columnName;
        this._cellIndex = cellIndex;
    }

    @Override
    public boolean filterRow(Project project, int rowIndex, Row row) {
        Cell cell = this._cellIndex < 0 ? null : row.getCell(this._cellIndex);
        Properties bindings = ExpressionUtils.createBindings(project);
        ExpressionUtils.bind(bindings, row, rowIndex, this._columnName, cell);
        Boolean invert = this._invert;
        Object value = this._evaluable.evaluate(bindings);
        if (value != null) {
            if (value.getClass().isArray()) {
                Object[] a;
                for (Object v : a = (Object[])value) {
                    if (!this.checkValue(v instanceof String ? (String)v : v.toString())) continue;
                    return invert == false;
                }
            } else {
                if (value instanceof Collection) {
                    for (Object v : ExpressionUtils.toObjectCollection(value)) {
                        if (!this.checkValue(v.toString())) continue;
                        return invert == false;
                    }
                    return invert;
                }
                if (value instanceof ArrayNode) {
                    ArrayNode a = (ArrayNode)value;
                    int l = a.size();
                    for (int i = 0; i < l; ++i) {
                        if (!this.checkValue(JsonValueConverter.convert(a.get(i)).toString())) continue;
                        return invert == false;
                    }
                    return invert;
                }
                if (this.checkValue(value instanceof String ? (String)value : value.toString())) {
                    return invert == false;
                }
            }
        }
        return invert;
    }

    protected abstract boolean checkValue(String var1);
}

