/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.browsing.filters;

import com.google.refine.browsing.RowFilter;
import com.google.refine.expr.Evaluable;
import com.google.refine.expr.ExpressionUtils;
import com.google.refine.model.Cell;
import com.google.refine.model.Project;
import com.google.refine.model.Row;
import java.util.Collection;
import java.util.Properties;

public abstract class DualExpressionsNumberComparisonRowFilter
implements RowFilter {
    protected final Evaluable _x_evaluable;
    protected final String _x_columnName;
    protected final int _x_cellIndex;
    protected final Evaluable _y_evaluable;
    protected final String _y_columnName;
    protected final int _y_cellIndex;

    public DualExpressionsNumberComparisonRowFilter(Evaluable x_evaluable, String x_columnName, int x_cellIndex, Evaluable y_evaluable, String y_columnName, int y_cellIndex) {
        this._x_evaluable = x_evaluable;
        this._x_columnName = x_columnName;
        this._x_cellIndex = x_cellIndex;
        this._y_evaluable = y_evaluable;
        this._y_columnName = y_columnName;
        this._y_cellIndex = y_cellIndex;
    }

    @Override
    public boolean filterRow(Project project, int rowIndex, Row row) {
        Cell x_cell = this._x_cellIndex < 0 ? null : row.getCell(this._x_cellIndex);
        Properties x_bindings = ExpressionUtils.createBindings(project);
        ExpressionUtils.bind(x_bindings, row, rowIndex, this._x_columnName, x_cell);
        Object x_value = this._x_evaluable.evaluate(x_bindings);
        Cell y_cell = this._y_cellIndex < 0 ? null : row.getCell(this._y_cellIndex);
        Properties y_bindings = ExpressionUtils.createBindings(project);
        ExpressionUtils.bind(y_bindings, row, rowIndex, this._y_columnName, y_cell);
        Object y_value = this._y_evaluable.evaluate(y_bindings);
        if (x_value != null && y_value != null) {
            if (x_value.getClass().isArray() || y_value.getClass().isArray()) {
                return false;
            }
            if (x_value instanceof Collection || y_value instanceof Collection) {
                return false;
            }
        }
        return this.checkValue(x_value, y_value);
    }

    protected boolean checkValue(Object vx, Object vy) {
        if (ExpressionUtils.isError(vx) || ExpressionUtils.isError(vy)) {
            return false;
        }
        if (ExpressionUtils.isNonBlankData(vx) && ExpressionUtils.isNonBlankData(vy)) {
            if (vx instanceof Number && vy instanceof Number) {
                double dx = ((Number)vx).doubleValue();
                double dy = ((Number)vy).doubleValue();
                return !Double.isInfinite(dx) && !Double.isNaN(dx) && !Double.isInfinite(dy) && !Double.isNaN(dy) && this.checkValues(dx, dy);
            }
            return false;
        }
        return false;
    }

    protected abstract boolean checkValues(double var1, double var3);
}

