/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.browsing.facets;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.refine.browsing.FilteredRecords;
import com.google.refine.browsing.FilteredRows;
import com.google.refine.browsing.RecordFilter;
import com.google.refine.browsing.RowFilter;
import com.google.refine.browsing.facets.Facet;
import com.google.refine.browsing.facets.FacetConfig;
import com.google.refine.browsing.filters.AnyRowRecordFilter;
import com.google.refine.browsing.filters.ExpressionTimeComparisonRowFilter;
import com.google.refine.browsing.util.ExpressionBasedRowEvaluable;
import com.google.refine.browsing.util.ExpressionTimeValueBinner;
import com.google.refine.browsing.util.RowEvaluable;
import com.google.refine.browsing.util.TimeBinIndex;
import com.google.refine.browsing.util.TimeBinRecordIndex;
import com.google.refine.browsing.util.TimeBinRowIndex;
import com.google.refine.expr.Evaluable;
import com.google.refine.expr.MetaParser;
import com.google.refine.expr.ParsingException;
import com.google.refine.model.Column;
import com.google.refine.model.Project;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;

public class TimeRangeFacet
implements Facet {
    protected TimeRangeFacetConfig _config;
    protected int _cellIndex;
    protected Evaluable _eval;
    protected String _errorMessage;
    protected double _min;
    protected double _max;
    protected double _step;
    protected int[] _baseBins;
    protected int[] _bins;
    @JsonProperty(value="baseTimeCount")
    protected int _baseTimeCount;
    @JsonProperty(value="baseNonTimeCount")
    protected int _baseNonTimeCount;
    @JsonProperty(value="baseBlankCount")
    protected int _baseBlankCount;
    @JsonProperty(value="baseErrorCount")
    protected int _baseErrorCount;
    @JsonProperty(value="timeCount")
    protected int _timeCount;
    @JsonProperty(value="nonTimeCount")
    protected int _nonTimeCount;
    @JsonProperty(value="blankCount")
    protected int _blankCount;
    @JsonProperty(value="errorCount")
    protected int _errorCount;
    protected static final String MIN = "min";
    protected static final String MAX = "max";
    protected static final String TO = "to";
    protected static final String FROM = "from";

    @JsonProperty(value="name")
    public String getName() {
        return this._config._name;
    }

    @JsonProperty(value="expression")
    public String getExpression() {
        return this._config._expression;
    }

    @JsonProperty(value="columnName")
    public String getColumnName() {
        return this._config._columnName;
    }

    @JsonProperty(value="error")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getError() {
        return this._errorMessage;
    }

    @JsonProperty(value="min")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Double getMin() {
        if (this.getError() == null) {
            return this._min;
        }
        return null;
    }

    @JsonProperty(value="max")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Double getMax() {
        if (this.getError() == null) {
            return this._max;
        }
        return null;
    }

    @JsonProperty(value="step")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Double getStep() {
        return this._step;
    }

    @JsonProperty(value="bins")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public int[] getBins() {
        if (this.getError() == null) {
            return this._bins;
        }
        return null;
    }

    @JsonProperty(value="baseBins")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public int[] getBaseBins() {
        if (this.getError() == null) {
            return this._baseBins;
        }
        return null;
    }

    @JsonProperty(value="from")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Double getFrom() {
        if (this.getError() == null) {
            return this._config._from;
        }
        return null;
    }

    @JsonProperty(value="to")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Double getTo() {
        if (this.getError() == null) {
            return this._config._to;
        }
        return null;
    }

    public void initializeFromConfig(TimeRangeFacetConfig config, Project project) {
        this._config = config;
        if (this._config._columnName.length() > 0) {
            Column column = project.columnModel.getColumnByName(this._config._columnName);
            if (column != null) {
                this._cellIndex = column.getCellIndex();
            } else {
                this._errorMessage = "No column named " + this._config._columnName;
            }
        } else {
            this._cellIndex = -1;
        }
        try {
            this._eval = MetaParser.parse(this._config._expression);
        }
        catch (ParsingException e) {
            this._errorMessage = e.getMessage();
        }
    }

    @Override
    public RowFilter getRowFilter(Project project) {
        if (this._eval != null && this._errorMessage == null && this._config.isSelected()) {
            return new ExpressionTimeComparisonRowFilter(this.getRowEvaluable(project), this._config._selectTime, this._config._selectNonTime, this._config._selectBlank, this._config._selectError){

                @Override
                protected boolean checkValue(long t) {
                    return (double)t >= TimeRangeFacet.this._config._from && (double)t <= TimeRangeFacet.this._config._to;
                }
            };
        }
        return null;
    }

    @Override
    public void computeChoices(Project project, FilteredRows filteredRows) {
        if (this._eval != null && this._errorMessage == null) {
            String key;
            RowEvaluable rowEvaluable = this.getRowEvaluable(project);
            Column column = project.columnModel.getColumnByCellIndex(this._cellIndex);
            TimeBinIndex index = (TimeBinIndex)column.getPrecompute(key = "time-bin:row-based:" + this._config._expression);
            if (index == null) {
                index = new TimeBinRowIndex(project, rowEvaluable);
                column.setPrecompute(key, index);
            }
            this.retrieveDataFromBaseBinIndex(index);
            ExpressionTimeValueBinner binner = new ExpressionTimeValueBinner(rowEvaluable, index);
            filteredRows.accept(project, binner);
            this.retrieveDataFromBinner(binner);
        }
    }

    @Override
    public void computeChoices(Project project, FilteredRecords filteredRecords) {
        if (this._eval != null && this._errorMessage == null) {
            String key;
            RowEvaluable rowEvaluable = this.getRowEvaluable(project);
            Column column = project.columnModel.getColumnByCellIndex(this._cellIndex);
            TimeBinIndex index = (TimeBinIndex)column.getPrecompute(key = "time-bin:record-based:" + this._config._expression);
            if (index == null) {
                index = new TimeBinRecordIndex(project, rowEvaluable);
                column.setPrecompute(key, index);
            }
            this.retrieveDataFromBaseBinIndex(index);
            ExpressionTimeValueBinner binner = new ExpressionTimeValueBinner(rowEvaluable, index);
            filteredRecords.accept(project, binner);
            this.retrieveDataFromBinner(binner);
        }
    }

    protected void retrieveDataFromBaseBinIndex(TimeBinIndex index) {
        this._min = index.getMin();
        this._max = index.getMax();
        this._step = index.getStep();
        this._baseBins = index.getBins();
        this._baseTimeCount = index.getTimeRowCount();
        this._baseNonTimeCount = index.getNonTimeRowCount();
        this._baseBlankCount = index.getBlankRowCount();
        this._baseErrorCount = index.getErrorRowCount();
        if (this._config.isSelected()) {
            this._config._from = Math.max(this._config._from, this._min);
            this._config._to = Math.min(this._config._to, this._max);
        } else {
            this._config._from = this._min;
            this._config._to = this._max;
        }
    }

    protected void retrieveDataFromBinner(ExpressionTimeValueBinner binner) {
        this._bins = binner.bins;
        this._timeCount = binner.timeCount;
        this._nonTimeCount = binner.nonTimeCount;
        this._blankCount = binner.blankCount;
        this._errorCount = binner.errorCount;
    }

    @Override
    public RecordFilter getRecordFilter(Project project) {
        RowFilter rowFilter = this.getRowFilter(project);
        return rowFilter == null ? null : new AnyRowRecordFilter(rowFilter);
    }

    protected RowEvaluable getRowEvaluable(Project project) {
        return new ExpressionBasedRowEvaluable(this._config._columnName, this._cellIndex, this._eval);
    }

    public static class TimeRangeFacetConfig
    implements FacetConfig {
        @JsonProperty(value="name")
        protected String _name;
        @JsonProperty(value="expression")
        protected String _expression;
        @JsonProperty(value="columnName")
        protected String _columnName;
        @JsonProperty(value="from")
        protected double _from = 0.0;
        @JsonProperty(value="to")
        protected double _to = 0.0;
        @JsonProperty(value="selectTime")
        protected boolean _selectTime;
        @JsonProperty(value="selectNonTime")
        protected boolean _selectNonTime;
        @JsonProperty(value="selectBlank")
        protected boolean _selectBlank;
        @JsonProperty(value="selectError")
        protected boolean _selectError;

        @JsonIgnore
        protected boolean isSelected() {
            return this._from != 0.0 || this._to != 0.0 || !this._selectTime || !this._selectNonTime || !this._selectBlank || !this._selectError;
        }

        @Override
        public TimeRangeFacet apply(Project project) {
            TimeRangeFacet facet = new TimeRangeFacet();
            facet.initializeFromConfig(this, project);
            return facet;
        }

        @Override
        public String getJsonType() {
            return "timerange";
        }

        @Override
        public void validate() {
            try {
                MetaParser.parse(this._expression);
            }
            catch (ParsingException e) {
                throw new IllegalArgumentException(e);
            }
        }

        @Override
        public Optional<Set<String>> getColumnDependencies() {
            try {
                return MetaParser.parse(this._expression).getColumnDependencies(Optional.of(this._columnName));
            }
            catch (ParsingException e) {
                return Optional.of(Collections.emptySet());
            }
        }
    }
}

