/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.browsing.facets;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.refine.browsing.FilteredRecords;
import com.google.refine.browsing.FilteredRows;
import com.google.refine.browsing.RecordFilter;
import com.google.refine.browsing.RowFilter;
import com.google.refine.browsing.facets.Facet;
import com.google.refine.browsing.facets.FacetConfig;
import com.google.refine.browsing.filters.AnyRowRecordFilter;
import com.google.refine.browsing.filters.DualExpressionsNumberComparisonRowFilter;
import com.google.refine.browsing.util.ExpressionBasedRowEvaluable;
import com.google.refine.browsing.util.NumericBinIndex;
import com.google.refine.browsing.util.NumericBinRecordIndex;
import com.google.refine.browsing.util.NumericBinRowIndex;
import com.google.refine.expr.Evaluable;
import com.google.refine.expr.MetaParser;
import com.google.refine.expr.ParsingException;
import com.google.refine.model.Column;
import com.google.refine.model.Project;
import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import javax.imageio.ImageIO;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScatterplotFacet
implements Facet {
    public static final int LIN = 0;
    public static final int LOG = 1;
    public static final int NO_ROTATION = 0;
    public static final int ROTATE_CW = 1;
    public static final int ROTATE_CCW = 2;
    ScatterplotFacetConfig config;
    protected int columnIndex_x;
    protected int columnIndex_y;
    protected Evaluable eval_x;
    protected Evaluable eval_y;
    protected String errorMessage_x;
    protected String errorMessage_y;
    protected double min_x;
    protected double max_x;
    protected double min_y;
    protected double max_y;
    protected AffineTransform t;
    protected String image;
    public static final String NAME = "name";
    public static final String IMAGE = "image";
    public static final String COLOR = "color";
    public static final String BASE_COLOR = "base_color";
    public static final String SIZE = "l";
    public static final String ROTATION = "r";
    public static final String DOT = "dot";
    public static final String DIM_X = "dim_x";
    public static final String DIM_Y = "dim_y";
    public static final String X_COLUMN_NAME = "cx";
    public static final String X_EXPRESSION = "ex";
    public static final String MIN_X = "min_x";
    public static final String MAX_X = "max_x";
    public static final String TO_X = "to_x";
    public static final String FROM_X = "from_x";
    public static final String ERROR_X = "error_x";
    public static final String Y_COLUMN_NAME = "cy";
    public static final String Y_EXPRESSION = "ey";
    public static final String MIN_Y = "min_y";
    public static final String MAX_Y = "max_y";
    public static final String TO_Y = "to_y";
    public static final String FROM_Y = "from_y";
    public static final String ERROR_Y = "error_y";
    private static final boolean IMAGE_URI = false;
    public static String EMPTY_IMAGE;
    static final Logger logger;
    private static double s_rotateScale;

    @JsonProperty(value="name")
    public String getName() {
        return this.config.name;
    }

    @JsonProperty(value="cx")
    public String getXColumnName() {
        return this.config.columnName_x;
    }

    @JsonProperty(value="ex")
    public String getXExpression() {
        return this.config.expression_x;
    }

    @JsonProperty(value="cy")
    public String getYColumnName() {
        return this.config.columnName_y;
    }

    @JsonProperty(value="ey")
    public String getYExpression() {
        return this.config.expression_y;
    }

    @JsonProperty(value="l")
    public int getSize() {
        return this.config.size;
    }

    @JsonProperty(value="dim_x")
    public int getDimX() {
        return this.config.dim_x;
    }

    @JsonProperty(value="dim_y")
    public int getDimY() {
        return this.config.dim_y;
    }

    @JsonProperty(value="dot")
    public double getDot() {
        return this.config.dot;
    }

    @JsonProperty(value="r")
    public double getRotation() {
        return this.config.rotation;
    }

    @JsonProperty(value="color")
    public String getColorString() {
        return this.config.color_str;
    }

    @JsonProperty(value="image")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getImage() {
        return null;
    }

    @JsonProperty(value="error_x")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getErrorX() {
        return this.errorMessage_x;
    }

    @JsonProperty(value="from_x")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Double getFromX() {
        if (this.errorMessage_x == null && !Double.isInfinite(this.min_x) && !Double.isInfinite(this.max_x)) {
            return this.config.from_x;
        }
        return null;
    }

    @JsonProperty(value="to_x")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Double getToX() {
        if (this.errorMessage_x == null && !Double.isInfinite(this.min_x) && !Double.isInfinite(this.max_x)) {
            return this.config.to_x;
        }
        return null;
    }

    @JsonProperty(value="error_y")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getErrorY() {
        return this.errorMessage_y;
    }

    @JsonProperty(value="from_y")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Double getFromY() {
        if (this.errorMessage_y == null && !Double.isInfinite(this.min_y) && !Double.isInfinite(this.max_y)) {
            return this.config.from_y;
        }
        return null;
    }

    @JsonProperty(value="to_y")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Double getToY() {
        if (this.errorMessage_y == null && !Double.isInfinite(this.min_y) && !Double.isInfinite(this.max_y)) {
            return this.config.to_y;
        }
        return null;
    }

    public void initializeFromConfig(ScatterplotFacetConfig configuration, Project project) {
        this.config = configuration;
        this.t = ScatterplotFacet.createRotationMatrix(this.config.rotation, this.config.l);
        if (this.config.columnName_x.length() > 0) {
            Column x_column = project.columnModel.getColumnByName(this.config.columnName_x);
            if (x_column != null) {
                this.columnIndex_x = x_column.getCellIndex();
                NumericBinIndex index_x = ScatterplotFacet.getBinIndex(project, x_column, this.eval_x, this.config.expression_x);
                this.min_x = index_x.getMin();
                this.max_x = index_x.getMax();
            } else {
                this.errorMessage_x = "No column named " + this.config.columnName_x;
            }
        } else {
            this.columnIndex_x = -1;
        }
        try {
            this.eval_x = MetaParser.parse(this.config.expression_x);
        }
        catch (ParsingException e) {
            this.errorMessage_x = e.getMessage();
        }
        if (this.config.columnName_y.length() > 0) {
            Column y_column = project.columnModel.getColumnByName(this.config.columnName_y);
            if (y_column != null) {
                this.columnIndex_y = y_column.getCellIndex();
                NumericBinIndex index_y = ScatterplotFacet.getBinIndex(project, y_column, this.eval_y, this.config.expression_y);
                this.min_y = index_y.getMin();
                this.max_y = index_y.getMax();
            } else {
                this.errorMessage_y = "No column named " + this.config.columnName_y;
            }
        } else {
            this.columnIndex_y = -1;
        }
        try {
            this.eval_y = MetaParser.parse(this.config.expression_y);
        }
        catch (ParsingException e) {
            this.errorMessage_y = e.getMessage();
        }
    }

    @Override
    public RowFilter getRowFilter(Project project) {
        if (this.config.isSelected() && this.eval_x != null && this.errorMessage_x == null && this.eval_y != null && this.errorMessage_y == null) {
            return new DualExpressionsNumberComparisonRowFilter(this.eval_x, this.config.columnName_x, this.columnIndex_x, this.eval_y, this.config.columnName_y, this.columnIndex_y){
                double from_x_pixels;
                double to_x_pixels;
                double from_y_pixels;
                double to_y_pixels;
                {
                    this.from_x_pixels = ScatterplotFacet.this.config.from_x * ScatterplotFacet.this.config.l;
                    this.to_x_pixels = ScatterplotFacet.this.config.to_x * ScatterplotFacet.this.config.l;
                    this.from_y_pixels = ScatterplotFacet.this.config.from_y * ScatterplotFacet.this.config.l;
                    this.to_y_pixels = ScatterplotFacet.this.config.to_y * ScatterplotFacet.this.config.l;
                }

                @Override
                protected boolean checkValues(double x, double y) {
                    Point2D.Double p = new Point2D.Double(x, y);
                    p = ScatterplotFacet.translateCoordinates(p, ScatterplotFacet.this.min_x, ScatterplotFacet.this.max_x, ScatterplotFacet.this.min_y, ScatterplotFacet.this.max_y, ScatterplotFacet.this.config.dim_x, ScatterplotFacet.this.config.dim_y, ScatterplotFacet.this.config.l, ScatterplotFacet.this.t);
                    return p.x >= this.from_x_pixels && p.x <= this.to_x_pixels && p.y >= this.from_y_pixels && p.y <= this.to_y_pixels;
                }
            };
        }
        return null;
    }

    @Override
    public RecordFilter getRecordFilter(Project project) {
        RowFilter rowFilter = this.getRowFilter(project);
        return rowFilter == null ? null : new AnyRowRecordFilter(rowFilter);
    }

    @Override
    public void computeChoices(Project project, FilteredRows filteredRows) {
        if (this.eval_x != null && this.eval_y != null && this.errorMessage_x == null && this.errorMessage_y == null) {
            Column column_x = project.columnModel.getColumnByCellIndex(this.columnIndex_x);
            NumericBinIndex index_x = ScatterplotFacet.getBinIndex(project, column_x, this.eval_x, this.config.expression_x, "row-based");
            Column column_y = project.columnModel.getColumnByCellIndex(this.columnIndex_y);
            NumericBinIndex index_y = ScatterplotFacet.getBinIndex(project, column_y, this.eval_y, this.config.expression_y, "row-based");
            this.retrieveDataFromBinIndices(index_x, index_y);
        }
    }

    @Override
    public void computeChoices(Project project, FilteredRecords filteredRecords) {
        if (this.eval_x != null && this.eval_y != null && this.errorMessage_x == null && this.errorMessage_y == null) {
            Column column_x = project.columnModel.getColumnByCellIndex(this.columnIndex_x);
            NumericBinIndex index_x = ScatterplotFacet.getBinIndex(project, column_x, this.eval_x, this.config.expression_x, "record-based");
            Column column_y = project.columnModel.getColumnByCellIndex(this.columnIndex_y);
            NumericBinIndex index_y = ScatterplotFacet.getBinIndex(project, column_y, this.eval_y, this.config.expression_y, "record-based");
            this.retrieveDataFromBinIndices(index_x, index_y);
        }
    }

    protected void retrieveDataFromBinIndices(NumericBinIndex index_x, NumericBinIndex index_y) {
        this.min_x = index_x.getMin();
        this.max_x = index_x.getMax();
        this.min_y = index_y.getMin();
        this.max_y = index_y.getMax();
    }

    public static String serializeImage(RenderedImage image) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream(4096);
        ImageIO.write(image, "png", output);
        output.close();
        String encoded = Base64.encodeBase64String((byte[])output.toByteArray());
        String url = "data:image/png;base64," + encoded;
        return url;
    }

    public static int getAxisDim(String type) {
        return "log".equals(type.toLowerCase()) ? 1 : 0;
    }

    public static NumericBinIndex getBinIndex(Project project, Column column, Evaluable eval, String expression) {
        return ScatterplotFacet.getBinIndex(project, column, eval, expression, "row-based");
    }

    public static NumericBinIndex getBinIndex(Project project, Column column, Evaluable eval, String expression, String mode) {
        NumericBinIndex index;
        String key = "numeric-bin:" + mode + ":" + expression;
        if (eval == null) {
            try {
                eval = MetaParser.parse(expression);
            }
            catch (ParsingException e) {
                logger.warn("Error parsing expression", (Throwable)e);
            }
        }
        if ((index = (NumericBinIndex)column.getPrecompute(key)) == null) {
            index = "row-based".equals(mode) ? new NumericBinRowIndex(project, new ExpressionBasedRowEvaluable(column.getName(), column.getCellIndex(), eval)) : new NumericBinRecordIndex(project, new ExpressionBasedRowEvaluable(column.getName(), column.getCellIndex(), eval));
            column.setPrecompute(key, index);
        }
        return index;
    }

    public static AffineTransform createRotationMatrix(int rotation, double l) {
        if (rotation == 1) {
            AffineTransform t = AffineTransform.getTranslateInstance(0.0, l / 2.0);
            t.scale(s_rotateScale, s_rotateScale);
            t.rotate(-0.7853981633974483);
            return t;
        }
        if (rotation == 2) {
            AffineTransform t = AffineTransform.getTranslateInstance(l / 2.0, 0.0);
            t.scale(s_rotateScale, s_rotateScale);
            t.rotate(0.7853981633974483);
            return t;
        }
        return null;
    }

    public static Point2D.Double translateCoordinates(Point2D.Double p, double min_x, double max_x, double min_y, double max_y, int dim_x, int dim_y, double l, AffineTransform t) {
        double x = p.x;
        double y = p.y;
        double relative_x = x - min_x;
        double range_x = max_x - min_x;
        x = dim_x == 1 ? Math.log10(relative_x + 1.0) * l / Math.log10(range_x + 1.0) : relative_x * l / range_x;
        double relative_y = y - min_y;
        double range_y = max_y - min_y;
        y = dim_y == 1 ? Math.log10(relative_y + 1.0) * l / Math.log10(range_y + 1.0) : relative_y * l / range_y;
        p.x = x;
        p.y = y;
        if (t != null) {
            t.transform(p, p);
        }
        return p;
    }

    static {
        logger = LoggerFactory.getLogger((String)"scatterplot_facet");
        try {
            EMPTY_IMAGE = ScatterplotFacet.serializeImage(new BufferedImage(1, 1, 6));
        }
        catch (IOException e) {
            EMPTY_IMAGE = "";
        }
        s_rotateScale = 1.0 / Math.sqrt(2.0);
    }

    public static class ScatterplotFacetConfig
    implements FacetConfig {
        @JsonProperty(value="name")
        protected String name;
        @JsonProperty(value="ex")
        protected String expression_x;
        @JsonProperty(value="ey")
        protected String expression_y;
        @JsonProperty(value="cx")
        protected String columnName_x;
        @JsonProperty(value="cy")
        protected String columnName_y;
        @JsonProperty(value="l")
        protected int size;
        @JsonIgnore
        protected int dim_x;
        @JsonIgnore
        protected int dim_y;
        @JsonIgnore
        protected String rotation_str;
        @JsonIgnore
        protected int rotation;
        @JsonIgnore
        protected double l = 1.0;
        @JsonProperty(value="dot")
        protected double dot;
        @JsonIgnore
        protected String color_str = "000000";
        @JsonProperty(value="from_x")
        protected double from_x;
        @JsonProperty(value="to_x")
        protected double to_x;
        @JsonProperty(value="from_y")
        protected double from_y;
        @JsonProperty(value="to_y")
        protected double to_y;

        @JsonIgnore
        protected Color getColor() {
            return new Color(Integer.parseInt(this.color_str, 16));
        }

        protected boolean isSelected() {
            return this.from_x > 0.0 || this.to_x < 1.0 || this.from_y > 0.0 || this.to_y < 1.0;
        }

        @JsonProperty(value="dim_x")
        public String getDimX() {
            return this.dim_x == 0 ? "lin" : "log";
        }

        @JsonProperty(value="dim_y")
        public String getDimY() {
            return this.dim_y == 0 ? "lin" : "log";
        }

        @Override
        public ScatterplotFacet apply(Project project) {
            ScatterplotFacet facet = new ScatterplotFacet();
            facet.initializeFromConfig(this, project);
            return facet;
        }

        public static int getRotation(String rotation) {
            if ("cw".equals(rotation = rotation.toLowerCase()) || "right".equals(rotation)) {
                return 1;
            }
            if ("ccw".equals(rotation) || "left".equals(rotation)) {
                return 2;
            }
            return 0;
        }

        @Override
        public String getJsonType() {
            return "scatterplot";
        }

        @Override
        public void validate() {
            try {
                MetaParser.parse(this.expression_x);
            }
            catch (ParsingException e) {
                throw new IllegalArgumentException(e);
            }
            try {
                MetaParser.parse(this.expression_y);
            }
            catch (ParsingException e) {
                throw new IllegalArgumentException(e);
            }
        }

        @Override
        public Optional<Set<String>> getColumnDependencies() {
            try {
                Optional<Set<String>> depsX = MetaParser.parse(this.expression_x).getColumnDependencies(Optional.of(this.columnName_x));
                Optional<Set<String>> depsY = MetaParser.parse(this.expression_y).getColumnDependencies(Optional.of(this.columnName_y));
                if (depsX.isPresent() && depsY.isPresent()) {
                    HashSet union = new HashSet(depsX.get());
                    union.addAll(depsY.get());
                    return Optional.of(union);
                }
                return Optional.empty();
            }
            catch (ParsingException e) {
                return Optional.of(Collections.emptySet());
            }
        }
    }
}

