/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.browsing.facets;

import com.google.refine.browsing.RecordVisitor;
import com.google.refine.browsing.RowVisitor;
import com.google.refine.browsing.facets.ScatterplotFacet;
import com.google.refine.model.Cell;
import com.google.refine.model.Project;
import com.google.refine.model.Record;
import com.google.refine.model.Row;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;

public class ScatterplotDrawingRowVisitor
implements RowVisitor,
RecordVisitor {
    int col_x;
    int col_y;
    int dim_x;
    int dim_y;
    double l;
    double dot;
    double min_x;
    double max_x;
    double min_y;
    double max_y;
    BufferedImage image;
    Graphics2D g2;
    AffineTransform r;

    public ScatterplotDrawingRowVisitor(int col_x, int col_y, double min_x, double max_x, double min_y, double max_y, int size, int dim_x, int dim_y, int rotation, double dot, Color color) {
        this.col_x = col_x;
        this.col_y = col_y;
        this.min_x = min_x;
        this.min_y = min_y;
        this.max_x = max_x;
        this.max_y = max_y;
        this.dot = dot;
        this.dim_x = dim_x;
        this.dim_y = dim_y;
        this.l = size;
        this.r = ScatterplotFacet.createRotationMatrix(rotation, this.l);
        this.image = new BufferedImage(size, size, 6);
        this.g2 = (Graphics2D)this.image.getGraphics();
        this.g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.g2.setStroke(new BasicStroke(1.0f));
        AffineTransform t = AffineTransform.getTranslateInstance(0.0, this.l);
        t.scale(1.0, -1.0);
        this.g2.setTransform(t);
        this.g2.setColor(color);
        this.g2.setPaint(color);
        if (this.r != null) {
            Graphics2D g2r = (Graphics2D)this.g2.create();
            g2r.transform(this.r);
            g2r.setPaint(Color.lightGray);
            g2r.fillRect(-size, 0, size, size);
            g2r.fillRect(0, -size, size, size);
            g2r.dispose();
        }
    }

    public void setColor(Color color) {
        this.g2.setColor(color);
        this.g2.setPaint(color);
    }

    @Override
    public void start(Project project) {
    }

    @Override
    public void end(Project project) {
    }

    @Override
    public boolean visit(Project project, int rowIndex, Row row) {
        Cell cellx = row.getCell(this.col_x);
        Cell celly = row.getCell(this.col_y);
        if (cellx != null && cellx.value != null && cellx.value instanceof Number && celly != null && celly.value != null && celly.value instanceof Number) {
            double xv = ((Number)cellx.value).doubleValue();
            double yv = ((Number)celly.value).doubleValue();
            Point2D.Double p = new Point2D.Double(xv, yv);
            p = ScatterplotFacet.translateCoordinates(p, this.min_x, this.max_x, this.min_y, this.max_y, this.dim_x, this.dim_y, this.l, this.r);
            this.g2.fill(new Rectangle2D.Double(p.x - this.dot / 2.0, p.y - this.dot / 2.0, this.dot, this.dot));
        }
        return false;
    }

    @Override
    public boolean visit(Project project, Record record) {
        for (int r = record.fromRowIndex; r < record.toRowIndex; ++r) {
            this.visit(project, r, r, project.rows.get(r));
        }
        return false;
    }

    public RenderedImage getImage() {
        return this.image;
    }
}

