/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.browsing;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.refine.browsing.Engine;
import com.google.refine.browsing.facets.FacetConfig;
import com.google.refine.util.ParsingUtilities;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class EngineConfig {
    protected final List<FacetConfig> _facets;
    protected final Engine.Mode _mode;
    private static final EngineConfig _default = new EngineConfig(List.of(), Engine.Mode.RowBased);

    @JsonCreator
    public EngineConfig(@JsonProperty(value="facets") List<FacetConfig> facets, @JsonProperty(value="mode") Engine.Mode mode) {
        this._facets = facets == null ? Collections.emptyList() : facets;
        this._mode = mode == null ? Engine.Mode.RowBased : mode;
    }

    public static EngineConfig defaultRowBased() {
        return _default;
    }

    @JsonProperty(value="mode")
    public Engine.Mode getMode() {
        return this._mode;
    }

    @JsonProperty(value="facets")
    public List<FacetConfig> getFacetConfigs() {
        return this._facets;
    }

    public void validate() {
        this._facets.stream().forEach(facetConfig -> facetConfig.validate());
    }

    @JsonIgnore
    public Optional<Set<String>> getColumnDependencies() {
        HashSet result = new HashSet();
        for (FacetConfig config : this._facets) {
            Optional<Set<String>> dependencies = config.getColumnDependencies();
            if (dependencies.isEmpty()) {
                return Optional.empty();
            }
            result.addAll(dependencies.get());
        }
        return Optional.of(result);
    }

    @Deprecated(since="3.9")
    public static EngineConfig reconstruct(String json) {
        if (json == null) {
            return new EngineConfig(Collections.emptyList(), Engine.Mode.RowBased);
        }
        try {
            return (EngineConfig)ParsingUtilities.mapper.readValue(json, EngineConfig.class);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static EngineConfig deserialize(String json) {
        try {
            return (EngineConfig)ParsingUtilities.mapper.readValue(json, EngineConfig.class);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

