/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonView;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.json.JsonReadFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.CharMatcher;
import com.google.refine.ProjectManager;
import com.google.refine.preference.PreferenceStore;
import com.google.refine.util.JsonViews;
import com.google.refine.util.ParsingUtilities;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectMetadata {
    public static final String DEFAULT_FILE_NAME = "metadata.json";
    public static final String TEMP_FILE_NAME = "metadata.temp.json";
    public static final String OLD_FILE_NAME = "metadata.old.json";
    @JsonProperty(value="created")
    private final Instant _created;
    @JsonProperty(value="modified")
    private Instant _modified;
    @JsonIgnore
    private Instant lastSave = null;
    @JsonProperty(value="name")
    private String _name = "";
    @JsonProperty(value="password")
    @JsonView(value={JsonViews.SaveMode.class})
    private String _password = "";
    @JsonProperty(value="encoding")
    @JsonView(value={JsonViews.SaveMode.class})
    private String _encoding = "";
    @JsonProperty(value="encodingConfidence")
    @JsonView(value={JsonViews.SaveMode.class})
    private int _encodingConfidence;
    @JsonProperty(value="tags")
    private String[] _tags = new String[0];
    @JsonProperty(value="creator")
    private String _creator = "";
    @JsonProperty(value="contributors")
    private String _contributors = "";
    @JsonProperty(value="subject")
    private String _subject = "";
    @JsonProperty(value="description")
    private String _description = "";
    @JsonProperty(value="rowCount")
    private int _rowCount;
    @JsonProperty(value="title")
    private String _title = "";
    @JsonProperty(value="version")
    private String _version = "";
    @JsonProperty(value="license")
    private String license = "";
    @JsonProperty(value="homepage")
    private String homepage = "";
    @JsonProperty(value="image")
    private String image = "";
    @JsonProperty(value="importOptionMetadata")
    private ArrayNode _importOptionMetadata = ParsingUtilities.mapper.createArrayNode();
    @JsonIgnore
    private ArrayNode _userMetadata = ParsingUtilities.mapper.createArrayNode();
    @JsonProperty(value="customMetadata")
    private Map<String, Object> _customMetadata = new HashMap<String, Object>();
    @JsonProperty(value="preferences")
    @JsonView(value={JsonViews.SaveMode.class})
    private PreferenceStore _preferenceStore = new PreferenceStore();
    private static final Logger logger = LoggerFactory.getLogger((String)"project_metadata");

    protected ProjectMetadata(Instant date) {
        this._modified = this._created = date;
        ProjectMetadata.preparePreferenceStore(this._preferenceStore);
    }

    public ProjectMetadata() {
        this(Instant.now());
    }

    public ProjectMetadata(Instant created, Instant modified, String name) {
        this(created);
        this._modified = modified;
        this._name = name;
    }

    @JsonIgnore
    public boolean isDirty() {
        return this.lastSave == null || this._modified.isAfter(this.lastSave);
    }

    protected static void preparePreferenceStore(PreferenceStore ps) {
        ProjectManager.preparePreferenceStore(ps);
    }

    @JsonIgnore
    public Instant getCreated() {
        return this._created;
    }

    @JsonIgnore
    public void setName(String name) {
        this._name = name;
        this.updateModified();
    }

    @JsonIgnore
    public String getName() {
        return this._name;
    }

    @JsonIgnore
    public void setEncoding(String encoding) {
        this._encoding = encoding;
        this.updateModified();
    }

    @JsonIgnore
    public String getEncoding() {
        return this._encoding;
    }

    @JsonIgnore
    public void setEncodingConfidence(int confidence) {
        this._encodingConfidence = confidence;
        this.updateModified();
    }

    @JsonIgnore
    public void setEncodingConfidence(String confidence) {
        if (confidence != null) {
            this.setEncodingConfidence(Integer.parseInt(confidence));
        }
    }

    @JsonIgnore
    public int getEncodingConfidence() {
        return this._encodingConfidence;
    }

    @JsonIgnore
    public void setTags(String[] tags) {
        if (tags != null) {
            ArrayList<String> tmpTags = new ArrayList<String>(tags.length);
            for (String tag : tags) {
                String trimmedTag;
                if (tag == null || (trimmedTag = CharMatcher.whitespace().trimFrom((CharSequence)tag)).isEmpty()) continue;
                tmpTags.add(trimmedTag);
            }
            this._tags = tmpTags.toArray(new String[tmpTags.size()]);
        } else {
            this._tags = tags;
        }
        this.updateModified();
    }

    @JsonIgnore
    public String[] getTags() {
        if (this._tags == null) {
            this._tags = new String[0];
        }
        return this._tags;
    }

    @JsonIgnore
    public void setPassword(String password) {
        this._password = password;
        this.updateModified();
    }

    @JsonIgnore
    public String getPassword() {
        return this._password;
    }

    @JsonIgnore
    public Instant getModified() {
        return this._modified;
    }

    @JsonIgnore
    public void updateModified() {
        this._modified = Instant.now();
    }

    @JsonIgnore
    public PreferenceStore getPreferenceStore() {
        return this._preferenceStore;
    }

    @JsonIgnore
    public Serializable getCustomMetadata(String key) {
        return (Serializable)this._customMetadata.get(key);
    }

    public void setCustomMetadata(String key, Serializable value) {
        if (value == null) {
            this._customMetadata.remove(key);
        } else {
            this._customMetadata.put(key, value);
        }
        this.updateModified();
    }

    @JsonIgnore
    public ArrayNode getImportOptionMetadata() {
        return this._importOptionMetadata;
    }

    @JsonIgnore
    public void setImportOptionMetadata(ArrayNode jsonArray) {
        this._importOptionMetadata = jsonArray;
        this.updateModified();
    }

    public void appendImportOptionMetadata(ObjectNode options) {
        this._importOptionMetadata.add((JsonNode)options);
        this.updateModified();
    }

    @JsonIgnore
    public String getCreator() {
        return this._creator;
    }

    @JsonIgnore
    public void setCreator(String creator) {
        this._creator = creator;
        this.updateModified();
    }

    @JsonIgnore
    public String getContributors() {
        return this._contributors;
    }

    @JsonIgnore
    public void setContributors(String contributors) {
        this._contributors = contributors;
        this.updateModified();
    }

    @JsonIgnore
    public String getSubject() {
        return this._subject;
    }

    @JsonIgnore
    public void setSubject(String subject) {
        this._subject = subject;
        this.updateModified();
    }

    @JsonIgnore
    public String getDescription() {
        return this._description;
    }

    @JsonIgnore
    public void setDescription(String description) {
        this._description = description;
        this.updateModified();
    }

    @JsonIgnore
    public int getRowCount() {
        return this._rowCount;
    }

    @JsonIgnore
    public void setRowCount(int rowCount) {
        this.setRowCountInternal(rowCount);
        this.updateModified();
    }

    @JsonIgnore
    public void setRowCountInternal(int rowCount) {
        this._rowCount = rowCount;
    }

    @JsonIgnore
    public ArrayNode getUserMetadata() {
        return this._userMetadata;
    }

    @JsonProperty(value="userMetadata")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public ArrayNode getUserMetadataJson() {
        if (this._userMetadata != null && this._userMetadata.size() > 0) {
            return this._userMetadata;
        }
        return null;
    }

    @JsonIgnore
    public void setUserMetadata(ArrayNode userMetadata) {
        this._userMetadata = userMetadata;
        this.updateModified();
    }

    private void updateUserMetadata(String metaName, String valueString) {
        for (int i = 0; i < this._userMetadata.size(); ++i) {
            ObjectNode obj = (ObjectNode)this._userMetadata.get(i);
            if (!obj.get("name").asText("").equals(metaName)) continue;
            obj.put("value", valueString);
        }
    }

    public void setAnyField(String metaName, String valueString) {
        Class<?> metaClass = this.getClass();
        try {
            Field metaField = metaClass.getDeclaredField("_" + metaName);
            if (metaName.equals("tags")) {
                metaField.set(this, valueString.split(","));
            } else if (metaName.equals("customMetadata")) {
                ParsingUtilities.mapper.enable(new JsonParser.Feature[]{JsonReadFeature.ALLOW_BACKSLASH_ESCAPING_ANY_CHARACTER.mappedFeature()});
                Map map = (Map)ParsingUtilities.mapper.readValue(valueString, HashMap.class);
                metaField.set(this, map);
            } else {
                metaField.set(this, valueString);
            }
        }
        catch (JsonProcessingException e) {
            String errorMessage = "Error reading JSON: " + e.getOriginalMessage();
            logger.error(errorMessage);
            throw new RuntimeException(errorMessage);
        }
        catch (NoSuchFieldException e) {
            this.updateUserMetadata(metaName, valueString);
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException e) {
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            throw new RuntimeException(e);
        }
    }

    @JsonIgnore
    public void setLastSave() {
        this.lastSave = Instant.now();
    }
}

