/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import org.apache.commons.logging.Log;
import org.mortbay.log.LogFactory;
import org.openqa.selenium.server.BrowserResponseSequencer;
import org.openqa.selenium.server.DefaultRemoteCommand;
import org.openqa.selenium.server.FrameAddress;
import org.openqa.selenium.server.InjectionHelper;
import org.openqa.selenium.server.RemoteCommand;
import org.openqa.selenium.server.SeleniumCommandTimedOutException;
import org.openqa.selenium.server.SeleniumServer;
import org.openqa.selenium.server.SingleEntryAsyncQueue;
import org.openqa.selenium.server.SingleEntryAsyncQueueOverflow;
import org.openqa.selenium.server.WindowClosedException;

public class CommandQueue {
    static Log log = LogFactory.getLog(CommandQueue.class);
    private SingleEntryAsyncQueue commandHolder;
    private SingleEntryAsyncQueue commandResultHolder;
    private String sessionId;
    private String uniqueId;
    private FrameAddress frameAddress;
    private boolean resultExpected = false;
    private boolean closed = false;
    private final Lock dataLock;
    private Condition resultArrived;
    private Condition commandReady;
    private ConcurrentHashMap<String, Boolean> cachedJsVariableNamesPointingAtThisWindow = new ConcurrentHashMap();
    private final BrowserResponseSequencer browserResponseSequencer;
    private static int millisecondDelayBetweenOperations;

    public CommandQueue(String sessionId, String uniqueId, Lock dataLock) {
        this.sessionId = sessionId;
        this.uniqueId = uniqueId;
        this.dataLock = dataLock;
        this.browserResponseSequencer = new BrowserResponseSequencer(uniqueId);
        this.resultArrived = dataLock.newCondition();
        this.commandReady = dataLock.newCondition();
        this.commandHolder = new SingleEntryAsyncQueue("commandHolder/" + uniqueId, dataLock, this.commandReady);
        this.commandHolder.setRetry(true);
        this.commandResultHolder = new SingleEntryAsyncQueue("resultHolder/" + uniqueId, dataLock, this.resultArrived);
        this.commandHolder.setTimeout(Integer.MAX_VALUE);
        millisecondDelayBetweenOperations = System.getProperty("selenium.slowMode") == null ? 0 : Integer.parseInt(System.getProperty("selenium.slowMode"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String doCommand(String command, String field, String value) {
        this.dataLock.lock();
        try {
            if (this.closed) {
                String string = "Current window or frame is closed!";
                return string;
            }
            this.resultExpected = true;
            Object object = this.commandResultHolder;
            synchronized (object) {
                this.commandResultHolder.clear();
            }
            try {
                this.doCommandWithoutWaitingForAResponse(command, field, value);
            }
            catch (WindowClosedException e) {
                String string = this.queueGetResult("doCommand+WindowClosedException");
                this.resultExpected = false;
                this.dataLock.unlock();
                return string;
            }
            object = this.queueGetResult("doCommand");
            return object;
        }
        finally {
            this.resultExpected = false;
            this.dataLock.unlock();
        }
    }

    private String queueGetResult(String comment) {
        try {
            String result = (String)this.queueGet(comment, this.commandResultHolder, this.resultArrived);
            if (result == null) {
                result = "ERROR: got a null result";
            }
            return result;
        }
        catch (SeleniumCommandTimedOutException e) {
            return "ERROR: Command timed out";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doCommandWithoutWaitingForAResponse(String command, String field, String value) throws WindowClosedException {
        if (millisecondDelayBetweenOperations > 0) {
            log.debug("    Slow mode in effect: sleep " + millisecondDelayBetweenOperations + " milliseconds...");
            try {
                Thread.sleep(millisecondDelayBetweenOperations);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            log.debug("    ...done");
        }
        SingleEntryAsyncQueue singleEntryAsyncQueue = this.commandResultHolder;
        synchronized (singleEntryAsyncQueue) {
            if (this.commandResultHolder.isEmpty()) {
                this.commandResultHolder.clear();
            } else if (SeleniumServer.isProxyInjectionMode() && "OK".equals(this.commandResultHolder.peek())) {
                if (command.startsWith("wait")) {
                    if (log.isDebugEnabled()) {
                        log.debug("Page load beat the wait command.  Leave the result to be picked up below");
                    }
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug("Apparently a page load result preceded the command; will ignore it...");
                    }
                    this.commandResultHolder.put(null);
                }
            } else {
                if ("Current window or frame is closed!".equals(this.commandResultHolder.peek())) {
                    throw new WindowClosedException();
                }
                throw new RuntimeException("unexpected result " + this.commandResultHolder.peek());
            }
        }
        singleEntryAsyncQueue = this.commandHolder;
        synchronized (singleEntryAsyncQueue) {
            if (!this.commandHolder.isEmpty()) {
                throw new RuntimeException("unexpected command " + this.commandHolder.peek() + " in place before new command " + command + " could be added.");
            }
        }
        this.queuePut("commandHolder", this.commandHolder, new DefaultRemoteCommand(command, field, value, this.makeJavaScript()), this.commandReady);
    }

    private String makeJavaScript() {
        return InjectionHelper.restoreJsStateInitializer(this.sessionId, this.uniqueId);
    }

    private Object queueGet(String caller, SingleEntryAsyncQueue q, Condition condition) {
        boolean clearedEarlierThread = false;
        String hdr = "\t" + this.getIdentification(caller) + " queueGet() ";
        if (log.isDebugEnabled()) {
            log.debug(hdr + "called" + (clearedEarlierThread ? " (superceding other blocked thread)" : ""));
        }
        Object object = q.get();
        if (log.isDebugEnabled()) {
            log.debug(hdr + "-> " + object);
        }
        return object;
    }

    private void queuePut(String caller, SingleEntryAsyncQueue q, Object thing, Condition condition) {
        String hdr = "\t" + this.getIdentification(caller) + " queuePut";
        if (log.isDebugEnabled()) {
            log.debug(hdr + "(" + thing + ")");
        }
        try {
            q.put(thing);
        }
        catch (SingleEntryAsyncQueueOverflow e) {
            log.debug(hdr + " caused " + e);
            throw e;
        }
        condition.signalAll();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.closed) {
            sb.append("CLOSED ");
        }
        sb.append("{ commandHolder=");
        sb.append(this.commandHolder.toString()).append(", ").append(" commandResultHolder=").append(this.commandResultHolder.toString()).append(" }");
        return sb.toString();
    }

    public RemoteCommand handleCommandResult(String commandResult) {
        this.handleCommandResultWithoutWaitingForAResponse(commandResult);
        this.browserResponseSequencer.increaseNum();
        return this.getNextCommand();
    }

    private RemoteCommand getNextCommand() {
        RemoteCommand sc = (RemoteCommand)this.queueGet("commandHolder", this.commandHolder, this.commandReady);
        return sc;
    }

    public void handleCommandResultWithoutWaitingForAResponse(String commandResult) {
        if (commandResult != null) {
            if (!this.resultExpected) {
                if (this.commandResultHolder.hasBlockedGetter()) {
                    throw new RuntimeException("blocked getter for " + this + " but !resultExpected");
                }
                if (SeleniumServer.isProxyInjectionMode()) {
                    if (commandResult.startsWith("OK")) {
                        if (log.isDebugEnabled()) {
                            log.debug("Saw page load no one was waiting for.");
                        }
                        this.queuePutResult(commandResult);
                    }
                } else if (commandResult.startsWith("OK")) {
                    throw new RuntimeException(this.getIdentification("commandResultHolder") + " unexpected value " + commandResult);
                }
            } else {
                this.queuePutResult(commandResult);
            }
        }
    }

    private void queuePutResult(String commandResult) {
        if (SeleniumServer.isProxyInjectionMode() && !this.commandResultHolder.isEmpty()) {
            this.commandHolder.clear();
            log.debug("clearing out old window thread(s?) for " + this + "; replaced result with " + commandResult);
        }
        this.queuePut("commandResultHolder", this.commandResultHolder, commandResult, this.resultArrived);
    }

    private String getIdentification(String caller) {
        StringBuffer sb = new StringBuffer();
        if (this.uniqueId != null) {
            sb.append(this.uniqueId).append(' ');
        }
        sb.append(caller).append(' ').append(this.uniqueId);
        String s = sb.toString();
        if (s.endsWith("null") && log.isDebugEnabled()) {
            log.debug("caller identification came in ending with null");
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void discardCommandResult() {
        this.dataLock.lock();
        try {
            this.queueGetResult("commandResultHolder discard");
        }
        finally {
            this.dataLock.unlock();
        }
    }

    public void endOfLife() {
        this.commandResultHolder.clear();
        this.commandResultHolder = null;
        this.commandHolder.clear();
        this.commandHolder = null;
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    public FrameAddress getFrameAddress() {
        return this.frameAddress;
    }

    public void setFrameAddress(FrameAddress frameAddress) {
        this.frameAddress = frameAddress;
    }

    public SingleEntryAsyncQueue getCommandResultHolder() {
        return this.commandResultHolder;
    }

    public void setResultExpected(boolean resultExpected) {
        this.resultExpected = resultExpected;
    }

    public boolean isResultExpected() {
        return this.resultExpected;
    }

    public static void setSpeed(int i) {
        millisecondDelayBetweenOperations = i;
    }

    public static int getSpeed() {
        return millisecondDelayBetweenOperations;
    }

    public boolean isWindowPointedToByJsVariable(String jsVariableName) {
        Boolean isPointingAtThisWindow = this.cachedJsVariableNamesPointingAtThisWindow.get(jsVariableName);
        if (isPointingAtThisWindow == null) {
            isPointingAtThisWindow = false;
            this.cachedJsVariableNamesPointingAtThisWindow.put(jsVariableName, isPointingAtThisWindow);
        }
        return isPointingAtThisWindow;
    }

    public void addJsWindowNameVar(String jsWindowNameVar) {
        this.cachedJsVariableNamesPointingAtThisWindow.put(jsWindowNameVar, true);
    }

    public void declareClosed() {
        this.closed = true;
        if (this.commandResultHolder.isEmpty()) {
            this.handleCommandResultWithoutWaitingForAResponse("Current window or frame is closed!");
        }
        this.browserResponseSequencer.increaseNum();
    }

    public boolean isClosed() {
        return this.closed;
    }

    public BrowserResponseSequencer getBrowserResponseSequencer() {
        return this.browserResponseSequencer;
    }
}

