/*
 * Decompiled with CFR 0.152.
 */
package com.ochafik.lang;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SyntaxUtils {
    static Map<Class<?>, Converter<?>> converters = new LinkedHashMap();

    public static <T> T[] array(T ... elements) {
        return elements;
    }

    public static <T> boolean equal(T a, T b) {
        if (a == null) {
            return b == null;
        }
        if (b == null) {
            return false;
        }
        return a == b || a.equals(b);
    }

    public static <T> T as(Object value, Class<T> c) {
        if (value == null) {
            return null;
        }
        if (c.isAssignableFrom(value.getClass())) {
            return c.cast(value);
        }
        return null;
    }

    public static <T> void registerConverter(Class<T> c, Converter<T> converter) {
        converters.put(c, converter);
    }

    public static <T> T convert(Object value, Class<T> c) {
        if (value == null) {
            return null;
        }
        Class<?> type = value.getClass();
        if (c.isAssignableFrom(type)) {
            return c.cast(value);
        }
        Converter<?> converter = converters.get(c);
        if (converter != null) {
            try {
                return (T)converter.convert(value);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (Constructor<?> constructor : c.getConstructors()) {
            Class<?>[] parameterTypes = constructor.getParameterTypes();
            if (parameterTypes.length != 1 || !parameterTypes[0].isAssignableFrom(type)) continue;
            try {
                return (T)constructor.newInstance(value);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (Executable executable : c.getMethods()) {
            Class<?>[] parameterTypes;
            String name = ((Method)executable).getName();
            if ((((Method)executable).getModifiers() & 8) == 0 || !" parse createInstance newInstance ".contains(" " + name + " ") || (parameterTypes = ((Method)executable).getParameterTypes()).length != 1 || !parameterTypes[0].isAssignableFrom(type)) continue;
            try {
                return (T)((Method)executable).invoke(null, value);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static <K, V> EasyMap<K, V> map(K key, V value) {
        return new EasyMap<K, V>().add(key, value);
    }

    public static Iterable<Node> iterable(final NodeList list) {
        if (list == null) {
            return Collections.EMPTY_LIST;
        }
        return new Iterable<Node>(){
            int nextPos = 0;

            @Override
            public Iterator<Node> iterator() {
                return new Iterator<Node>(){

                    @Override
                    public Node next() {
                        if (nextPos >= list.getLength()) {
                            throw new NoSuchElementException();
                        }
                        return list.item(nextPos++);
                    }

                    @Override
                    public boolean hasNext() {
                        return nextPos < list.getLength();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    static {
        SyntaxUtils.registerConverter(Date.class, new Converter<Date>(){

            @Override
            public Date convert(Object value) throws ParseException {
                String s = value.toString();
                Date date = DateFormat.getDateTimeInstance().parse(s);
                if (date == null) {
                    date = DateFormat.getDateInstance().parse(s);
                }
                return date;
            }
        });
        SyntaxUtils.registerConverter(Double.class, new Converter<Double>(){

            @Override
            public Double convert(Object value) throws ParseException {
                if (value instanceof Number) {
                    return ((Number)value).doubleValue();
                }
                String s = value.toString();
                if (s.length() == 0) {
                    return 0.0;
                }
                return Double.parseDouble(s);
            }
        });
        SyntaxUtils.registerConverter(Float.class, new Converter<Float>(){

            @Override
            public Float convert(Object value) throws ParseException {
                if (value instanceof Number) {
                    return Float.valueOf(((Number)value).floatValue());
                }
                String s = value.toString();
                if (s.length() == 0) {
                    return Float.valueOf(0.0f);
                }
                return Float.valueOf(Float.parseFloat(s));
            }
        });
        SyntaxUtils.registerConverter(Long.class, new Converter<Long>(){

            @Override
            public Long convert(Object value) throws ParseException {
                if (value instanceof Number) {
                    return ((Number)value).longValue();
                }
                String s = value.toString();
                if (s.length() == 0) {
                    return 0L;
                }
                return Long.parseLong(s);
            }
        });
        SyntaxUtils.registerConverter(Integer.class, new Converter<Integer>(){

            @Override
            public Integer convert(Object value) throws ParseException {
                if (value instanceof Number) {
                    return ((Number)value).intValue();
                }
                String s = value.toString();
                if (s.length() == 0) {
                    return 0;
                }
                return Integer.parseInt(s);
            }
        });
        SyntaxUtils.registerConverter(Short.class, new Converter<Short>(){

            @Override
            public Short convert(Object value) throws ParseException {
                if (value instanceof Number) {
                    return ((Number)value).shortValue();
                }
                String s = value.toString();
                if (s.length() == 0) {
                    return (short)0;
                }
                return Short.parseShort(s);
            }
        });
        SyntaxUtils.registerConverter(String.class, new Converter<String>(){

            @Override
            public String convert(Object value) throws ParseException {
                if (value instanceof Date) {
                    return DateFormat.getDateInstance().format((Date)value);
                }
                return value.toString();
            }
        });
        SyntaxUtils.registerConverter(File.class, new Converter<File>(){

            @Override
            public File convert(Object value) throws ParseException {
                if (value instanceof URI) {
                    try {
                        value = ((URI)value).toURL();
                    }
                    catch (MalformedURLException e1) {
                        // empty catch block
                    }
                }
                if (value instanceof String) {
                    try {
                        value = new URL((String)value);
                    }
                    catch (MalformedURLException e) {
                        // empty catch block
                    }
                }
                if (value instanceof URL) {
                    return new File(((URL)value).getFile());
                }
                String s = value.toString();
                if (s.length() == 0) {
                    return null;
                }
                return new File(s);
            }
        });
        SyntaxUtils.registerConverter(URL.class, new Converter<URL>(){

            @Override
            public URL convert(Object value) {
                String s;
                if (value instanceof URI) {
                    try {
                        return ((URI)value).toURL();
                    }
                    catch (MalformedURLException e1) {
                        // empty catch block
                    }
                }
                if (value instanceof File) {
                    try {
                        return ((File)value).toURI().toURL();
                    }
                    catch (MalformedURLException e1) {
                        // empty catch block
                    }
                }
                if ((s = value.toString()).length() == 0) {
                    return null;
                }
                try {
                    return new URL(s);
                }
                catch (MalformedURLException e) {
                    try {
                        return new File(s).toURI().toURL();
                    }
                    catch (MalformedURLException malformedURLException) {
                        return null;
                    }
                }
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EasyMap<K, V>
    extends LinkedHashMap<K, V> {
        private static final long serialVersionUID = -3087972422440202407L;

        public EasyMap<K, V> add(K key, V value) {
            this.put(key, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface Converter<T> {
        public T convert(Object var1) throws Exception;
    }
}

